/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.RateExceededException;
import org.apache.pekko.stream.ThrottleMode;
import org.apache.pekko.stream.ThrottleMode$Enforcing$;
import org.apache.pekko.stream.impl.Throttle$;
import org.apache.pekko.stream.impl.Throttle$TimerKey$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.NanoTimeTokenBucket;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-vA\u0002\u0012$\u0011\u00039SF\u0002\u00040G!\u0005q\u0005\r\u0005\u0006o\u0005!\t!\u000f\u0005\bu\u0005\u0011\r\u0011\"\u0002<\u0011\u0019q\u0014\u0001)A\u0007y\u001d)q(\u0001EE\u0001\u001a)!)\u0001EE\u0007\")qG\u0002C\u0001\u0015\"91JBA\u0001\n\u0003b\u0005bB+\u0007\u0003\u0003%\tA\u0016\u0005\b5\u001a\t\t\u0011\"\u0001\\\u0011\u001d\tg!!A\u0005B\tDq!\u001b\u0004\u0002\u0002\u0013\u0005!\u000eC\u0004p\r\u0005\u0005I\u0011\t9\t\u000fE4\u0011\u0011!C!e\"91OBA\u0001\n\u0013!hAB\u0018$\u0001\u001d\n\t\u0001C\u0005\u0002:A\u0011)\u0019!C\u0001-\"I\u00111\b\t\u0003\u0002\u0003\u0006Ia\u0016\u0005\u000b\u0003{\u0001\"Q1A\u0005\u0002\u0005}\u0002BCA)!\t\u0005\t\u0015!\u0003\u0002B!I\u00111\u000b\t\u0003\u0006\u0004%\tA\u0016\u0005\n\u0003+\u0002\"\u0011!Q\u0001\n]C!\"a\u0016\u0011\u0005\u000b\u0007I\u0011AA-\u0011)\t\t\u0007\u0005B\u0001B\u0003%\u00111\f\u0005\u000b\u0003G\u0002\"Q1A\u0005\u0002\u0005\u0015\u0004BCA8!\t\u0005\t\u0015!\u0003\u0002h!1q\u0007\u0005C\u0001\u0003cB\u0011\"a \u0011\u0005\u0004%I!!!\t\u0011\u0005%\u0005\u0003)A\u0005\u0003\u0007C\u0011\"a#\u0011\u0005\u0004%\t!!!\t\u0011\u00055\u0005\u0003)A\u0005\u0003\u0007Cq!a$\u0011\t\u0003\n\t\nC\u0003r!\u0011\u0005#/\u0001\u0005UQJ|G\u000f\u001e7f\u0015\t!S%\u0001\u0003j[Bd'B\u0001\u0014(\u0003\u0019\u0019HO]3b[*\u0011\u0001&K\u0001\u0006a\u0016\\7n\u001c\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014x\r\u0005\u0002/\u00035\t1E\u0001\u0005UQJ|G\u000f\u001e7f'\t\t\u0011\u0007\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\tQ&A\u000bBkR|W.\u0019;jG6\u000b\u00070[7v[\n+(o\u001d;\u0016\u0003qz\u0011!P\u000f\u0002\u007f\b1\u0012)\u001e;p[\u0006$\u0018nY'bq&lW/\u001c\"veN$\b%\u0001\u0005US6,'oS3z!\t\te!D\u0001\u0002\u0005!!\u0016.\\3s\u0017\u0016L8\u0003\u0002\u00042\t\u001e\u0003\"AM#\n\u0005\u0019\u001b$a\u0002)s_\u0012,8\r\u001e\t\u0003e!K!!S\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003\u0001\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#A'\u0011\u00059\u001bV\"A(\u000b\u0005A\u000b\u0016\u0001\u00027b]\u001eT\u0011AU\u0001\u0005U\u00064\u0018-\u0003\u0002U\u001f\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012a\u0016\t\u0003eaK!!W\u001a\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005q{\u0006C\u0001\u001a^\u0013\tq6GA\u0002B]fDq\u0001\u0019\u0006\u0002\u0002\u0003\u0007q+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002GB\u0019Am\u001a/\u000e\u0003\u0015T!AZ\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002iK\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\tYg\u000e\u0005\u00023Y&\u0011Qn\r\u0002\b\u0005>|G.Z1o\u0011\u001d\u0001G\"!AA\u0002q\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002/\u0006AAo\\*ue&tw\rF\u0001N\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003U\u0004\"A\u0014<\n\u0005]|%AB(cU\u0016\u001cG\u000f\u000b\u0002\u0002sB\u0011!0`\u0007\u0002w*\u0011ApJ\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001@|\u0005-Ie\u000e^3s]\u0006d\u0017\t]5)\u0005\u0001IX\u0003BA\u0002\u0003[\u00192\u0001EA\u0003!\u0019\t9!a\t\u0002*9!\u0011\u0011BA\u000f\u001d\u0011\tY!!\u0007\u000f\t\u00055\u0011q\u0003\b\u0005\u0003\u001f\t)B\u0004\u0003\u0002\u0012\u0005MQ\"A\u0015\n\u0005!J\u0013B\u0001\u0014(\u0013\t!S%C\u0002\u0002\u001c\r\naAZ;tS:<\u0017\u0002BA\u0010\u0003C\t1b\u0012:ba\"\u001cF/Y4fg*\u0019\u00111D\u0012\n\t\u0005\u0015\u0012q\u0005\u0002\u0017'&l\u0007\u000f\\3MS:,\u0017M]$sCBD7\u000b^1hK*!\u0011qDA\u0011!\u0011\tY#!\f\r\u0001\u00119\u0011q\u0006\tC\u0002\u0005E\"!\u0001+\u0012\u0007\u0005MB\fE\u00023\u0003kI1!a\u000e4\u0005\u001dqu\u000e\u001e5j]\u001e\fAaY8ti\u0006)1m\\:uA\u0005\u0019\u0001/\u001a:\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\tIV\u0014\u0018\r^5p]*\u0019\u00111J\u001a\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002P\u0005\u0015#A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0005a\u0016\u0014\b%\u0001\u0007nCbLW.^7CkJ\u001cH/A\u0007nCbLW.^7CkJ\u001cH\u000fI\u0001\u0010G>\u001cHoQ1mGVd\u0017\r^5p]V\u0011\u00111\f\t\u0007e\u0005u\u0013\u0011F,\n\u0007\u0005}3GA\u0005Gk:\u001cG/[8oc\u0005\u00012m\\:u\u0007\u0006d7-\u001e7bi&|g\u000eI\u0001\u0005[>$W-\u0006\u0002\u0002hA!\u0011\u0011NA6\u001b\u0005)\u0013bAA7K\taA\u000b\u001b:piRdW-T8eK\u0006)Qn\u001c3fAQa\u00111OA;\u0003o\nI(a\u001f\u0002~A!a\u0006EA\u0015\u0011\u0019\tId\u0007a\u0001/\"9\u0011QH\u000eA\u0002\u0005\u0005\u0003BBA*7\u0001\u0007q\u000bC\u0004\u0002Xm\u0001\r!a\u0017\t\u000f\u0005\r4\u00041\u0001\u0002h\u0005\u0011b.\u00198pg\n+Go^3f]R{7.\u001a8t+\t\t\u0019\tE\u00023\u0003\u000bK1!a\"4\u0005\u0011auN\\4\u0002'9\fgn\\:CKR<X-\u001a8U_.,gn\u001d\u0011\u0002+\u00154g-Z2uSZ,W*\u0019=j[Vl')\u001e:ti\u00061RM\u001a4fGRLg/Z'bq&lW/\u001c\"veN$\b%A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BAJ\u0003?\u0003B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033+\u0013!B:uC\u001e,\u0017\u0002BAO\u0003/\u0013qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0005\b\u0003C\u0003\u0003\u0019AAR\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t!\u0011\tI'!*\n\u0007\u0005\u001dVE\u0001\u0006BiR\u0014\u0018NY;uKND#\u0001E=")
@InternalApi
public class Throttle<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int cost;
    private final FiniteDuration per;
    private final int maximumBurst;
    private final Function1<T, Object> costCalculation;
    private final ThrottleMode mode;
    private final long org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens;
    private final long effectiveMaximumBurst;

    public static int AutomaticMaximumBurst() {
        return Throttle$.MODULE$.AutomaticMaximumBurst();
    }

    public int cost() {
        return this.cost;
    }

    public FiniteDuration per() {
        return this.per;
    }

    public int maximumBurst() {
        return this.maximumBurst;
    }

    public Function1<T, Object> costCalculation() {
        return this.costCalculation;
    }

    public ThrottleMode mode() {
        return this.mode;
    }

    public long org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens() {
        return this.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens;
    }

    public long effectiveMaximumBurst() {
        return this.effectiveMaximumBurst;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final NanoTimeTokenBucket tokenBucket;
            private T currentElement;
            private final /* synthetic */ Throttle $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private NanoTimeTokenBucket tokenBucket() {
                return this.tokenBucket;
            }

            private T currentElement() {
                return this.currentElement;
            }

            private void currentElement_$eq(T x$1) {
                this.currentElement = x$1;
            }

            public void preStart() {
                this.tokenBucket().init();
            }

            public void onUpstreamFinish() {
                if (!this.isAvailable(this.$outer.out()) || !this.isTimerActive(Throttle$TimerKey$.MODULE$)) {
                    this.completeStage();
                    return;
                }
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                int cost = BoxesRunTime.unboxToInt(this.$outer.costCalculation().apply(elem));
                long delayNanos = this.tokenBucket().offer(cost);
                if (delayNanos == 0L) {
                    this.push(this.$outer.out(), elem);
                    return;
                }
                if (this.$outer.mode() == ThrottleMode$Enforcing$.MODULE$) {
                    this.failStage(new RateExceededException("Maximum throttle throughput exceeded."));
                    return;
                }
                this.currentElement_$eq(elem);
                this.scheduleOnce((Object)Throttle$TimerKey$.MODULE$, new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos());
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onTimer(Object key) {
                this.push(this.$outer.out(), this.currentElement());
                this.currentElement_$eq(null);
                if (this.isClosed(this.$outer.in())) {
                    this.completeStage();
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                this.tokenBucket = new NanoTimeTokenBucket($outer.effectiveMaximumBurst(), $outer.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens());
                this.setHandlers($outer.in(), $outer.out(), this);
            }
        };
    }

    public String toString() {
        return "Throttle";
    }

    public Throttle(int cost, FiniteDuration per, int maximumBurst, Function1<T, Object> costCalculation, ThrottleMode mode) {
        this.cost = cost;
        this.per = per;
        this.maximumBurst = maximumBurst;
        this.costCalculation = costCalculation;
        this.mode = mode;
        Predef$.MODULE$.require(cost > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "cost must be > 0");
        Predef$.MODULE$.require(per.toNanos() > 0L, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "per time must be > 0");
        Predef$.MODULE$.require(per.toNanos() >= (long)cost, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Rates larger than 1 unit / nanosecond are not supported");
        this.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens = per.toNanos() / (long)cost;
        this.effectiveMaximumBurst = maximumBurst == -1 ? package$.MODULE$.max(1L, 100000000L / this.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens()) : (long)maximumBurst;
        ThrottleMode throttleMode = mode;
        ThrottleMode$Enforcing$ throttleMode$Enforcing$ = ThrottleMode$Enforcing$.MODULE$;
        Predef$.MODULE$.require((throttleMode != null ? !throttleMode.equals(throttleMode$Enforcing$) : throttleMode$Enforcing$ != null) || this.effectiveMaximumBurst() >= 0L, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "maximumBurst must be > 0 in Enforcing mode");
    }
}

