/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.LightArrayRevolverScheduler$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.SchedulerException;
import org.apache.pekko.dispatch.AbstractNodeQueue;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.Unsafe;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B!C\u0001-C\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"Aq\u000e\u0001B\u0001B\u0003%\u0001\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0004\u007f\u0001\t\u0007I\u0011A@\t\u0011\u0005\u001d\u0001\u0001)A\u0005\u0003\u0003A\u0011\"!\u0003\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005m\u0001\u0001)A\u0005\u0003\u001bA\u0011\"!\b\u0001\u0005\u0004%\t!a\u0003\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u001bAq!!\t\u0001\t\u0013\t\u0019\u0003C\u0004\u0002*\u0001!\t\"a\u000b\t\r\u0005M\u0002\u0001\"\u0005\u0000\u0011\u001d\t)\u0004\u0001C\t\u0003\u0017Aq!a\u000e\u0001\t#\tI\u0004C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005]\u0004\u0001\"\u0011\u0002z!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0005bBAI\u0001\u0011\u0005\u00131\u0013\u0005\n\u0003+\u0003!\u0019!C!\u0003/C\u0001\"a(\u0001A\u0003%\u0011\u0011\u0014\u0005\n\u0003C\u0003!\u0019!C\u0005\u0003GC\u0001\"!*\u0001A\u0003%\u0011Q\u0006\u0005\n\u0003O\u0003!\u0019!C\u0005\u0003GC\u0001\"!+\u0001A\u0003%\u0011Q\u0006\u0005\t\u0003W\u0003!\u0019!C\u0005\u007f\"A\u0011Q\u0016\u0001!\u0002\u0013\t\t\u0001C\u0005\u00020\u0002\u0011\r\u0011\"\u0003\u00022\"A!Q\u000b\u0001!\u0002\u0013\t\u0019\fC\u0004\u0002x\u0001!IAa\u0016\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!I!Q\u000e\u0001C\u0002\u0013%!q\u000e\u0005\t\u0005'\u0003\u0001\u0015!\u0003\u0003r!9!Q\u0013\u0001\u0005\n\t]\u0005\"\u0003BP\u0001\u0001\u0007I\u0011\u0002BQ\u0011%\u0011I\u000b\u0001a\u0001\n\u0013\u0011Y\u000b\u0003\u0005\u00030\u0002\u0001\u000b\u0015\u0002BR\u000f\u001d\t9L\u0011E\u0001\u0003s3a!\u0011\"\t\u0002\u0005m\u0006B\u0002=(\t\u0003\ti\f\u0003\u0005\u0002@\u001e\u0002\u000b\u0011BA\u0017\r\u0019\t\tm\n\u0003\u0002D\"1\u0001P\u000bC\u0001\u0005o1!\"!9(!\u0003\r\nBQAr\r\u001d\t)n\n\u0005C\u0003/D!\"!:.\u0005\u0003\u0007I\u0011AAt\u0011)\tI/\fBA\u0002\u0013\u0005\u00111\u001e\u0005\u000b\u0003cl#\u0011!Q!\n\u0005\r\u0004\"CA~[\t\u0005\r\u0011\"\u0001\u0000\u0011)\ti0\fBA\u0002\u0013\u0005\u0011q \u0005\u000b\u0005\u0007i#\u0011!Q!\n\u0005\u0005\u0001B\u0003B\u0003[\t\u0005\t\u0015!\u0003\u0002X!1\u00010\fC\u0001\u0005\u000fAqAa\u0004.\t\u001b\u0011\t\u0002\u0003\u0005\u0003&5\")\u0001\u0012B\u0014\u0011\u001d\u0011y#\fC!\u0003'CqA!\r.\t\u0003\u00129\u0003C\u0004\u000345\"\tE!\u000e\t\u0011\tmr\u0005)A\u0005\u0005{A\u0001Ba\u0011(A\u0003%!Q\t\u0005\n\u0005\u0013:#\u0019!C\u0005\u0005\u0017B\u0001B!\u0014(A\u0003%\u0011q\u001c\u0005\n\u0005\u001f:#\u0019!C\u0005\u0005#B\u0001Ba\u0015(A\u0003%\u0011Q\n\u0002\u001c\u0019&<\u0007\u000e^!se\u0006L(+\u001a<pYZ,'oU2iK\u0012,H.\u001a:\u000b\u0005\r#\u0015!B1di>\u0014(BA#G\u0003\u0015\u0001Xm[6p\u0015\t9\u0005*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0006\u0019qN]4\u0004\u0001M!\u0001\u0001\u0014*W!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0019\te.\u001f*fMB\u00111\u000bV\u0007\u0002\u0005&\u0011QK\u0011\u0002\n'\u000eDW\rZ;mKJ\u0004\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0005%|'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013\u0011b\u00117pg\u0016\f'\r\\3\u0002\r\r|gNZ5h!\t\u0001g-D\u0001b\u0015\tq&M\u0003\u0002dI\u0006AA/\u001f9fg\u00064WMC\u0001f\u0003\r\u0019w.\\\u0005\u0003O\u0006\u0014aaQ8oM&<\u0017a\u00017pOB\u0011!.\\\u0007\u0002W*\u0011A\u000eR\u0001\u0006KZ,g\u000e^\u0005\u0003].\u0014a\u0002T8hO&tw-\u00113baR,'/A\u0007uQJ,\u0017\r\u001a$bGR|'/\u001f\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f!bY8oGV\u0014(/\u001a8u\u0015\t)(,\u0001\u0003vi&d\u0017BA<s\u00055!\u0006N]3bI\u001a\u000b7\r^8ss\u00061A(\u001b8jiz\"BA_>}{B\u00111\u000b\u0001\u0005\u0006=\u0012\u0001\ra\u0018\u0005\u0006Q\u0012\u0001\r!\u001b\u0005\u0006_\u0012\u0001\r\u0001]\u0001\n/\",W\r\\*ju\u0016,\"!!\u0001\u0011\u00075\u000b\u0019!C\u0002\u0002\u00069\u00131!\u00138u\u0003)9\u0006.Z3m'&TX\rI\u0001\r)&\u001c7\u000eR;sCRLwN\\\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u00185\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0005ekJ\fG/[8o\u0015\t\u0019h*\u0003\u0003\u0002\u001a\u0005E!A\u0004$j]&$X\rR;sCRLwN\\\u0001\u000e)&\u001c7\u000eR;sCRLwN\u001c\u0011\u0002\u001fMCW\u000f\u001e3po:$\u0016.\\3pkR\f\u0001c\u00155vi\u0012|wO\u001c+j[\u0016|W\u000f\u001e\u0011\u0002\u000fI|WO\u001c3VaR!\u0011QBA\u0013\u0011\u001d\t9c\u0003a\u0001\u0003\u001b\t\u0011\u0001Z\u0001\u0006G2|7m\u001b\u000b\u0003\u0003[\u00012!TA\u0018\u0013\r\t\tD\u0014\u0002\u0005\u0019>tw-A\u0005ti\u0006\u0014H\u000fV5dW\u0006\u0011r-\u001a;TQV$Hm\\<o)&lWm\\;u\u0003%9\u0018-\u001b;OC:|7\u000f\u0006\u0003\u0002<\u0005\u0005\u0003cA'\u0002>%\u0019\u0011q\b(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007z\u0001\u0019AA\u0017\u0003\u0015q\u0017M\\8t\u0003Y\u00198\r[3ek2,w+\u001b;i\r&DX\r\u001a#fY\u0006LHCBA%\u0003_\n\u0019\b\u0006\u0003\u0002L\u0005}C\u0003BA'\u0003'\u00022aUA(\u0013\r\t\tF\u0011\u0002\f\u0007\u0006t7-\u001a7mC\ndW\rC\u0004\u0002VA\u0001\u001d!a\u0016\u0002\u0011\u0015DXmY;u_J\u0004B!!\u0017\u0002\\5\u0011\u0011QC\u0005\u0005\u0003;\n)B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011\u0011\r\tA\u0002\u0005\r\u0014\u0001\u0003:v]:\f'\r\\3\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001b[\u0003\u0011a\u0017M\\4\n\t\u00055\u0014q\r\u0002\t%Vtg.\u00192mK\"9\u0011\u0011\u000f\tA\u0002\u00055\u0011\u0001D5oSRL\u0017\r\u001c#fY\u0006L\bbBA;!\u0001\u0007\u0011QB\u0001\u0006I\u0016d\u0017-_\u0001\tg\u000eDW\rZ;mKRA\u00111PA@\u0003\u0003\u000b\u0019\t\u0006\u0003\u0002N\u0005u\u0004bBA+#\u0001\u000f\u0011q\u000b\u0005\b\u0003c\n\u0002\u0019AA\u0007\u0011\u001d\t)(\u0005a\u0001\u0003\u001bAq!!\u0019\u0012\u0001\u0004\t\u0019'\u0001\u0007tG\",G-\u001e7f\u001f:\u001cW\r\u0006\u0004\u0002\n\u00065\u0015q\u0012\u000b\u0005\u0003\u001b\nY\tC\u0004\u0002VI\u0001\u001d!a\u0016\t\u000f\u0005U$\u00031\u0001\u0002\u000e!9\u0011\u0011\r\nA\u0002\u0005\r\u0014!B2m_N,GCAA\u001e\u00031i\u0017\r\u001f$sKF,XM\\2z+\t\tI\nE\u0002N\u00037K1!!(O\u0005\u0019!u.\u001e2mK\u0006iQ.\u0019=Ge\u0016\fX/\u001a8ds\u0002\nQa\u001d;beR,\"!!\f\u0002\rM$\u0018M\u001d;!\u0003%!\u0018nY6OC:|7/\u0001\u0006uS\u000e\\g*\u00198pg\u0002\n\u0011b\u001e5fK2l\u0015m]6\u0002\u0015]DW-\u001a7NCN\\\u0007%A\u0003rk\u0016,X-\u0006\u0002\u00024B\u0019\u0011Q\u0017\u0016\u000f\u0005M3\u0013a\u0007'jO\"$\u0018I\u001d:bsJ+go\u001c7wKJ\u001c6\r[3ek2,'\u000f\u0005\u0002TOM\u0011q\u0005\u0014\u000b\u0003\u0003s\u000b!\u0002^1tW>3gm]3u\u0005%!\u0016m]6Rk\u0016,XmE\u0002+\u0003\u000b\u0004b!a2\u0002N\u0006EWBAAe\u0015\r\tY\rR\u0001\tI&\u001c\b/\u0019;dQ&!\u0011qZAe\u0005E\t%m\u001d;sC\u000e$hj\u001c3f#V,W/\u001a\t\u0004\u0003'lS\"A\u0014\u0003\u0015Q\u000b7o\u001b%pY\u0012,'oE\u0003.\u00033\fy\u000e\u0005\u0003\u0002f\u0005m\u0017\u0002BAo\u0003O\u0012aa\u00142kK\u000e$\bcAAjY\tIA+[7feR\u000b7o[\n\bY\u0005e\u00171MA'\u0003\u0011!\u0018m]6\u0016\u0005\u0005\r\u0014\u0001\u0003;bg.|F%Z9\u0015\t\u0005m\u0012Q\u001e\u0005\n\u0003_|\u0013\u0011!a\u0001\u0003G\n1\u0001\u001f\u00132\u0003\u0015!\u0018m]6!Q\r\u0001\u0014Q\u001f\t\u0004\u001b\u0006]\u0018bAA}\u001d\nAao\u001c7bi&dW-A\u0003uS\u000e\\7/A\u0005uS\u000e\\7o\u0018\u0013fcR!\u00111\bB\u0001\u0011%\tyOMA\u0001\u0002\u0004\t\t!\u0001\u0004uS\u000e\\7\u000fI\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR$\u0002\"!5\u0003\n\t-!Q\u0002\u0005\b\u0003K,\u0004\u0019AA2\u0011\u001d\tY0\u000ea\u0001\u0003\u0003AqA!\u00026\u0001\u0004\t9&A\u0006fqR\u0014\u0018m\u0019;UCN\\G\u0003BA2\u0005'AqA!\u00067\u0001\u0004\t\u0019'A\u0006sKBd\u0017mY3XSRD\u0007f\u0001\u001c\u0003\u001aA!!1\u0004B\u0011\u001b\t\u0011iBC\u0002\u0003 9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019C!\b\u0003\u000fQ\f\u0017\u000e\u001c:fG\u0006YQ\r_3dkR,G+Y:l)\t\u0011I\u0003E\u0002N\u0005WI1A!\fO\u0005\u001d\u0011un\u001c7fC:\f1A];o\u0003\u0019\u0019\u0017M\\2fY\u0006Y\u0011n]\"b]\u000e,G\u000e\\3e+\t\u0011I\u0003\u0006\u0002\u0003:A\u0019\u00111\u001b\u0016\u0002\u001b\r\u000bgnY3mY\u0016$G+Y:l%\u0019\u0011y$!7\u0002d\u00191!\u0011I\u001e\u0001\u0005{\u0011A\u0002\u0010:fM&tW-\\3oiz\nA\"\u0012=fGV$X\r\u001a+bg.\u0014bAa\u0012\u0002Z\u0006\rdA\u0002B!y\u0001\u0011)%\u0001\bO_R\u001c\u0015M\\2fY2\f'\r\\3\u0016\u0005\u0005}\u0017a\u0004(pi\u000e\u000bgnY3mY\u0006\u0014G.\u001a\u0011\u0002'%s\u0017\u000e^5bYJ+\u0007/Z1u\u001b\u0006\u00148.\u001a:\u0016\u0005\u00055\u0013\u0001F%oSRL\u0017\r\u001c*fa\u0016\fG/T1sW\u0016\u0014\b%\u0001\u0004rk\u0016,X\r\t\u000b\t\u00053\u0012YFa\u0018\u0003dA\u0019\u0011Q\u0017\u0017\t\u000f\tuc\u00041\u0001\u0002X\u0005\u0011Qm\u0019\u0005\b\u0005Cr\u0002\u0019AA2\u0003\u0005\u0011\bbBA;=\u0001\u0007\u0011QB\u0001\u000eG\",7m['bq\u0012+G.Y=\u0015\t\u0005m\"\u0011\u000e\u0005\b\u0005Wz\u0002\u0019AA\u0017\u0003)!W\r\\1z\u001d\u0006twn]\u0001\bgR|\u0007\u000f]3e+\t\u0011\t\b\u0005\u0004\u0003t\te$QP\u0007\u0003\u0005kR1Aa\u001es\u0003\u0019\tGo\\7jG&!!1\u0010B;\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CBA-\u0005\u007f\u0012\u0019)\u0003\u0003\u0003\u0002\u0006U!a\u0002)s_6L7/\u001a\t\u0007\u0005\u000b\u0013yI!\u0017\u000e\u0005\t\u001d%\u0002\u0002BE\u0005\u0017\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0007\t5e*\u0001\u0006d_2dWm\u0019;j_:LAA!%\u0003\b\n\u00191+Z9\u0002\u0011M$x\u000e\u001d9fI\u0002\nAa\u001d;paR\u0011!\u0011\u0014\t\u0007\u00033\u0012YJa!\n\t\tu\u0015Q\u0003\u0002\u0007\rV$XO]3\u0002\u0017QLW.\u001a:UQJ,\u0017\rZ\u000b\u0003\u0005G\u0003B!!\u001a\u0003&&!!qUA4\u0005\u0019!\u0006N]3bI\u0006yA/[7feRC'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002<\t5\u0006\"CAxI\u0005\u0005\t\u0019\u0001BR\u00031!\u0018.\\3s)\"\u0014X-\u00193!Q\r)\u0013Q\u001f")
public class LightArrayRevolverScheduler
implements Scheduler,
Closeable {
    public final LoggingAdapter org$apache$pekko$actor$LightArrayRevolverScheduler$$log;
    public final ThreadFactory org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory;
    private final int WheelSize;
    private final FiniteDuration TickDuration;
    private final FiniteDuration ShutdownTimeout;
    private final double maxFrequency;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    private final long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    private final int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    private final TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    private final AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    private volatile Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;

    @Override
    public final Cancellable scheduleWithFixedDelay(Duration initialDelay, Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, runnable, executor);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleWithFixedDelay$default$6(FiniteDuration initialDelay, FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleWithFixedDelay$default$6$(this, initialDelay, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleWithFixedDelay(Duration initialDelay, Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(Duration initialDelay, Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleAtFixedRate$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.scheduleAtFixedRate$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable scheduleAtFixedRate(Duration initialDelay, Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleAtFixedRate$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
        return Scheduler.schedule$default$6$(this, initialDelay, interval, receiver, message);
    }

    @Override
    public final Cancellable schedule(Duration initialDelay, Duration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, f, executor);
    }

    @Override
    public Cancellable schedule(Duration initialDelay, Duration interval, Runnable runnable, ExecutionContext executor) {
        return Scheduler.schedule$((Scheduler)this, initialDelay, interval, runnable, executor);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
        return Scheduler.scheduleOnce$default$5$(this, delay, receiver, message);
    }

    @Override
    public final Cancellable scheduleOnce(Duration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, receiver, message, executor, sender);
    }

    @Override
    public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, f, executor);
    }

    @Override
    public Cancellable scheduleOnce(Duration delay, Runnable runnable, ExecutionContext executor) {
        return Scheduler.scheduleOnce$((Scheduler)this, delay, runnable, executor);
    }

    public int WheelSize() {
        return this.WheelSize;
    }

    public FiniteDuration TickDuration() {
        return this.TickDuration;
    }

    public FiniteDuration ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(FiniteDuration d) {
        long dn = d.toNanos();
        long r = ((dn - 1L) / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + 1L) * this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos();
        if (r != dn && r > 0L && dn > 0L) {
            return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(r)).nanos();
        }
        return d;
    }

    public long clock() {
        return System.nanoTime();
    }

    public int startTick() {
        return 0;
    }

    public FiniteDuration getShutdownTimeout() {
        return this.ShutdownTimeout();
    }

    public void waitNanos(long nanos) {
        long sleepMs = Helpers$.MODULE$.isWindows() ? (nanos + 4999999L) / 10000000L * 10L : (nanos + 999999L) / 1000000L;
        try {
            Thread.sleep(sleepMs);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, runnable, executor);
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        Cancellable cancellable;
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        try {
            cancellable = new Cancellable(this, executor, initialDelay, runnable, delay){
                private final /* synthetic */ LightArrayRevolverScheduler $outer;

                public void org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$swap(Cancellable c) {
                    Cancellable cancellable;
                    do {
                        if ((cancellable = (Cancellable)this.get()) != null) continue;
                        if (c != null) {
                            c.cancel();
                        }
                        break;
                    } while (!this.compareAndSet(cancellable, c));
                }

                public final boolean cancel() {
                    return this.tailrecCancel$1();
                }

                public boolean isCancelled() {
                    return this.get() == null;
                }

                public /* synthetic */ LightArrayRevolverScheduler org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer() {
                    return this.$outer;
                }

                private final boolean tailrecCancel$1() {
                    Cancellable cancellable;
                    do {
                        if ((cancellable = (Cancellable)this.get()) == null) {
                            return false;
                        }
                        if (!cancellable.cancel()) continue;
                        return this.compareAndSet(cancellable, null);
                    } while (!this.compareAndSet(cancellable, null));
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$InitialRepeatMarker());
                    this.compareAndSet(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$InitialRepeatMarker(), $outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(executor$1, new Runnable(this, initialDelay$1, runnable$1, delay$1, executor$1){
                        private final /* synthetic */ $anon$1 $outer;
                        private final Runnable runnable$1;
                        private final FiniteDuration delay$1;
                        private final ExecutionContext executor$1;

                        public void run() {
                            try {
                                this.runnable$1.run();
                                long driftNanos = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() - this.getAndAdd(this.delay$1.toNanos());
                                if (this.$outer.get() != null) {
                                    this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$swap(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.executor$1, this, Duration$.MODULE$.fromNanos(Math.max(this.delay$1.toNanos() - driftNanos, 1L))));
                                }
                            }
                            catch (SchedulerException schedulerException) {}
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.runnable$1 = runnable$1;
                            this.delay$1 = delay$1;
                            this.executor$1 = executor$1;
                            super($outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$$$outer().clock() + initialDelay$1.toNanos());
                        }
                    }, $outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(initialDelay$1)));
                }
            };
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SchedulerException) {
                SchedulerException schedulerException = (SchedulerException)throwable2;
                String msg = schedulerException.msg();
                throw new IllegalStateException(msg, schedulerException);
            }
            throw throwable;
        }
        return cancellable;
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        TimerTask timerTask;
        try {
            timerTask = this.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(executor, runnable, this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SchedulerException) {
                SchedulerException schedulerException = (SchedulerException)throwable2;
                String msg = schedulerException.msg();
                throw new IllegalStateException(msg, schedulerException);
            }
            throw throwable;
        }
        return timerTask;
    }

    @Override
    public void close() {
        ((IterableLike)Await$.MODULE$.result(this.stop(), this.getShutdownTimeout())).foreach((Function1<TimerTask, Object> & Serializable & scala.Serializable)x0$1 -> {
            LightArrayRevolverScheduler.$anonfun$close$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$start() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    }

    public long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    }

    public int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    }

    public TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    }

    public TimerTask org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(ExecutionContext ec, Runnable r, FiniteDuration delay) {
        if (delay.length() <= 0L) {
            if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
                throw new SchedulerException("cannot enqueue after timer shutdown");
            }
            ec.execute(r);
            return LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$NotCancellable();
        }
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        long delayNanos = delay.toNanos();
        this.checkMaxDelay(delayNanos);
        int ticks = (int)(delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
        TaskHolder task = new TaskHolder(r, ticks, ec);
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().add(task);
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get() != null && task.cancel()) {
            throw new SchedulerException("cannot enqueue after timer shutdown");
        }
        return task;
    }

    private void checkMaxDelay(long delayNanos) {
        if (delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(93).append("Task scheduled with [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos().toSeconds()).append("] seconds delay, ").append("which is too far in future, maximum delay is [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() * Integer.MAX_VALUE)).nanos().toSeconds() - 1L).append("] seconds").toString());
        }
    }

    public AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    }

    private Future<Seq<TimerTask>> stop() {
        Promise p = Promise$.MODULE$.apply();
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(null, p)) {
            return p.future();
        }
        return Future$.MODULE$.successful(Nil$.MODULE$);
    }

    private Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread() {
        return this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;
    }

    public void org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(Thread x$1) {
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$TickDuration$1(FiniteDuration x$1) {
        return x$1.$greater$eq(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis()) || !Helpers$.MODULE$.isWindows();
    }

    private final void runTask$1(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InterruptedException) {
                InterruptedException interruptedException = (InterruptedException)throwable2;
                throw interruptedException;
            }
            if (throwable2 instanceof SchedulerException) {
            }
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "exception while executing timer task");
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$close$1(LightArrayRevolverScheduler $this, TimerTask x0$1) {
        TimerTask timerTask = x0$1;
        if (timerTask instanceof Scheduler.TaskRunOnClose) {
            TimerTask timerTask2 = timerTask;
            $this.runTask$1(timerTask2);
            return;
        }
        if (timerTask instanceof TaskHolder) {
            TaskHolder taskHolder = (TaskHolder)timerTask;
            Runnable runnable = taskHolder.task();
            if (runnable instanceof Scheduler.TaskRunOnClose) {
                Scheduler.TaskRunOnClose taskRunOnClose = (Scheduler.TaskRunOnClose)runnable;
                $this.runTask$1(taskRunOnClose);
            }
            return;
        }
    }

    public LightArrayRevolverScheduler(Config config, LoggingAdapter log, ThreadFactory threadFactory) {
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log = log;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory = threadFactory;
        Scheduler.$init$(this);
        this.WheelSize = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("pekko.scheduler.ticks-per-wheel"))), (JFunction1$mcZI$sp & scala.Serializable)ticks -> (ticks & ticks - 1) == 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "ticks-per-wheel must be a power of 2"));
        this.TickDuration = Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.tick-duration")), (Function1<FiniteDuration, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(LightArrayRevolverScheduler.$anonfun$TickDuration$1(x$1)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "minimum supported pekko.scheduler.tick-duration on Windows is 10ms")), (Function1<FiniteDuration, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.$greater$eq(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis())), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "minimum supported pekko.scheduler.tick-duration is 1ms");
        this.ShutdownTimeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.shutdown-timeout");
        this.maxFrequency = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second().$div(this.TickDuration());
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start = this.clock();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos = this.TickDuration().toNanos();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask = this.WheelSize() - 1;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue = new TaskQueue();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped = new AtomicReference();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = threadFactory.newThread(new Runnable(this){
            private int tick;
            private long totalTick;
            private final TaskQueue[] wheel;
            private TaskQueue spareTaskQueue;
            private final /* synthetic */ LightArrayRevolverScheduler $outer;

            private int tick() {
                return this.tick;
            }

            private void tick_$eq(int x$1) {
                this.tick = x$1;
            }

            private long totalTick() {
                return this.totalTick;
            }

            private void totalTick_$eq(long x$1) {
                this.totalTick = x$1;
            }

            private TaskQueue[] wheel() {
                return this.wheel;
            }

            private TaskQueue spareTaskQueue() {
                return this.spareTaskQueue;
            }

            private void spareTaskQueue_$eq(TaskQueue x$1) {
                this.spareTaskQueue = x$1;
            }

            private Seq<TimerTask> clearAll() {
                return ((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.WheelSize()).flatMap((Function1<Object, Vector> & Serializable & scala.Serializable)i -> $anon$3.$anonfun$clearAll$1(this, BoxesRunTime.unboxToInt(i)), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus(this.collect$1(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue(), (Vector)package$.MODULE$.Vector().empty()), IndexedSeq$.MODULE$.canBuildFrom());
            }

            private void checkQueue(long time) {
                while (true) {
                    AbstractNodeQueue.Node<T> node;
                    if ((node = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue().pollNode()) == null) break;
                    int n = ((TaskHolder)node.value).ticks();
                    switch (n) {
                        case 0: {
                            Serializable serializable = BoxesRunTime.boxToBoolean(((TaskHolder)node.value).executeTask());
                            break;
                        }
                        default: {
                            int futureTick = (int)((time - this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + (long)n * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() + this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - 1L) / this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos());
                            int offset = futureTick - this.tick();
                            int bucket = futureTick & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                            ((TaskHolder)node.value).ticks_$eq(offset);
                            this.wheel()[bucket].addNode(node);
                            Serializable serializable = BoxedUnit.UNIT;
                            break;
                        }
                    }
                }
            }

            public final void run() {
                try {
                    this.nextTick();
                }
                catch (Throwable t) {
                    this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(t, "exception on LARS\u2019 timer thread");
                    Promise<Seq<TimerTask>> promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get();
                    if (promise == null) {
                        Object object;
                        Thread thread = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory.newThread(this);
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.info("starting new LARS thread");
                        try {
                            thread.start();
                            object = BoxedUnit.UNIT;
                        }
                        catch (Throwable e) {
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "LARS cannot start new thread, ship\u2019s going down!");
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().set(Promise$.MODULE$.successful(Nil$.MODULE$));
                            object = this.clearAll();
                        }
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread_$eq(thread);
                    } else {
                        Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, Promise$.MODULE$.successful(Nil$.MODULE$)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Stop signal violated in LARS");
                        promise.success(this.clearAll());
                    }
                    throw t;
                }
            }

            private final void nextTick() {
                Promise<Seq<TimerTask>> promise;
                do {
                    long time = this.$outer.clock();
                    long sleepTime = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start() + this.totalTick() * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos() - time;
                    if (sleepTime > 0L) {
                        this.checkQueue(time);
                        this.$outer.waitNanos(sleepTime);
                    } else {
                        int bucket = this.tick() & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask();
                        TaskQueue tasks2 = this.wheel()[bucket];
                        TaskQueue putBack = this.spareTaskQueue();
                        this.executeBucket$1(tasks2, putBack);
                        this.wheel()[bucket] = putBack;
                        this.spareTaskQueue_$eq(tasks2);
                        this.tick_$eq(this.tick() + 1);
                        this.totalTick_$eq(this.totalTick() + 1L);
                    }
                    promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().get();
                } while (promise == null);
                Predef$.MODULE$.assert(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped().compareAndSet(promise, Promise$.MODULE$.successful(Nil$.MODULE$)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Stop signal violated in LARS");
                promise.success(this.clearAll());
            }

            private final Vector collect$1(TaskQueue q, Vector acc2) {
                TaskHolder taskHolder;
                while ((taskHolder = (TaskHolder)q.poll()) != null) {
                    acc2 = acc2.$colon$plus(taskHolder, Vector$.MODULE$.canBuildFrom());
                }
                return acc2;
            }

            public static final /* synthetic */ Vector $anonfun$clearAll$1($anon$3 $this, int i) {
                return $this.collect$1($this.wheel()[i], (Vector)package$.MODULE$.Vector().empty());
            }

            private final void executeBucket$1(TaskQueue tasks$1, TaskQueue putBack$1) {
                while (true) {
                    Serializable serializable;
                    AbstractNodeQueue.Node<T> node;
                    if ((node = tasks$1.pollNode()) == null) break;
                    TaskHolder task = (TaskHolder)node.value;
                    if (!task.isCancelled()) {
                        if (task.ticks() >= this.$outer.WheelSize()) {
                            task.ticks_$eq(task.ticks() - this.$outer.WheelSize());
                            putBack$1.addNode(node);
                            serializable = BoxedUnit.UNIT;
                            continue;
                        }
                        serializable = BoxesRunTime.boxToBoolean(task.executeTask());
                        continue;
                    }
                    serializable = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tick = $outer.startTick();
                this.totalTick = this.tick();
                this.wheel = (TaskQueue[])Array$.MODULE$.fill($outer.WheelSize(), (Function0<TaskQueue> & Serializable & scala.Serializable)() -> new TaskQueue(), ClassTag$.MODULE$.apply(TaskQueue.class));
                this.spareTaskQueue = new TaskQueue();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$clearAll$1$adapted(org.apache.pekko.actor.LightArrayRevolverScheduler$$anon$3 java.lang.Object ), $anonfun$run$1(), $anonfun$nextTick$1(), $anonfun$wheel$1()}, serializedLambda);
            }
        });
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread().start();
    }

    public static class TaskHolder
    implements TimerTask {
        private volatile Runnable task;
        private int ticks;
        private final ExecutionContext executionContext;

        public Runnable task() {
            return this.task;
        }

        public void task_$eq(Runnable x$1) {
            this.task = x$1;
        }

        public int ticks() {
            return this.ticks;
        }

        public void ticks_$eq(int x$1) {
            this.ticks = x$1;
        }

        private final Runnable extractTask(Runnable replaceWith) {
            while (true) {
                boolean bl;
                Runnable runnable = this.task();
                Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
                Runnable runnable3 = runnable;
                if (!(runnable2 != null ? !runnable2.equals(runnable3) : runnable3 != null)) {
                    bl = true;
                } else {
                    Runnable runnable4 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                    Runnable runnable5 = runnable;
                    bl = !(runnable4 != null ? !runnable4.equals(runnable5) : runnable5 != null);
                }
                if (bl) {
                    return runnable;
                }
                if (!Unsafe.instance.compareAndSwapObject(this, LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$taskOffset, runnable, replaceWith)) continue;
                return runnable;
            }
        }

        public final boolean executeTask() {
            boolean bl;
            boolean bl2;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            Runnable runnable3 = runnable;
            if (!(runnable2 != null ? !runnable2.equals(runnable3) : runnable3 != null)) {
                bl2 = true;
            } else {
                Runnable runnable4 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                Runnable runnable5 = runnable;
                bl2 = !(runnable4 != null ? !runnable4.equals(runnable5) : runnable5 != null);
            }
            if (bl2) {
                return false;
            }
            try {
                this.executionContext.execute(runnable);
                bl = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    bl = false;
                }
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = option.get();
                    this.executionContext.reportFailure(e);
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }

        @Override
        public void run() {
            this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask).run();
        }

        @Override
        public boolean cancel() {
            boolean bl;
            Runnable runnable = this.extractTask(LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask);
            Runnable runnable2 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$ExecutedTask;
            Runnable runnable3 = runnable;
            if (!(runnable2 != null ? !runnable2.equals(runnable3) : runnable3 != null)) {
                bl = true;
            } else {
                Runnable runnable4 = LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
                Runnable runnable5 = runnable;
                bl = !(runnable4 != null ? !runnable4.equals(runnable5) : runnable5 != null);
            }
            return !bl;
        }

        @Override
        public boolean isCancelled() {
            return this.task() == LightArrayRevolverScheduler$.MODULE$.org$apache$pekko$actor$LightArrayRevolverScheduler$$CancelledTask;
        }

        public TaskHolder(Runnable task, int ticks, ExecutionContext executionContext) {
            this.task = task;
            this.ticks = ticks;
            this.executionContext = executionContext;
        }
    }

    private static class TaskQueue
    extends AbstractNodeQueue<TaskHolder> {
    }

    public static interface TimerTask
    extends Runnable,
    Cancellable {
    }
}

