/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.artery.compress;

import org.apache.pekko.actor.Address;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.artery.ArterySettings;
import org.apache.pekko.remote.artery.InboundContext;
import org.apache.pekko.remote.artery.OutboundContext;
import org.apache.pekko.remote.artery.compress.CompressionTable;
import org.apache.pekko.remote.artery.compress.CompressionTable$;
import org.apache.pekko.remote.artery.compress.CountMinSketch;
import org.apache.pekko.remote.artery.compress.DecompressionTable;
import org.apache.pekko.remote.artery.compress.DecompressionTable$;
import org.apache.pekko.remote.artery.compress.InboundCompression$;
import org.apache.pekko.remote.artery.compress.InboundCompression$Tables$;
import org.apache.pekko.remote.artery.compress.TopHeavyHitters;
import org.apache.pekko.remote.artery.compress.UnknownCompressedIdException;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r=uA\u0002\"D\u0011\u00039uJ\u0002\u0004R\u0007\"\u0005qI\u0015\u0005\u00063\u0006!\ta\u0017\u0005\b9\u0006\u0011\r\u0011\"\u0002^\u0011\u0019\u0001\u0017\u0001)A\u0007=\u001e)\u0011-\u0001E\u0001E\u001a)A-\u0001E\u0001K\")\u0011L\u0002C\u0001S\")!N\u0002C\u0001W\"I!\u0011\u0004\u0004\u0002\u0002\u0013\u0005%1\u0004\u0005\n\u0005o1\u0011\u0011!CA\u0005sA\u0011Ba\u0016\u0007\u0003\u0003%IA!\u0017\u0007\t\u0011\f!I\u001c\u0005\tg2\u0011)\u001a!C\u0001i\"I\u0011q\u0004\u0007\u0003\u0012\u0003\u0006I!\u001e\u0005\u000b\u0003Ca!Q3A\u0005\u0002\u0005\r\u0002BCA\u0013\u0019\tE\t\u0015!\u0003\u0002\u0004!Q\u0011q\u0005\u0007\u0003\u0016\u0004%\t!a\t\t\u0015\u0005%BB!E!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002,1\u0011)\u001a!C\u0001\u0003[A!\"a\u000f\r\u0005#\u0005\u000b\u0011BA\u0018\u0011)\ti\u0004\u0004BK\u0002\u0013\u0005\u0011q\b\u0005\u000b\u0003\u000fb!\u0011#Q\u0001\n\u0005\u0005\u0003BB-\r\t\u0003\tI\u0005C\u0004\u0002X1!\t!!\u0017\t\u000f\u0005-D\u0002\"\u0001\u0002n!I\u0011q\u000e\u0007\u0002\u0002\u0013\u0005\u0011\u0011\u000f\u0005\n\u0003\u001bc\u0011\u0013!C\u0001\u0003\u001fC\u0011\"!+\r#\u0003%\t!a+\t\u0013\u0005MF\"%A\u0005\u0002\u0005U\u0006\"CA]\u0019E\u0005I\u0011AA^\u0011%\t\u0019\rDI\u0001\n\u0003\t)\rC\u0005\u0002N2\t\t\u0011\"\u0011\u0002P\"I\u0011\u0011\u001d\u0007\u0002\u0002\u0013\u0005\u0011q\b\u0005\n\u0003Gd\u0011\u0011!C\u0001\u0003KD\u0011\"a;\r\u0003\u0003%\t%!<\t\u0013\u0005mH\"!A\u0005\u0002\u0005u\b\"\u0003B\u0004\u0019\u0005\u0005I\u0011\tB\u0005\u0011%\u0011Y\u0001DA\u0001\n\u0003\u0012i\u0001C\u0005\u0003\u00101\t\t\u0011\"\u0011\u0003\u0012\u00199\u0011kQA\u0001\u000f\n\u0005\u0004B\u0003B3Q\t\u0015\r\u0011\"\u0001\u0003h!Q!Q\u000f\u0015\u0003\u0002\u0003\u0006IA!\u001b\t\u0015\t]\u0004F!b\u0001\n\u0003\u0011I\b\u0003\u0006\u0003\f\"\u0012\t\u0011)A\u0005\u0005wB!B!$)\u0005\u000b\u0007I\u0011\u0001BH\u0011)\u00119\n\u000bB\u0001B\u0003%!\u0011\u0013\u0005\u000b\u00053C#\u0011!Q\u0001\n\tm\u0005B\u0003BQQ\t\u0015\r\u0011\"\u0001\u0003$\"Q!q\u0017\u0015\u0003\u0002\u0003\u0006IA!*\t\reCC\u0011\u0001B]\u0011!\u00119\r\u000bQ!\n\t%\u0007\u0002\u0003BgQ\u0001\u0006K!a@\t\u0011\t]\u0007\u0006)Q\u0005\u0003\u0003B\u0001B!7)A\u0003%\u0011\u0011\t\u0005\t\u00057D\u0003\u0015!\u0003\u0003^\"9!1\u001d\u0015\u0007\u0002\t\u0015\bb\u0002B|Q\u0011\u0015!\u0011 \u0005\b\u0007\u001bACQAB\b\u0011\u001d\u0019y\u0002\u000bC\u0001\u0007CAqaa\u0011)\t\u0013\u0019)\u0005\u0003\u0005\u0004N!\"\taRB(\u0011\u001d\u0019\t\u0006\u000bD\t\u0007'Bqa!\u001a)\t\u0013\u00199\u0007C\u0004\u0004n!\"\tba\u001c\t\u000f\t-\u0001\u0006\"\u0011\u0004\n\u0006\u0011\u0012J\u001c2pk:$7i\\7qe\u0016\u001c8/[8o\u0015\t!U)\u0001\u0005d_6\u0004(/Z:t\u0015\t1u)\u0001\u0004beR,'/\u001f\u0006\u0003\u0011&\u000baA]3n_R,'B\u0001&L\u0003\u0015\u0001Xm[6p\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\u0011\u0005A\u000bQ\"A\"\u0003%%s'm\\;oI\u000e{W\u000e\u001d:fgNLwN\\\n\u0003\u0003M\u0003\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003=\u000b1cS3fa>cG\rV1cY\u0016\u001ch*^7cKJ,\u0012AX\b\u0002?v\t1!\u0001\u000bLK\u0016\u0004x\n\u001c3UC\ndWm\u001d(v[\n,'\u000fI\u0001\u0007)\u0006\u0014G.Z:\u0011\u0005\r4Q\"A\u0001\u0003\rQ\u000b'\r\\3t'\r11K\u001a\t\u0003)\u001eL!\u0001[+\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003\t\fQ!Z7qif,2\u0001\u001cB\f+\u0005i\u0007\u0003B2\r\u0005+)2a\\A\u0007'\u0011a1\u000b\u001d4\u0011\u0005Q\u000b\u0018B\u0001:V\u0005\u001d\u0001&o\u001c3vGR\f\u0011b\u001c7e)\u0006\u0014G.Z:\u0016\u0003U\u0004BA\u001e@\u0002\u00049\u0011q\u000f \b\u0003qnl\u0011!\u001f\u0006\u0003uj\u000ba\u0001\u0010:p_Rt\u0014\"\u0001,\n\u0005u,\u0016a\u00029bG.\fw-Z\u0005\u0004\u007f\u0006\u0005!\u0001\u0002'jgRT!!`+\u0011\u000bA\u000b)!!\u0003\n\u0007\u0005\u001d1I\u0001\nEK\u000e|W\u000e\u001d:fgNLwN\u001c+bE2,\u0007\u0003BA\u0006\u0003\u001ba\u0001\u0001B\u0004\u0002\u00101\u0011\r!!\u0005\u0003\u0003Q\u000bB!a\u0005\u0002\u001aA\u0019A+!\u0006\n\u0007\u0005]QKA\u0004O_RD\u0017N\\4\u0011\u0007Q\u000bY\"C\u0002\u0002\u001eU\u00131!\u00118z\u0003)yG\u000e\u001a+bE2,7\u000fI\u0001\fC\u000e$\u0018N^3UC\ndW-\u0006\u0002\u0002\u0004\u0005a\u0011m\u0019;jm\u0016$\u0016M\u00197fA\u0005Ia.\u001a=u)\u0006\u0014G.Z\u0001\u000b]\u0016DH\u000fV1cY\u0016\u0004\u0013aF1em\u0016\u0014H/[:f[\u0016tG/\u00138Qe><'/Z:t+\t\ty\u0003E\u0003U\u0003c\t)$C\u0002\u00024U\u0013aa\u00149uS>t\u0007#\u0002)\u00028\u0005%\u0011bAA\u001d\u0007\n\u00012i\\7qe\u0016\u001c8/[8o)\u0006\u0014G.Z\u0001\u0019C\u00124XM\u001d;jg\u0016lWM\u001c;J]B\u0013xn\u001a:fgN\u0004\u0013!D6fKB|E\u000e\u001a+bE2,7/\u0006\u0002\u0002BA\u0019A+a\u0011\n\u0007\u0005\u0015SKA\u0002J]R\fab[3fa>cG\rV1cY\u0016\u001c\b\u0005\u0006\u0007\u0002L\u00055\u0013qJA)\u0003'\n)\u0006\u0005\u0003d\u0019\u0005%\u0001\"B:\u0018\u0001\u0004)\bbBA\u0011/\u0001\u0007\u00111\u0001\u0005\b\u0003O9\u0002\u0019AA\u0002\u0011\u001d\tYc\u0006a\u0001\u0003_Aq!!\u0010\u0018\u0001\u0004\t\t%A\u0006tK2,7\r\u001e+bE2,G\u0003BA.\u0003O\u0002b!!\u0018\u0002d\u0005\rQBAA0\u0015\r\t\t'S\u0001\u0005kRLG.\u0003\u0003\u0002f\u0005}#!C(qi&|gNV1m\u0011\u001d\tI\u0007\u0007a\u0001\u0003\u0003\nqA^3sg&|g.A\nti\u0006\u0014H/V:j]\u001etU\r\u001f;UC\ndW\r\u0006\u0002\u0002L\u0005!1m\u001c9z+\u0011\t\u0019(!\u001f\u0015\u0019\u0005U\u00141PAA\u0003\u0007\u000b))a#\u0011\t\rd\u0011q\u000f\t\u0005\u0003\u0017\tI\bB\u0004\u0002\u0010i\u0011\r!!\u0005\t\u0011MT\u0002\u0013!a\u0001\u0003{\u0002BA\u001e@\u0002\u0000A)\u0001+!\u0002\u0002x!I\u0011\u0011\u0005\u000e\u0011\u0002\u0003\u0007\u0011q\u0010\u0005\n\u0003OQ\u0002\u0013!a\u0001\u0003\u007fB\u0011\"a\u000b\u001b!\u0003\u0005\r!a\"\u0011\u000bQ\u000b\t$!#\u0011\u000bA\u000b9$a\u001e\t\u0013\u0005u\"\u0004%AA\u0002\u0005\u0005\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0003#\u000b9+\u0006\u0002\u0002\u0014*\u001aQ/!&,\u0005\u0005]\u0005\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!)V\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\u000bYJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!a\u0004\u001c\u0005\u0004\t\t\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\t\u00055\u0016\u0011W\u000b\u0003\u0003_SC!a\u0001\u0002\u0016\u00129\u0011q\u0002\u000fC\u0002\u0005E\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0005\u0003[\u000b9\fB\u0004\u0002\u0010u\u0011\r!!\u0005\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU!\u0011QXAa+\t\tyL\u000b\u0003\u00020\u0005UEaBA\b=\t\u0007\u0011\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\u0011\t9-a3\u0016\u0005\u0005%'\u0006BA!\u0003+#q!a\u0004 \u0005\u0004\t\t\"A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0004B!a5\u0002^6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0003mC:<'BAAn\u0003\u0011Q\u0017M^1\n\t\u0005}\u0017Q\u001b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011DAt\u0011%\tIOIA\u0001\u0002\u0004\t\t%A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0004b!!=\u0002x\u0006eQBAAz\u0015\r\t)0V\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA}\u0003g\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011q B\u0003!\r!&\u0011A\u0005\u0004\u0005\u0007)&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003S$\u0013\u0011!a\u0001\u00033\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u0003\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003#\fa!Z9vC2\u001cH\u0003BA\u0000\u0005'A\u0011\"!;(\u0003\u0003\u0005\r!!\u0007\u0011\t\u0005-!q\u0003\u0003\b\u0003\u001fA!\u0019AA\t\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\u0011iBa\t\u0015\u0019\t}!Q\u0005B\u0016\u0005[\u0011yC!\u000e\u0011\t\rd!\u0011\u0005\t\u0005\u0003\u0017\u0011\u0019\u0003B\u0004\u0002\u0010%\u0011\r!!\u0005\t\rML\u0001\u0019\u0001B\u0014!\u00111hP!\u000b\u0011\u000bA\u000b)A!\t\t\u000f\u0005\u0005\u0012\u00021\u0001\u0003*!9\u0011qE\u0005A\u0002\t%\u0002bBA\u0016\u0013\u0001\u0007!\u0011\u0007\t\u0006)\u0006E\"1\u0007\t\u0006!\u0006]\"\u0011\u0005\u0005\b\u0003{I\u0001\u0019AA!\u0003\u001d)h.\u00199qYf,BAa\u000f\u0003LQ!!Q\bB)!\u0015!\u0016\u0011\u0007B !5!&\u0011\tB#\u0005\u000f\u00129E!\u0014\u0002B%\u0019!1I+\u0003\rQ+\b\u000f\\36!\u00111hPa\u0012\u0011\u000bA\u000b)A!\u0013\u0011\t\u0005-!1\n\u0003\b\u0003\u001fQ!\u0019AA\t!\u0015!\u0016\u0011\u0007B(!\u0015\u0001\u0016q\u0007B%\u0011%\u0011\u0019FCA\u0001\u0002\u0004\u0011)&A\u0002yIA\u0002Ba\u0019\u0007\u0003J\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0006\u0005\u0003\u0002T\nu\u0013\u0002\u0002B0\u0003+\u0014aa\u00142kK\u000e$X\u0003\u0002B2\u0005[\u001b\"\u0001K*\u0002\u00071|w-\u0006\u0002\u0003jA!!1\u000eB9\u001b\t\u0011iGC\u0002\u0003p%\u000bQ!\u001a<f]RLAAa\u001d\u0003n\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n\u0001b]3ui&twm]\u000b\u0003\u0005w\u0002BA! \u0003\u0006:!!q\u0010BA\u001b\u0005)\u0015b\u0001BB\u000b\u0006q\u0011I\u001d;fef\u001cV\r\u001e;j]\u001e\u001c\u0018\u0002\u0002BD\u0005\u0013\u00131bQ8naJ,7o]5p]*\u0019!1Q#\u0002\u0013M,G\u000f^5oON\u0004\u0013!C8sS\u001eLg.V5e+\t\u0011\t\nE\u0002U\u0005'K1A!&V\u0005\u0011auN\\4\u0002\u0015=\u0014\u0018nZ5o+&$\u0007%\u0001\bj]\n|WO\u001c3D_:$X\r\u001f;\u0011\t\t}$QT\u0005\u0004\u0005?+%AD%oE>,h\u000eZ\"p]R,\u0007\u0010^\u0001\rQ\u0016\fg/\u001f%jiR,'o]\u000b\u0003\u0005K\u0003R\u0001\u0015BT\u0005WK1A!+D\u0005=!v\u000e\u001d%fCZL\b*\u001b;uKJ\u001c\b\u0003BA\u0006\u0005[#q!a\u0004)\u0005\u0004\u0011y+\u0005\u0003\u00032\u0006e\u0001c\u0001+\u00034&\u0019!QW+\u0003\t9+H\u000e\\\u0001\u000eQ\u0016\fg/\u001f%jiR,'o\u001d\u0011\u0015\u0019\tm&Q\u0018B`\u0005\u0003\u0014\u0019M!2\u0011\tAC#1\u0016\u0005\b\u0005K\u0012\u0004\u0019\u0001B5\u0011\u001d\u00119H\ra\u0001\u0005wBqA!$3\u0001\u0004\u0011\t\nC\u0004\u0003\u001aJ\u0002\rAa'\t\u000f\t\u0005&\u00071\u0001\u0003&\u00061A/\u00192mKN\u0004RAa3\r\u0005Ws!\u0001\u0015\u0001\u0002\u000b\u0005d\u0017N^3)\u0007Q\u0012\t\u000eE\u0002U\u0005'L1A!6V\u0005!1x\u000e\\1uS2,\u0017a\u0003:fg\u0016tGmQ8v]R\fa\"\\1y%\u0016\u001cXM\u001c3D_VtG/A\u0002d[N\u00042\u0001\u0015Bp\u0013\r\u0011\to\u0011\u0002\u000f\u0007>,h\u000e^'j]N[W\r^2i\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0005O\u0014IOa=\u0011\r\u0005u\u00131\rBV\u0011\u001d\u0011Y\u000f\u000fa\u0001\u0005[\fA#\u001b8d_6Lgn\u001a+bE2,g+\u001a:tS>t\u0007c\u0001+\u0003p&\u0019!\u0011_+\u0003\t\tKH/\u001a\u0005\b\u0005kD\u0004\u0019AA!\u0003\rIG\r_\u0001\u0013I\u0016\u001cw.\u001c9sKN\u001c\u0018J\u001c;fe:\fG\u000e\u0006\u0005\u0003h\nm(Q B\u0000\u0011\u001d\u0011Y/\u000fa\u0001\u0005[DqA!>:\u0001\u0004\t\t\u0005C\u0004\u0004\u0002e\u0002\r!!\u0011\u0002\u001d\u0005$H/Z7qi\u000e{WO\u001c;fe\"\u001a\u0011h!\u0002\u0011\t\r\u001d1\u0011B\u0007\u0003\u0003?KAaa\u0003\u0002 \n9A/Y5me\u0016\u001c\u0017\u0001F2p]\u001aL'/\\!em\u0016\u0014H/[:f[\u0016tG\u000f\u0006\u0004\u0004\u0012\r]11\u0004\t\u0004)\u000eM\u0011bAB\u000b+\n!QK\\5u\u0011\u001d\u0019IB\u000fa\u0001\u0005[\fA\u0002^1cY\u00164VM]:j_:Dqa!\b;\u0001\u0004\ty0\u0001\u0004hCZ,W\u000b]\u0001\nS:\u001c'/Z7f]R$\u0002b!\u0005\u0004$\rm2q\b\u0005\b\u0007KY\u0004\u0019AB\u0014\u00035\u0011X-\\8uK\u0006#GM]3tgB!1\u0011FB\u0018\u001b\t\u0019YCC\u0002\u0004.%\u000bQ!Y2u_JLAa!\r\u0004,\t9\u0011\t\u001a3sKN\u001c\b\u0006BB\u0012\u0007k\u0001B!!\u0018\u00048%!1\u0011HA0\u0005\u0019)h.^:fI\"91QH\u001eA\u0002\t-\u0016!\u0002<bYV,\u0007bBB!w\u0001\u0007!\u0011S\u0001\u0002]\u0006\u0001\u0013\r\u001a3B]\u0012\u001c\u0005.Z2l\u0013\u001aDW-\u0019<z\u0011&$H/\u001a:EKR,7\r^3e)\u0019\typa\u0012\u0004J!91Q\b\u001fA\u0002\t-\u0006bBB&y\u0001\u0007!\u0011S\u0001\u0006G>,h\u000e^\u0001\u001aeVtg*\u001a=u)\u0006\u0014G.Z!em\u0016\u0014H/[:f[\u0016tG\u000f\u0006\u0002\u0004\u0012\u0005I\u0012\r\u001a<feRL7/Z\"p[B\u0014Xm]:j_:$\u0016M\u00197f)\u0019\u0019\tb!\u0016\u0004`!91q\u000b A\u0002\re\u0013aC1tg>\u001c\u0017.\u0019;j_:\u0004BAa \u0004\\%\u00191QL#\u0003\u001f=+HOY8v]\u0012\u001cuN\u001c;fqRDqa!\u0019?\u0001\u0004\u0019\u0019'A\u0003uC\ndW\rE\u0003Q\u0003o\u0011Y+A\u0010qe\u0016\u0004\u0018M]3D_6\u0004(/Z:tS>t\u0017\t\u001a<feRL7/Z7f]R$Baa\u0019\u0004j!911N A\u0002\t5\u0018\u0001\u00058fqR$\u0016M\u00197f-\u0016\u00148/[8o\u0003i\u0011W/\u001b7e)\u0006\u0014G.\u001a$pe\u0006#g/\u001a:uSN,W.\u001a8u)\u0011\u0019\th!!\u0011\u0011\rM41\u0010BV\u0003\u0003rAa!\u001e\u0004xA\u0011\u00010V\u0005\u0004\u0007s*\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0004~\r}$aA'ba*\u00191\u0011P+\t\u000f\r\r\u0005\t1\u0001\u0004\u0006\u0006AQ\r\\3nK:$8\u000fE\u0003w\u0007\u000f\u0013Y+\u0003\u0003\u0002z\u0006\u0005ACABF!\u0011\u0019\u0019h!$\n\t\u0005}7q\u0010")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final int maxResendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        byte activeVersion;
        Tables<T> current;
        while (true) {
            if (attemptCounter > 2) {
                throw new IllegalStateException(new StringBuilder(52).append("Unable to decompress ").append(idx).append(" from table ").append(incomingTableVersion).append(". Internal tables: ").append(this.tables).toString());
            }
            current = this.tables;
            activeVersion = current.activeTable().version();
            if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                OptionVal$.MODULE$.None();
                return null;
            }
            DecompressionTable<T> decompressionTable = current.selectTable(incomingTableVersion);
            DecompressionTable<T> decompressionTable2 = OptionVal$Some$.MODULE$.unapply(decompressionTable);
            if (!OptionVal$.MODULE$.isEmpty$extension(decompressionTable2)) {
                DecompressionTable<T> selectedTable = OptionVal$.MODULE$.get$extension(decompressionTable2);
                T value = selectedTable.get(idx);
                if (value != null) {
                    return OptionVal$Some$.MODULE$.apply(value);
                }
                throw new UnknownCompressedIdException(idx);
            }
            if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
            this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(current.nextTable().version()));
            this.confirmAdvertisement(incomingTableVersion, false);
            ++attemptCounter;
        }
        this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", BoxesRunTime.boxToLong(this.originUid()), (Object)BoxesRunTime.boxToByte(activeVersion), (Object)BoxesRunTime.boxToByte(current.nextTable().version()), (Object)BoxesRunTime.boxToByte(incomingTableVersion));
        OptionVal$.MODULE$.None();
        return null;
    }

    public final void confirmAdvertisement(byte tableVersion, boolean gaveUp) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("{} compression table version [{}] for originUid [{}]", gaveUp ? "Gave up" : "Confirmed", BoxesRunTime.boxToByte(tableVersion), BoxesRunTime.boxToLong(this.originUid()));
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("{} compression table version [{}] for originUid [{}] but other version in progress [{}]", gaveUp ? "Gave up" : "Confirmed", BoxesRunTime.boxToByte(tableVersion), BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()));
            return;
        }
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext = this.inboundContext.association(this.originUid());
            OutboundContext outboundContext2 = OptionVal$Some$.MODULE$.unapply(outboundContext);
            if (!OptionVal$.MODULE$.isEmpty$extension(outboundContext2)) {
                OutboundContext association = OptionVal$.MODULE$.get$extension(outboundContext2);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$1 = this.tables;
                    DecompressionTable<T> x$1 = table.invert();
                    Some<CompressionTable<T>> x$2 = new Some<CompressionTable<T>>(table);
                    List<DecompressionTable<T>> x$3 = qual$1.copy$default$1();
                    DecompressionTable<T> x$4 = qual$1.copy$default$2();
                    int x$5 = qual$1.copy$default$5();
                    Tables<T> nextState = qual$1.copy(x$3, x$4, x$1, x$2, x$5);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                } else if (association.isOrdinaryMessageStreamActive()) {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", Logging$.MODULE$.simpleName(this.tables.activeTable()), BoxesRunTime.boxToLong(this.originUid()));
                }
            } else {
                this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", BoxesRunTime.boxToLong(this.originUid()));
            }
            return;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= this.maxResendCount) {
                OutboundContext outboundContext = this.inboundContext.association(this.originUid());
                OutboundContext outboundContext3 = OptionVal$Some$.MODULE$.unapply(outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension(outboundContext3)) {
                    OutboundContext association = OptionVal$.MODULE$.get$extension(outboundContext3);
                    this.log().debug("Advertisement in progress for originUid [{}] version [{}], resending [{}:{}]", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()), BoxesRunTime.boxToInteger(this.resendCount), BoxesRunTime.boxToInteger(this.maxResendCount));
                    this.advertiseCompressionTable(association, inProgress);
                }
                return;
            }
            this.log().debug("Advertisement in progress for originUid [{}] version [{}] but no confirmation after retries.", BoxesRunTime.boxToLong(this.originUid()), BoxesRunTime.boxToByte(inProgress.version()));
            this.confirmAdvertisement(inProgress.version(), true);
            return;
        }
        throw new MatchError(option);
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Map<T, Object> mappings = this.buildTableForAdvertisement(this.heavyHitters().iterator());
        return CompressionTable$.MODULE$.apply(this.originUid(), nextTableVersion, mappings);
    }

    public Map<T, Object> buildTableForAdvertisement(Iterator<T> elements) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq(elements.zipWithIndex());
        return mb.result();
    }

    public String toString() {
        return new StringBuilder(34).append(Logging$.MODULE$.simpleName(this.getClass())).append("(countMinSketch: ").append(this.cms).append(", heavyHitters: ").append(this.heavyHitters()).append(")").toString();
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == current$1.advertisementInProgress().get().version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.maxResendCount = 3;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", Logging$.MODULE$.simpleName(this.getClass()), BoxesRunTime.boxToLong(originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        public DecompressionTable<T> selectTable(int version) {
            if (this.activeTable().version() == version) {
                return OptionVal$Some$.MODULE$.apply(this.activeTable());
            }
            DecompressionTable found = this.find$1(this.oldTables(), version);
            return found;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            byte x$1 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$2 = qual$1.copy$default$1();
            Object x$3 = qual$1.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$1.copy(x$2, x$1, x$3), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        @Override
        public String productPrefix() {
            return "Tables";
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.oldTables();
                }
                case 1: {
                    return this.activeTable();
                }
                case 2: {
                    return this.nextTable();
                }
                case 3: {
                    return this.advertisementInProgress();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger(this.keepOldTables());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, Statics.anyHash(this.oldTables()));
            n = Statics.mix(n, Statics.anyHash(this.activeTable()));
            n = Statics.mix(n, Statics.anyHash(this.nextTable()));
            n = Statics.mix(n, Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix(n, this.keepOldTables());
            return Statics.finalizeHash(n, 5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            return true;
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            List list;
            while (true) {
                if (((Object)Nil$.MODULE$).equals(list = tables)) {
                    OptionVal$.MODULE$.None();
                    return null;
                }
                if (!(list instanceof $colon$colon)) break;
                $colon$colon $colon$colon = ($colon$colon)list;
                DecompressionTable t = (DecompressionTable)$colon$colon.head();
                List tail = $colon$colon.tl$access$1();
                if (t.version() == version$1) {
                    return OptionVal$Some$.MODULE$.apply(t);
                }
                tables = tail;
            }
            throw new MatchError(list);
        }

        private static final byte incrementTableVersion$1(byte version) {
            if (version == 127) {
                return 0;
            }
            return (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$(this);
        }
    }
}

