/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.event.EventStream;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Warning$;
import org.apache.pekko.event.SubchannelClassification;
import org.apache.pekko.remote.FailureDetector;
import org.apache.pekko.remote.FailureDetector$;
import org.apache.pekko.remote.HeartbeatHistory;
import org.apache.pekko.remote.HeartbeatHistory$;
import org.apache.pekko.remote.PhiAccrualFailureDetector$State$;
import org.apache.pekko.remote.RemoteLogMarker$;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001\u0002\u001e<\u0001\u0011C\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003X\u0011!Y\u0006A!b\u0001\n\u0003a\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0019\u0004!Q1A\u0005\u0002qC\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tQ\u0002\u0011)\u0019!C\u00019\"A\u0011\u000e\u0001B\u0001B\u0003%Q\f\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003l\u0011!!\bA!A!\u0002\u0017)\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u0007\u0001A\u0011AA\r\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003SA\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0015\u0001\u0005\u0004%I!a\u0015\t\u0011\u0005m\u0003\u0001)A\u0005\u0003+B!\"!\u0018\u0001\u0001\u0004%\t!PA0\u0011)\t9\b\u0001a\u0001\n\u0003i\u0014\u0011\u0010\u0005\t\u0003\u000b\u0003\u0001\u0015)\u0003\u0002b\u00191\u0011q\u0011\u0001E\u0003\u0013C!\"a&\u0018\u0005+\u0007I\u0011AA$\u0011)\tIj\u0006B\tB\u0003%\u0011\u0011\n\u0005\u000b\u00037;\"Q3A\u0005\u0002\u0005u\u0005BCAQ/\tE\t\u0015!\u0003\u0002 \"9\u00111A\f\u0005\u0002\u0005\r\u0006\"CAW/\u0005\u0005I\u0011AAX\u0011%\t)lFI\u0001\n\u0003\t9\fC\u0005\u0002N^\t\n\u0011\"\u0001\u0002P\"I\u00111[\f\u0002\u0002\u0013\u0005\u0013Q\u001b\u0005\t\u0003K<\u0012\u0011!C\u0001-\"I\u0011q]\f\u0002\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003g<\u0012\u0011!C!\u0003kD\u0011Ba\u0001\u0018\u0003\u0003%\tA!\u0002\t\u0013\t=q#!A\u0005B\tE\u0001\"\u0003B\n/\u0005\u0005I\u0011\tB\u000b\u0011%\u00119bFA\u0001\n\u0003\u0012IbB\u0005\u0003\u001e\u0001\t\t\u0011#\u0003\u0003 \u0019I\u0011q\u0011\u0001\u0002\u0002#%!\u0011\u0005\u0005\b\u0003\u0007IC\u0011\u0001B\u0018\u0011%\u0011\u0019\"KA\u0001\n\u000b\u0012)\u0002C\u0005\u00032%\n\t\u0011\"!\u00034!I!\u0011H\u0015\u0002\u0002\u0013\u0005%1\b\u0005\n\u0005\u0013\u0002!\u0019!C\u0005\u0005\u0017B\u0001Ba\u0018\u0001A\u0003%!Q\n\u0005\b\u0005C\u0002A\u0011\tB2\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005KBqA!\u001b\u0001\t\u0003\u0012\u0019\u0007C\u0004\u0003l\u0001!)E!\u001c\t\r\te\u0004\u0001\"\u0001Q\u0011\u001d\u0011I\b\u0001C\u0005\u0005wB\u0001B!\u001f\u0001\t\u0003i$q\u0010\u0005\t\u0005\u001b\u0003!\u0019!C\u0005!\"9!q\u0012\u0001!\u0002\u0013\t\u0006b\u0002BI\u0001\u0011%!1\u0013\u0002\u001a!\"L\u0017iY2sk\u0006dg)Y5mkJ,G)\u001a;fGR|'O\u0003\u0002={\u00051!/Z7pi\u0016T!AP \u0002\u000bA,7n[8\u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\r\u0001Qi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0002\u0011\u0006)1oY1mC&\u0011!j\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u00051kU\"A\u001e\n\u00059[$a\u0004$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0002\u0013QD'/Z:i_2$W#A)\u0011\u0005\u0019\u0013\u0016BA*H\u0005\u0019!u.\u001e2mK\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\u0002\u001b5\f\u0007pU1na2,7+\u001b>f+\u00059\u0006C\u0001$Y\u0013\tIvIA\u0002J]R\fa\"\\1y'\u0006l\u0007\u000f\\3TSj,\u0007%A\bnS:\u001cF\u000f\u001a#fm&\fG/[8o+\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003!!WO]1uS>t'B\u00012H\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003I~\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\tnS:\u001cF\u000f\u001a#fm&\fG/[8oA\u0005A\u0012mY2faR\f'\r\\3IK\u0006\u0014HOY3biB\u000bWo]3\u00023\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX\rI\u0001\u0017M&\u00148\u000f\u001e%fCJ$(-Z1u\u000bN$\u0018.\\1uK\u00069b-\u001b:ti\"+\u0017M\u001d;cK\u0006$Xi\u001d;j[\u0006$X\rI\u0001\fKZ,g\u000e^*ue\u0016\fW\u000eE\u0002GY:L!!\\$\u0003\r=\u0003H/[8o!\ty'/D\u0001q\u0015\t\tX(A\u0003fm\u0016tG/\u0003\u0002ta\nYQI^3oiN#(/Z1n\u0003\u0015\u0019Gn\\2l!\t1hP\u0004\u0002xy:\u0011\u0001p\u001f\b\u0003sjl\u0011aP\u0005\u0003}}J!\u0001P\u001f\n\u0005u\\\u0014a\u0004$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\n\u0007}\f\tAA\u0003DY>\u001c7N\u0003\u0002~w\u00051A(\u001b8jiz\"b\"a\u0002\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\u0002\u0006\u0003\u0002\n\u0005-\u0001C\u0001'\u0001\u0011\u0015!X\u0002q\u0001v\u0011\u0015yU\u00021\u0001R\u0011\u0015)V\u00021\u0001X\u0011\u0015YV\u00021\u0001^\u0011\u00151W\u00021\u0001^\u0011\u0015AW\u00021\u0001^\u0011\u0015QW\u00021\u0001l)1\tY\"a\b\u0002\"\u0005\r\u0012QEA\u0014)\u0011\tI!!\b\t\u000bQt\u00019A;\t\u000b=s\u0001\u0019A)\t\u000bUs\u0001\u0019A,\t\u000bms\u0001\u0019A/\t\u000b\u0019t\u0001\u0019A/\t\u000b!t\u0001\u0019A/\u0015\r\u0005%\u00111FA!\u0011\u001d\tic\u0004a\u0001\u0003_\taaY8oM&<\u0007\u0003BA\u0019\u0003{i!!a\r\u000b\t\u00055\u0012Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0005usB,7/\u00194f\u0015\t\tY$A\u0002d_6LA!a\u0010\u00024\t11i\u001c8gS\u001eDa!a\u0011\u0010\u0001\u0004q\u0017AA3w\u000391\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,\"!!\u0013\u0011\u00071\u000bY%C\u0002\u0002Nm\u0012\u0001\u0003S3beR\u0014W-\u0019;ISN$xN]=\u0002\u001f\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0002\na$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:f\u001b&dG.[:\u0016\u0005\u0005U\u0003c\u0001$\u0002X%\u0019\u0011\u0011L$\u0003\t1{gnZ\u0001 C\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,W*\u001b7mSN\u0004\u0013aB1eIJ,7o]\u000b\u0003\u0003C\u0002B!a\u0019\u0002r9!\u0011QMA7!\r\t9gR\u0007\u0003\u0003SR1!a\u001bD\u0003\u0019a$o\\8u}%\u0019\u0011qN$\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019(!\u001e\u0003\rM#(/\u001b8h\u0015\r\tygR\u0001\fC\u0012$'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002|\u0005\u0005\u0005c\u0001$\u0002~%\u0019\u0011qP$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0007+\u0012\u0011!a\u0001\u0003C\n1\u0001\u001f\u00132\u0003!\tG\r\u001a:fgN\u0004#!B*uCR,7CB\fF\u0003\u0017\u000b\t\nE\u0002G\u0003\u001bK1!a$H\u0005\u001d\u0001&o\u001c3vGR\u00042ARAJ\u0013\r\t)j\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bQ&\u001cHo\u001c:z\u0003!A\u0017n\u001d;pef\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q+\t\ty\n\u0005\u0003GY\u0006U\u0013A\u0003;j[\u0016\u001cH/Y7qAQ1\u0011QUAU\u0003W\u00032!a*\u0018\u001b\u0005\u0001\u0001bBAL9\u0001\u0007\u0011\u0011\n\u0005\b\u00037c\u0002\u0019AAP\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\u0015\u0016\u0011WAZ\u0011%\t9*\bI\u0001\u0002\u0004\tI\u0005C\u0005\u0002\u001cv\u0001\n\u00111\u0001\u0002 \u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA]U\u0011\tI%a/,\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a2H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\f\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002R*\"\u0011qTA^\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u001b\t\u0005\u00033\f\u0019/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0018\u0001\u00026bm\u0006LA!a\u001d\u0002\\\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAv\u0003c\u00042ARAw\u0013\r\tyo\u0012\u0002\u0004\u0003:L\b\u0002CABE\u0005\u0005\t\u0019A,\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a>\u0011\r\u0005e\u0018q`Av\u001b\t\tYPC\u0002\u0002~\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\t!a?\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u000f\u0011i\u0001E\u0002G\u0005\u0013I1Aa\u0003H\u0005\u001d\u0011un\u001c7fC:D\u0011\"a!%\u0003\u0003\u0005\r!a;\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012aV\u0001\ti>\u001cFO]5oOR\u0011\u0011q[\u0001\u0007KF,\u0018\r\\:\u0015\t\t\u001d!1\u0004\u0005\n\u0003\u0007;\u0013\u0011!a\u0001\u0003W\fQa\u0015;bi\u0016\u00042!a**'\u0015I#1EAI!)\u0011)Ca\u000b\u0002J\u0005}\u0015QU\u0007\u0003\u0005OQ1A!\u000bH\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\f\u0003(\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\t}\u0011!B1qa2LHCBAS\u0005k\u00119\u0004C\u0004\u0002\u00182\u0002\r!!\u0013\t\u000f\u0005mE\u00061\u0001\u0002 \u00069QO\\1qa2LH\u0003\u0002B\u001f\u0005\u000b\u0002BA\u00127\u0003@A9aI!\u0011\u0002J\u0005}\u0015b\u0001B\"\u000f\n1A+\u001e9mKJB\u0011Ba\u0012.\u0003\u0003\u0005\r!!*\u0002\u0007a$\u0003'A\u0003ti\u0006$X-\u0006\u0002\u0003NA1!q\nB.\u0003Kk!A!\u0015\u000b\t\tM#QK\u0001\u0007CR|W.[2\u000b\u0007\t\u00149F\u0003\u0003\u0003Z\u0005}\u0017\u0001B;uS2LAA!\u0018\u0003R\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW-\u0001\u0004ti\u0006$X\rI\u0001\fSN\fe/Y5mC\ndW-\u0006\u0002\u0003\bQ!!q\u0001B4\u0011\u001d\tY*\ra\u0001\u0003+\nA\"[:N_:LGo\u001c:j]\u001e\f\u0011\u0002[3beR\u0014W-\u0019;\u0015\u0005\u0005m\u0004fA\u001a\u0003rA!!1\u000fB;\u001b\t\t)-\u0003\u0003\u0003x\u0005\u0015'a\u0002;bS2\u0014XmY\u0001\u0004a\"LGcA)\u0003~!9\u00111T\u001bA\u0002\u0005UCcB)\u0003\u0002\n\u0015%\u0011\u0012\u0005\b\u0005\u00073\u0004\u0019AA+\u0003!!\u0018.\\3ES\u001a4\u0007B\u0002BDm\u0001\u0007\u0011+\u0001\u0003nK\u0006t\u0007B\u0002BFm\u0001\u0007\u0011+\u0001\u0007ti\u0012$UM^5bi&|g.A\u000bnS:\u001cF\u000f\u001a#fm&\fG/[8o\u001b&dG.[:\u0002-5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\u0002\nq#\u001a8tkJ,g+\u00197jIN#H\rR3wS\u0006$\u0018n\u001c8\u0015\u0007E\u0013)\n\u0003\u0004\u0003\ff\u0002\r!\u0015")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong(some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish(Logging$Warning$.MODULE$.apply(this.toString(), this.getClass(), new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address())));
                    }
                    heartbeatHistory = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory = oldState.history();
                }
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, new Some<Object>(BoxesRunTime.boxToLong(timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong(oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), new Some<EventStream>(ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.history();
                }
                case 1: {
                    return this.timestamp();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() != this.org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector org$apache$pekko$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

