/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.pekko;

import java.time.Duration;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.pekko.PekkoRpcServiceUtils;
import org.apache.flink.util.Preconditions;

public class PekkoRpcServiceConfiguration {
    @Nonnull
    private final Configuration configuration;
    @Nonnull
    private final Duration timeout;
    private final long maximumFramesize;
    private final boolean captureAskCallStack;
    private final boolean forceRpcInvocationSerialization;

    private PekkoRpcServiceConfiguration(@Nonnull Configuration configuration, @Nonnull Duration timeout, long maximumFramesize, boolean captureAskCallStack, boolean forceRpcInvocationSerialization) {
        Preconditions.checkArgument((maximumFramesize > 0L ? 1 : 0) != 0, (Object)"Maximum framesize must be positive.");
        this.configuration = configuration;
        this.timeout = timeout;
        this.maximumFramesize = maximumFramesize;
        this.captureAskCallStack = captureAskCallStack;
        this.forceRpcInvocationSerialization = forceRpcInvocationSerialization;
    }

    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    public long getMaximumFramesize() {
        return this.maximumFramesize;
    }

    public boolean captureAskCallStack() {
        return this.captureAskCallStack;
    }

    public boolean isForceRpcInvocationSerialization() {
        return this.forceRpcInvocationSerialization;
    }

    public static PekkoRpcServiceConfiguration fromConfiguration(Configuration configuration) {
        Duration timeout = (Duration)configuration.get(AkkaOptions.ASK_TIMEOUT_DURATION);
        long maximumFramesize = PekkoRpcServiceUtils.extractMaximumFramesize(configuration);
        boolean captureAskCallStacks = (Boolean)configuration.get(AkkaOptions.CAPTURE_ASK_CALLSTACK);
        boolean forceRpcInvocationSerialization = AkkaOptions.isForceRpcInvocationSerializationEnabled((Configuration)configuration);
        return new PekkoRpcServiceConfiguration(configuration, timeout, maximumFramesize, captureAskCallStacks, forceRpcInvocationSerialization);
    }

    public static PekkoRpcServiceConfiguration defaultConfiguration() {
        return PekkoRpcServiceConfiguration.fromConfiguration(new Configuration());
    }
}

