/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.actor.ActorSystemImpl;
import akka.actor.BootstrapSetup;
import akka.actor.setup.ActorSystemSetup;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.FatalExitExceptionHandler;
import scala.Option;
import scala.concurrent.ExecutionContext;

public abstract class RobustActorSystem
extends ActorSystemImpl {
    public RobustActorSystem(String name, Config applicationConfig, ClassLoader classLoader, Option<ExecutionContext> defaultExecutionContext, ActorSystemSetup setup) {
        super(name, applicationConfig, classLoader, defaultExecutionContext, Option.empty(), setup);
    }

    public static RobustActorSystem create(String name, Config applicationConfig) {
        return RobustActorSystem.create(name, applicationConfig, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
    }

    @VisibleForTesting
    static RobustActorSystem create(String name, Config applicationConfig, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        return RobustActorSystem.create(name, ActorSystemSetup.create(BootstrapSetup.create(Optional.empty(), Optional.of(applicationConfig), Optional.empty())), uncaughtExceptionHandler);
    }

    private static RobustActorSystem create(String name, ActorSystemSetup setup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Optional<BootstrapSetup> bootstrapSettings = setup.get(BootstrapSetup.class);
        ClassLoader classLoader = RobustActorSystem.class.getClassLoader();
        Config appConfig = bootstrapSettings.map(BootstrapSetup::config).flatMap(RobustActorSystem::toJavaOptional).orElseGet(() -> ConfigFactory.load(classLoader));
        Option defaultEC = RobustActorSystem.toScalaOption(bootstrapSettings.map(BootstrapSetup::defaultExecutionContext).flatMap(RobustActorSystem::toJavaOptional));
        final PostShutdownClassLoadingErrorFilter postShutdownClassLoadingErrorFilter = new PostShutdownClassLoadingErrorFilter(uncaughtExceptionHandler);
        RobustActorSystem robustActorSystem = new RobustActorSystem(name, appConfig, classLoader, defaultEC, setup){

            @Override
            public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
                return postShutdownClassLoadingErrorFilter;
            }
        };
        robustActorSystem.registerOnTermination(postShutdownClassLoadingErrorFilter::notifyShutdownComplete);
        robustActorSystem.start();
        return robustActorSystem;
    }

    private static <T> Optional<T> toJavaOptional(Option<T> option) {
        return Optional.ofNullable(option.getOrElse(() -> null));
    }

    private static <T> Option<T> toScalaOption(Optional<T> option) {
        return option.map(Option::apply).orElse(Option.empty());
    }

    private static class PostShutdownClassLoadingErrorFilter
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean shutdownComplete = new AtomicBoolean();
        private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        public PostShutdownClassLoadingErrorFilter(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        public void notifyShutdownComplete() {
            this.shutdownComplete.set(true);
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (this.shutdownComplete.get() && (e instanceof NoClassDefFoundError || e instanceof ClassNotFoundException)) {
                return;
            }
            this.uncaughtExceptionHandler.uncaughtException(t, e);
        }
    }
}

