/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.dispatch.DefaultDispatcherPrerequisites;
import akka.dispatch.DispatcherConfigurator;
import akka.dispatch.DispatcherPrerequisites;
import com.typesafe.config.Config;
import org.apache.flink.runtime.rpc.akka.PrioritySettingThreadFactory;

public class PriorityThreadsDispatcher
extends DispatcherConfigurator {
    public PriorityThreadsDispatcher(Config config, DispatcherPrerequisites prerequisites) {
        super(config, PriorityThreadsDispatcher.createPriorityThreadDispatcherPrerequisites(prerequisites, config.getInt("thread-priority")));
    }

    private static DispatcherPrerequisites createPriorityThreadDispatcherPrerequisites(DispatcherPrerequisites prerequisites, int newThreadPriority) {
        return new DefaultDispatcherPrerequisites(new PrioritySettingThreadFactory(prerequisites.threadFactory(), newThreadPriority), prerequisites.eventStream(), prerequisites.scheduler(), prerequisites.dynamicAccess(), prerequisites.settings(), prerequisites.mailboxes(), prerequisites.defaultExecutionContext());
    }
}

