/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import akka.actor.ActorSystem;
import akka.remote.RemoteTransportException;
import akka.remote.transport.netty.ConfigSSLEngineProvider;
import com.typesafe.config.Config;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.util.FingerprintTrustManagerFactory;

public class CustomSSLEngineProvider
extends ConfigSSLEngineProvider {
    private final String sslTrustStore;
    private final String sslTrustStorePassword;
    private final List<String> sslCertFingerprints;

    public CustomSSLEngineProvider(ActorSystem system) {
        super(system);
        Config securityConfig = system.settings().config().getConfig("akka.remote.classic.netty.ssl.security");
        this.sslTrustStore = securityConfig.getString("trust-store");
        this.sslTrustStorePassword = securityConfig.getString("trust-store-password");
        this.sslCertFingerprints = securityConfig.getStringList("cert-fingerprints");
    }

    @Override
    public TrustManager[] trustManagers() {
        try {
            TrustManagerFactory trustManagerFactory = this.sslCertFingerprints.isEmpty() ? TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()) : FingerprintTrustManagerFactory.builder((String)"SHA1").fingerprints(this.sslCertFingerprints).build();
            trustManagerFactory.init(this.loadKeystore(this.sslTrustStore, this.sslTrustStorePassword));
            return trustManagerFactory.getTrustManagers();
        }
        catch (GeneralSecurityException e) {
            throw new RemoteTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
    }
}

