/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.time.Duration;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.akka.AkkaRpcServiceUtils;
import org.apache.flink.util.Preconditions;

public class AkkaRpcServiceConfiguration {
    @Nonnull
    private final Configuration configuration;
    @Nonnull
    private final Duration timeout;
    private final long maximumFramesize;
    private final boolean captureAskCallStack;
    private final boolean forceRpcInvocationSerialization;

    private AkkaRpcServiceConfiguration(@Nonnull Configuration configuration, @Nonnull Duration timeout, long maximumFramesize, boolean captureAskCallStack, boolean forceRpcInvocationSerialization) {
        Preconditions.checkArgument((maximumFramesize > 0L ? 1 : 0) != 0, (Object)"Maximum framesize must be positive.");
        this.configuration = configuration;
        this.timeout = timeout;
        this.maximumFramesize = maximumFramesize;
        this.captureAskCallStack = captureAskCallStack;
        this.forceRpcInvocationSerialization = forceRpcInvocationSerialization;
    }

    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    public long getMaximumFramesize() {
        return this.maximumFramesize;
    }

    public boolean captureAskCallStack() {
        return this.captureAskCallStack;
    }

    public boolean isForceRpcInvocationSerialization() {
        return this.forceRpcInvocationSerialization;
    }

    public static AkkaRpcServiceConfiguration fromConfiguration(Configuration configuration) {
        Duration timeout = (Duration)configuration.get(AkkaOptions.ASK_TIMEOUT_DURATION);
        long maximumFramesize = AkkaRpcServiceUtils.extractMaximumFramesize(configuration);
        boolean captureAskCallStacks = (Boolean)configuration.get(AkkaOptions.CAPTURE_ASK_CALLSTACK);
        boolean forceRpcInvocationSerialization = AkkaOptions.isForceRpcInvocationSerializationEnabled((Configuration)configuration);
        return new AkkaRpcServiceConfiguration(configuration, timeout, maximumFramesize, captureAskCallStacks, forceRpcInvocationSerialization);
    }

    public static AkkaRpcServiceConfiguration defaultConfiguration() {
        return AkkaRpcServiceConfiguration.fromConfiguration(new Configuration());
    }
}

