/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent.akka;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;

public class ClassLoadingUtils {
    public static Runnable withContextClassLoader(Runnable runnable, ClassLoader contextClassLoader) {
        return () -> ClassLoadingUtils.runWithContextClassLoader(runnable::run, contextClassLoader);
    }

    public static Executor withContextClassLoader(Executor executor, ClassLoader contextClassLoader) {
        return new ContextClassLoaderSettingExecutor(executor, contextClassLoader);
    }

    public static <T extends Throwable> void runWithContextClassLoader(ThrowingRunnable<T> runnable, ClassLoader contextClassLoader) throws T {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)contextClassLoader);){
            runnable.run();
        }
    }

    public static <T, E extends Throwable> T runWithContextClassLoader(SupplierWithException<T, E> supplier, ClassLoader contextClassLoader) throws E {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)contextClassLoader);){
            Object object = supplier.get();
            return (T)object;
        }
    }

    public static <T> CompletableFuture<T> guardCompletionWithContextClassLoader(CompletableFuture<T> future, ClassLoader contextClassLoader) {
        CompletableFuture guardedFuture = new CompletableFuture();
        future.whenComplete((value, throwable) -> ClassLoadingUtils.runWithContextClassLoader(() -> FutureUtils.doForward((Object)value, (Throwable)throwable, (CompletableFuture)guardedFuture), contextClassLoader));
        return guardedFuture;
    }

    private static class ContextClassLoaderSettingExecutor
    implements Executor {
        private final Executor backingExecutor;
        private final ClassLoader contextClassLoader;

        public ContextClassLoaderSettingExecutor(Executor backingExecutor, ClassLoader contextClassLoader) {
            this.backingExecutor = backingExecutor;
            this.contextClassLoader = contextClassLoader;
        }

        @Override
        public void execute(Runnable command) {
            this.backingExecutor.execute(ClassLoadingUtils.withContextClassLoader(command, this.contextClassLoader));
        }
    }
}

