/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import akka.annotation.InternalApi;
import akka.util.DoubleLinkedList;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.RecencyList;
import akka.util.SegmentedRecencyList$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\t\rvAB%K\u0011\u0003aeJ\u0002\u0004Q\u0015\"\u0005A*\u0015\u0005\u00061\u0006!\tA\u0017\u0005\u00067\u0006!\t\u0001X\u0004\b\u0005\u0013\u000b\u0001\u0012\u0001BF\r\u001d\u0011i)\u0001E\u0001\u0005\u001fCa\u0001W\u0003\u0005\u0002\tE\u0005BB.\u0006\t\u0003\u0011\u0019J\u0002\u0004\u0002V\u00051\u0011q\u000b\u0005\u000b\u00037B!Q1A\u0005\u0002\u0005u\u0003BCA2\u0011\t\u0005\t\u0015!\u0003\u0002`!1\u0001\f\u0003C\u0001\u0003KB\u0011\"!\u001c\t\u0001\u0004%\t!a\u000b\t\u0013\u0005=\u0004\u00021A\u0005\u0002\u0005E\u0004bBA;\u0011\u0001\u0006KA\u001b\u0005\n\u0003oB\u0001\u0019!C\u0001\u0003sB\u0011\"!!\t\u0001\u0004%\t!a!\t\u0011\u0005\u001d\u0005\u0002)Q\u0005\u0003wB\u0011\"!#\t\u0001\u0004%\t!a#\t\u0013\u0005=\u0005\u00021A\u0005\u0002\u0005E\u0005\u0002CAK\u0011\u0001\u0006K!!$\t\u0013\u0005]\u0005\u00021A\u0005\u0002\u0005-\u0005\"CAM\u0011\u0001\u0007I\u0011AAN\u0011!\ty\n\u0003Q!\n\u00055\u0005\"CAQ\u0011\u0001\u0007I\u0011AAF\u0011%\t\u0019\u000b\u0003a\u0001\n\u0003\t)\u000b\u0003\u0005\u0002*\"\u0001\u000b\u0015BAG\u0011%\tY\u000b\u0003a\u0001\n\u0003\tY\tC\u0005\u0002.\"\u0001\r\u0011\"\u0001\u00020\"A\u00111\u0017\u0005!B\u0013\tiIB\u0003Q\u0015\nau\f\u0003\u0005b=\t\u0005\t\u0015!\u0003c\u0011!igD!A!\u0002\u0013q\u0007\"\u0002-\u001f\t\u0003A\b\"CA\b=\u0001\u0007I\u0011BA\t\u0011%\tIB\ba\u0001\n\u0013\tY\u0002\u0003\u0005\u0002(y\u0001\u000b\u0015BA\n\u0011%\tIC\ba\u0001\n\u0013\tY\u0003C\u0005\u0002.y\u0001\r\u0011\"\u0003\u00020!9\u00111\u0007\u0010!B\u0013Q\u0007\"CA\u001b=\t\u0007I\u0011BA\u0016\u0011\u001d\t9D\bQ\u0001\n)D\u0011\"!\u000f\u001f\u0005\u0004%I!a\u000b\t\u000f\u0005mb\u0004)A\u0005U\"I\u0011Q\b\u0010C\u0002\u0013%\u00111\u0006\u0005\b\u0003\u007fq\u0002\u0015!\u0003k\u0011%\t\tE\bb\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u00026z\u0001\u000b\u0011BA#\u0011%\t9L\bb\u0001\n\u0013\tI\f\u0003\u0005\u0002Fz\u0001\u000b\u0011BA^\u0011%\t9M\bb\u0001\n\u0013\tI\r\u0003\u0005\u0002Lz\u0001\u000b\u0011BA&\u0011%\tiM\bb\u0001\n\u0013\ty\r\u0003\u0005\u0002Xz\u0001\u000b\u0011BAi\u0011\u001d\tIN\bC\u0001\u0003WAq!a7\u001f\t\u0003\ti\u000eC\u0004\u0002bz!\t!a9\t\u000f\u0005\u001dh\u0004\"\u0001\u0002j\"9\u0011Q\u001e\u0010\u0005\u0002\u0005=\bbBA}=\u0011\u0005\u00111 \u0005\b\u0003\u007ftB\u0011\u0001B\u0001\u0011\u001d\u0011iB\bC\u0001\u0005?AqAa\t\u001f\t\u0003\u0011y\u0002C\u0004\u0003&y!\tAa\n\t\u000f\tmb\u0004\"\u0001\u0003>!9!1\t\u0010\u0005\n\t\u0015\u0003b\u0002B$=\u0011%!\u0011\n\u0005\b\u0005\u001brB\u0011\u0002B(\u0011\u001d\u0011)F\bC\u0005\u0005/BqAa\u0017\u001f\t\u0013\u0011i\u0006C\u0004\u0003by!IAa\u0019\t\u000f\t%d\u0004\"\u0003\u0003l!9!q\u000e\u0010\u0005\n\tE\u0014\u0001F*fO6,g\u000e^3e%\u0016\u001cWM\\2z\u0019&\u001cHO\u0003\u0002L\u0019\u0006!Q\u000f^5m\u0015\u0005i\u0015\u0001B1lW\u0006\u0004\"aT\u0001\u000e\u0003)\u0013AcU3h[\u0016tG/\u001a3SK\u000e,gnY=MSN$8CA\u0001S!\t\u0019f+D\u0001U\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001O\u0003\u0015)W\u000e\u001d;z+\ri&Q\u0011\u000b\u0004=\n\u001d\u0005\u0003B(\u001f\u0005\u0007+\"\u0001\u0019?\u0014\u0005y\u0011\u0016!D5oSRL\u0017\r\u001c'j[&$8\u000fE\u0002dQ*l\u0011\u0001\u001a\u0006\u0003K\u001a\f\u0011\"[7nkR\f'\r\\3\u000b\u0005\u001d$\u0016AC2pY2,7\r^5p]&\u0011\u0011\u000e\u001a\u0002\u0004'\u0016\f\bCA*l\u0013\taGKA\u0002J]R\fQa\u00197pG.\u00042aT8r\u0013\t\u0001(JA\u0005PaRLwN\u001c,bYB\u0011!/\u001e\b\u0003\u001fNL!\u0001\u001e&\u0002\u0017I+7-\u001a8ds2K7\u000f^\u0005\u0003m^\u0014Qa\u00117pG.T!\u0001\u001e&\u0015\u000be\fY!!\u0004\u0011\u0007=s\"\u0010\u0005\u0002|y2\u0001A!B?\u001f\u0005\u0004q(!A!\u0012\u0007}\f)\u0001E\u0002T\u0003\u0003I1!a\u0001U\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aUA\u0004\u0013\r\tI\u0001\u0016\u0002\u0004\u0003:L\b\"B1\"\u0001\u0004\u0011\u0007\"B7\"\u0001\u0004q\u0017A\u00027j[&$8/\u0006\u0002\u0002\u0014A!1-!\u0006k\u0013\r\t9\u0002\u001a\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018A\u00037j[&$8o\u0018\u0013fcR!\u0011QDA\u0012!\r\u0019\u0016qD\u0005\u0004\u0003C!&\u0001B+oSRD\u0011\"!\n$\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\u0004mS6LGo\u001d\u0011\u0002\u0015Q|G/\u00197MS6LG/F\u0001k\u00039!x\u000e^1m\u0019&l\u0017\u000e^0%KF$B!!\b\u00022!A\u0011Q\u0005\u0014\u0002\u0002\u0003\u0007!.A\u0006u_R\fG\u000eT5nSR\u0004\u0013A\u00027fm\u0016d7/A\u0004mKZ,Gn\u001d\u0011\u0002\r1|w/Z:u\u0003\u001dawn^3ti\u0002\nq\u0001[5hQ\u0016\u001cH/\u0001\u0005iS\u001eDWm\u001d;!\u0003!\u0019XmZ7f]R\u001cXCAA#!\u0019\t9%!\u0013\u0002L5\ta-C\u0002\u0002\u0018\u0019\u0004RaTA'\u0003#J1!a\u0014K\u0005A!u.\u001e2mK2Kgn[3e\u0019&\u001cH\u000f\u0005\u0003\u0002T!QhBA(\u0001\u0005\u0011qu\u000eZ3\u0016\t\u0005e\u0013\u0011M\n\u0003\u0011I\u000bQA^1mk\u0016,\"!a\u0018\u0011\u0007m\f\t\u0007B\u0003~\u0011\t\u0007a0\u0001\u0004wC2,X\r\t\u000b\u0005\u0003O\nY\u0007E\u0003\u0002j!\ty&D\u0001\u0002\u0011\u001d\tYf\u0003a\u0001\u0003?\nQ\u0001\\3wK2\f\u0011\u0002\\3wK2|F%Z9\u0015\t\u0005u\u00111\u000f\u0005\t\u0003Ki\u0011\u0011!a\u0001U\u00061A.\u001a<fY\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0016\u0005\u0005m\u0004cA*\u0002~%\u0019\u0011q\u0010+\u0003\t1{gnZ\u0001\u000ei&lWm\u001d;b[B|F%Z9\u0015\t\u0005u\u0011Q\u0011\u0005\n\u0003K\u0001\u0012\u0011!a\u0001\u0003w\n!\u0002^5nKN$\u0018-\u001c9!\u0003)aWm]:SK\u000e,g\u000e^\u000b\u0003\u0003\u001b\u0003BaT8\u0002h\u0005qA.Z:t%\u0016\u001cWM\u001c;`I\u0015\fH\u0003BA\u000f\u0003'C\u0011\"!\n\u0014\u0003\u0003\u0005\r!!$\u0002\u00171,7o\u001d*fG\u0016tG\u000fI\u0001\u000b[>\u0014XMU3dK:$\u0018AD7pe\u0016\u0014VmY3oi~#S-\u001d\u000b\u0005\u0003;\ti\nC\u0005\u0002&Y\t\t\u00111\u0001\u0002\u000e\u0006YQn\u001c:f%\u0016\u001cWM\u001c;!\u0003Eyg/\u001a:bY2dUm]:SK\u000e,g\u000e^\u0001\u0016_Z,'/\u00197m\u0019\u0016\u001c8OU3dK:$x\fJ3r)\u0011\ti\"a*\t\u0013\u0005\u0015\u0012$!AA\u0002\u00055\u0015AE8wKJ\fG\u000e\u001c'fgN\u0014VmY3oi\u0002\n\u0011c\u001c<fe\u0006dG.T8sKJ+7-\u001a8u\u0003Uyg/\u001a:bY2luN]3SK\u000e,g\u000e^0%KF$B!!\b\u00022\"I\u0011Q\u0005\u000f\u0002\u0002\u0003\u0007\u0011QR\u0001\u0013_Z,'/\u00197m\u001b>\u0014XMU3dK:$\b%A\u0005tK\u001elWM\u001c;tA\u0005)1/\u001b>fgV\u0011\u00111\u0018\t\u0006\u0003{\u000b\u0019M[\u0007\u0003\u0003\u007fS1!!1g\u0003\u001diW\u000f^1cY\u0016LA!a\u0006\u0002@\u000611/\u001b>fg\u0002\nab\u001c<fe\u0006dGNU3dK:\u001c\u00170\u0006\u0002\u0002L\u0005yqN^3sC2d'+Z2f]\u000eL\b%\u0001\u0006m_>\\W\u000f\u001d(pI\u0016,\"!!5\u0011\u000f\u0005u\u00161\u001b>\u0002R%!\u0011Q[A`\u0005\ri\u0015\r]\u0001\fY>|7.\u001e9O_\u0012,\u0007%\u0001\u0003tSj,\u0017AB:ju\u0016|e\rF\u0002k\u0003?Da!!\u001c8\u0001\u0004Q\u0017AB;qI\u0006$X\rF\u0002z\u0003KDa!a\u00179\u0001\u0004Q\u0018A\u0002:f[>4X\rF\u0002z\u0003WDa!a\u0017:\u0001\u0004Q\u0018\u0001C2p]R\f\u0017N\\:\u0015\t\u0005E\u0018q\u001f\t\u0004'\u0006M\u0018bAA{)\n9!i\\8mK\u0006t\u0007BBA.u\u0001\u0007!0A\u0006mK\u0006\u001cHOU3dK:$XCAA\u007f!\ryuN_\u0001\u0014Y\u0016\f7\u000f\u001e+p\u001b>\u001cHOU3dK:$xJ\u001a\u000b\u0005\u0005\u0007\u0011Y\u0002E\u0003\u0003\u0006\tU!P\u0004\u0003\u0003\b\tEa\u0002\u0002B\u0005\u0005\u001fi!Aa\u0003\u000b\u0007\t5\u0011,\u0001\u0004=e>|GOP\u0005\u0002+&\u0019!1\u0003+\u0002\u000fA\f7m[1hK&!!q\u0003B\r\u0005!IE/\u001a:bi>\u0014(b\u0001B\n)\"1\u0011Q\u000e\u001fA\u0002)\f!D]3n_Z,G*Z1tiJ+7-\u001a8u\u001fZ,'\u000fT5nSR$\"A!\t\u0011\u0007\rD'0A\tsK6|g/\u001a'fCN$(+Z2f]R\fqD]3n_Z,wJ^3sC2dG*Z1tiJ+7-\u001a8u\u001fV$8/\u001b3f)\u0011\u0011\tC!\u000b\t\u000f\t-r\b1\u0001\u0003.\u0005AA-\u001e:bi&|g\u000e\u0005\u0003\u00030\t]RB\u0001B\u0019\u0015\u0011\u0011YCa\r\u000b\u0007\tUB+\u0001\u0006d_:\u001cWO\u001d:f]RLAA!\u000f\u00032\tqa)\u001b8ji\u0016$UO]1uS>t\u0017\u0001D;qI\u0006$X\rT5nSR\u001cH\u0003BA\u000f\u0005\u007fAaA!\u0011A\u0001\u0004\u0011\u0017!\u00038fo2KW.\u001b;t\u0003U\tGM[;tiB\u0013x\u000e^3di\u0016$G*\u001a<fYN$\"!!\b\u0002\r\u0005$'.^:u)\u0011\tiBa\u0013\t\r\u00055$\t1\u0001k\u0003\u0019Ign]3siR!\u0011Q\u0004B)\u0011\u001d\u0011\u0019f\u0011a\u0001\u0003#\nAA\\8eK\u00069\u0001O]8n_R,G\u0003BA\u000f\u00053BqAa\u0015E\u0001\u0004\t\t&\u0001\u0004eK6|G/\u001a\u000b\u0005\u0003;\u0011y\u0006C\u0004\u0003T\u0015\u0003\r!!\u0015\u0002\u0011\u0005\u0004\b/\u001a8e)>$b!!\b\u0003f\t\u001d\u0004BBA7\r\u0002\u0007!\u000eC\u0004\u0003T\u0019\u0003\r!!\u0015\u0002-I,Wn\u001c<f\rJ|WnQ;se\u0016tG\u000fT3wK2$B!!\b\u0003n!9!1K$A\u0002\u0005E\u0013A\u0003:f[>4XMT8eKR\u0019!Pa\u001d\t\u000f\tM\u0003\n1\u0001\u0002R!\u001aaDa\u001e\u0011\t\te$qP\u0007\u0003\u0005wR1A! M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u0013YHA\u0006J]R,'O\\1m\u0003BL\u0007cA>\u0003\u0006\u0012)Qp\u0001b\u0001}\"1\u0011qB\u0002A\u0002\t\f!c^5uQ>3XM]1mYJ+7-\u001a8dsB\u0019\u0011\u0011N\u0003\u0003%]LG\u000f[(wKJ\fG\u000e\u001c*fG\u0016t7-_\n\u0003\u000bI#\"Aa#\u0016\t\tU%1\u0014\u000b\u0005\u0005/\u0013i\n\u0005\u0003P=\te\u0005cA>\u0003\u001c\u0012)Qp\u0002b\u0001}\"1\u0011qB\u0004A\u0002\tD3!\u0001B<Q\r\u0001!q\u000f")
@InternalApi
public final class SegmentedRecencyList<A> {
    private final RecencyList.Clock clock;
    private scala.collection.immutable.IndexedSeq<Object> limits;
    private int totalLimit;
    private final int levels;
    private final int lowest;
    private final int highest;
    private final scala.collection.IndexedSeq<DoubleLinkedList<Node<A>>> segments;
    private final IndexedSeq<Object> sizes;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;

    public static <A> SegmentedRecencyList<A> empty(scala.collection.immutable.Seq<Object> seq) {
        return SegmentedRecencyList$.MODULE$.empty(seq);
    }

    private scala.collection.immutable.IndexedSeq<Object> limits() {
        return this.limits;
    }

    private void limits_$eq(scala.collection.immutable.IndexedSeq<Object> x$1) {
        this.limits = x$1;
    }

    private int totalLimit() {
        return this.totalLimit;
    }

    private void totalLimit_$eq(int x$1) {
        this.totalLimit = x$1;
    }

    private int levels() {
        return this.levels;
    }

    private int lowest() {
        return this.lowest;
    }

    private int highest() {
        return this.highest;
    }

    private scala.collection.IndexedSeq<DoubleLinkedList<Node<A>>> segments() {
        return this.segments;
    }

    private IndexedSeq<Object> sizes() {
        return this.sizes;
    }

    private DoubleLinkedList<Node<A>> overallRecency() {
        return this.overallRecency;
    }

    private Map<A, Node<A>> lookupNode() {
        return this.lookupNode;
    }

    public int size() {
        return this.lookupNode().size();
    }

    public int sizeOf(int level) {
        return BoxesRunTime.unboxToInt(this.sizes().apply(level));
    }

    public SegmentedRecencyList<A> update(A value) {
        if (this.lookupNode().contains(value)) {
            this.promote((Node)this.lookupNode().apply(value));
        } else {
            this.insert(new Node<A>(value));
        }
        return this;
    }

    public SegmentedRecencyList<A> remove(A value) {
        BoxedUnit boxedUnit = this.lookupNode().contains(value) ? this.removeNode((Node)this.lookupNode().apply(value)) : BoxedUnit.UNIT;
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode().contains(value);
    }

    public A leastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return OptionVal$Some$.MODULE$.apply(first.value());
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostRecentOf(int level) {
        return ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().map((Function1<Node, Object> & Serializable & scala.Serializable)x$5 -> x$5.value());
    }

    public scala.collection.immutable.Seq<A> removeLeastRecentOverLimit() {
        if (this.size() > this.totalLimit()) {
            this.adjustProtectedLevels();
            int excess = this.size() - this.totalLimit();
            if (excess == 1) {
                return this.removeLeastRecent();
            }
            return ((DoubleLinkedList)this.segments().apply(this.lowest())).forwardIterator().take(excess).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeLeastRecent() {
        Node node = (Node)((DoubleLinkedList)this.segments().apply(this.lowest())).getFirst();
        Node node2 = OptionVal$Some$.MODULE$.unapply(node);
        if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
            Node first = OptionVal$.MODULE$.get$extension(node2);
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray(new Object[]{this.removeNode(first)}));
        }
        return Nil$.MODULE$;
    }

    public scala.collection.immutable.Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled");
        }
        long min = OptionVal$.MODULE$.get$extension(this.clock).earlierTime(duration);
        return this.overallRecency().forwardIterator().takeWhile((Function1<Node, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(SegmentedRecencyList.$anonfun$removeOverallLeastRecentOutside$1(min, x$6))).map((Function1<Node, Object> & Serializable & scala.Serializable)node -> this.removeNode((Node)node)).toList();
    }

    public void updateLimits(scala.collection.immutable.Seq<Object> newLimits) {
        this.limits_$eq(newLimits.toIndexedSeq());
        this.totalLimit_$eq(BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$)));
    }

    private void adjustProtectedLevels() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.highest()), this.lowest()).by(-1).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)level -> this.adjust(level));
    }

    private void adjust(int level) {
        int excess = BoxesRunTime.unboxToInt(this.sizes().apply(level)) - BoxesRunTime.unboxToInt(this.limits().apply(level));
        if (excess > 0) {
            ((DoubleLinkedList)this.segments().apply(level)).forwardIterator().take(excess).foreach((Function1<Node, Object> & Serializable & scala.Serializable)node -> {
                this.demote(node);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void insert(Node<A> node) {
        this.appendTo(this.lowest(), node);
        this.lookupNode().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(node.value()), node));
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().append(node);
            return;
        }
    }

    private void promote(Node<A> node) {
        Object object;
        if (node.level() == this.highest()) {
            object = ((DoubleLinkedList)this.segments().apply(node.level())).moveToBack(node);
        } else {
            int newLevel = node.level() + 1;
            this.removeFromCurrentLevel(node);
            this.appendTo(newLevel, node);
            this.adjust(newLevel);
            object = BoxedUnit.UNIT;
        }
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            node.timestamp_$eq(OptionVal$.MODULE$.get$extension(this.clock).currentTime());
            this.overallRecency().moveToBack(node);
            return;
        }
    }

    private void demote(Node<A> node) {
        this.removeFromCurrentLevel(node);
        this.appendTo(node.level() - 1, node);
    }

    private void appendTo(int level, Node<A> node) {
        node.level_$eq(level);
        ((DoubleLinkedList)this.segments().apply(level)).append(node);
        this.sizes().update(level, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(level)) + 1));
    }

    private void removeFromCurrentLevel(Node<A> node) {
        ((DoubleLinkedList)this.segments().apply(node.level())).remove(node);
        int n = node.level();
        this.sizes().update(n, BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.sizes().apply(n)) - 1));
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.removeFromCurrentLevel(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency().remove(node);
        }
        this.lookupNode().$minus$eq(value);
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$removeOverallLeastRecentOutside$1(long min$1, Node x$6) {
        return x$6.timestamp() < min$1;
    }

    public SegmentedRecencyList(scala.collection.immutable.Seq<Object> initialLimits, RecencyList.Clock clock) {
        this.clock = clock;
        this.limits = initialLimits.toIndexedSeq();
        this.totalLimit = BoxesRunTime.unboxToInt(this.limits().sum(Numeric$IntIsIntegral$.MODULE$));
        this.levels = this.limits().size();
        this.lowest = 0;
        this.highest = this.levels() - 1;
        this.segments = (scala.collection.IndexedSeq)package$.MODULE$.IndexedSeq().fill(this.levels(), (Function0<DoubleLinkedList> & Serializable & scala.Serializable)() -> new DoubleLinkedList((Function1<Node, Object> & Serializable & scala.Serializable)x$1 -> new OptionVal<Node>(x$1.lessRecent()), (Function1<Node, Object> & Serializable & scala.Serializable)x$2 -> new OptionVal<Node>(x$2.moreRecent()), (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, previous) -> {
            node.lessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, next) -> {
            node.moreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        }));
        this.sizes = (IndexedSeq)IndexedSeq$.MODULE$.fill(this.levels(), (JFunction0$mcI$sp & scala.Serializable)() -> 0);
        this.overallRecency = new DoubleLinkedList((Function1<Node, Object> & Serializable & scala.Serializable)x$3 -> new OptionVal<Node>(x$3.overallLessRecent()), (Function1<Node, Object> & Serializable & scala.Serializable)x$4 -> new OptionVal<Node>(x$4.overallMoreRecent()), (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, previous) -> {
            node.overallLessRecent_$eq((Node)((OptionVal)previous).x());
            return BoxedUnit.UNIT;
        }, (Function2<Node, Object, Object> & Serializable & scala.Serializable)(node, next) -> {
            node.overallMoreRecent_$eq((Node)((OptionVal)next).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = Map$.MODULE$.empty();
    }

    private static final class Node<A> {
        private final A value;
        private int level;
        private long timestamp;
        private Node<A> lessRecent;
        private Node<A> moreRecent;
        private Node<A> overallLessRecent;
        private Node<A> overallMoreRecent;

        public A value() {
            return this.value;
        }

        public int level() {
            return this.level;
        }

        public void level_$eq(int x$1) {
            this.level = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }

        public Node<A> lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node<A> x$1) {
            this.lessRecent = x$1;
        }

        public Node<A> moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node<A> x$1) {
            this.moreRecent = x$1;
        }

        public Node<A> overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node<A> x$1) {
            this.overallLessRecent = x$1;
        }

        public Node<A> overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node<A> x$1) {
            this.overallMoreRecent = x$1;
        }

        public Node(A value) {
            this.value = value;
            this.level = 0;
            this.timestamp = 0L;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
        }
    }
}

