/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport.netty;

import akka.ConfigurationException;
import akka.dispatch.ThreadPoolConfig$;
import akka.remote.transport.netty.SSLSettings;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import akka.util.Helpers$Requiring$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.net.InetAddress;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcZI$sp;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\u0017/\u0001]B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0011\u0019\u0011\u0006\u0001)A\u0005\u001f\"91\u000b\u0001b\u0001\n\u0003!\u0006B\u00021\u0001A\u0003%Q\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r\u0019\u0004\u0001\u0015!\u0003d\u0011\u00199\u0007\u0001)C\u0005Q\"9q\u000e\u0001b\u0001\n\u0003\u0001\bBB=\u0001A\u0003%\u0011\u000fC\u0004{\u0001\t\u0007I\u0011A>\t\rq\u0004\u0001\u0015!\u0003j\u0011\u001di\bA1A\u0005\u0002mDaA \u0001!\u0002\u0013I\u0007bB@\u0001\u0005\u0004%\ta\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003j\u0011!\t\u0019\u0001\u0001b\u0001\n\u0003Y\bbBA\u0003\u0001\u0001\u0006I!\u001b\u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013Aq!a\u0003\u0001A\u0003%!\u000eC\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\n!9\u0011q\u0002\u0001!\u0002\u0013Q\u0007\u0002CA\t\u0001\t\u0007I\u0011\u0001(\t\u000f\u0005M\u0001\u0001)A\u0005\u001f\"A\u0011Q\u0003\u0001C\u0002\u0013\u0005a\nC\u0004\u0002\u0018\u0001\u0001\u000b\u0011B(\t\u0011\u0005e\u0001A1A\u0005\u00029Cq!a\u0007\u0001A\u0003%q\n\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0001U\u0011\u001d\ty\u0002\u0001Q\u0001\nUC\u0001\"!\t\u0001\u0005\u0004%\t\u0001\u0016\u0005\b\u0003G\u0001\u0001\u0015!\u0003V\u0011%\t)\u0003\u0001b\u0001\n\u0003\tI\u0001C\u0004\u00028\u0001\u0001\u000b\u0011\u00026\t\u0013\u0005m\u0002A1A\u0005\u0002\u0005%\u0001bBA\"\u0001\u0001\u0006IA\u001b\u0005\n\u0003\u000f\u0002!\u0019!C\u0001\u0003\u0013B\u0001\"a\u0015\u0001A\u0003%\u00111\n\u0005\n\u0003+\u0002!\u0019!C\u0001\u0003\u0013Aq!a\u0016\u0001A\u0003%!\u000eC\u0005\u0002Z\u0001\u0011\r\u0011\"\u0001\u0002\n!9\u00111\f\u0001!\u0002\u0013Q\u0007bBA/\u0001\u0011%\u0011q\f\u0002\u0017\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u'\u0016$H/\u001b8hg*\u0011q\u0006M\u0001\u0006]\u0016$H/\u001f\u0006\u0003cI\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005M\"\u0014A\u0002:f[>$XMC\u00016\u0003\u0011\t7n[1\u0004\u0001M\u0011\u0001\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\r\r|gNZ5h!\t\u0001e)D\u0001B\u0015\tq$I\u0003\u0002D\t\u0006AA/\u001f9fg\u00064WMC\u0001F\u0003\r\u0019w.\\\u0005\u0003\u000f\u0006\u0013aaQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002K\u0019B\u00111\nA\u0007\u0002]!)aH\u0001a\u0001\u007f\u0005IQI\\1cY\u0016\u001c6\u000f\\\u000b\u0002\u001fB\u0011\u0011\bU\u0005\u0003#j\u0012qAQ8pY\u0016\fg.\u0001\u0006F]\u0006\u0014G.Z*tY\u0002\n!dU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u00072\f7o\u001d(b[\u0016,\u0012!\u0016\t\u0003-vs!aV.\u0011\u0005aST\"A-\u000b\u0005i3\u0014A\u0002\u001fs_>$h(\u0003\u0002]u\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta&(A\u000eT'2+enZ5oKB\u0013xN^5eKJ\u001cE.Y:t\u001d\u0006lW\rI\u0001\u0013+N,G)[:qCR\u001c\u0007.\u001a:G_JLu.F\u0001d!\rID-V\u0005\u0003Kj\u0012aa\u00149uS>t\u0017aE+tK\u0012K7\u000f]1uG\",'OR8s\u0013>\u0004\u0013AC8qi&|gnU5{KR\u0011\u0011.\u001c\t\u0004s\u0011T\u0007CA\u001dl\u0013\ta'HA\u0002J]RDQA\\\u0005A\u0002U\u000b\u0011a]\u0001\u0012\u0007>tg.Z2uS>tG+[7f_V$X#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005YT\u0014AC2p]\u000e,(O]3oi&\u0011\u0001p\u001d\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0003I\u0019uN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u00021]\u0013\u0018\u000e^3Ck\u001a4WM\u001d%jO\"<\u0016\r^3s\u001b\u0006\u00148.F\u0001j\u0003e9&/\u001b;f\u0005V4g-\u001a:IS\u001eDw+\u0019;fe6\u000b'o\u001b\u0011\u0002/]\u0013\u0018\u000e^3Ck\u001a4WM\u001d'po^\u000bG/\u001a:NCJ\\\u0017\u0001G,sSR,')\u001e4gKJdun^,bi\u0016\u0014X*\u0019:lA\u0005q1+\u001a8e\u0005V4g-\u001a:TSj,\u0017aD*f]\u0012\u0014UO\u001a4feNK'0\u001a\u0011\u0002#I+7-Z5wK\n+hMZ3s'&TX-\u0001\nSK\u000e,\u0017N^3Ck\u001a4WM]*ju\u0016\u0004\u0013\u0001D'bq\u001a\u0013\u0018-\\3TSj,W#\u00016\u0002\u001b5\u000b\u0007P\u0012:b[\u0016\u001c\u0016N_3!\u0003\u001d\u0011\u0015mY6m_\u001e\f\u0001BQ1dW2|w\rI\u0001\u000b)\u000e\u0004hj\u001c3fY\u0006L\u0018a\u0003+da:{G-\u001a7bs\u0002\nA\u0002V2q\u0017\u0016,\u0007/\u00197jm\u0016\fQ\u0002V2q\u0017\u0016,\u0007/\u00197jm\u0016\u0004\u0013\u0001\u0004+daJ+Wo]3BI\u0012\u0014\u0018!\u0004+daJ+Wo]3BI\u0012\u0014\b%\u0001\u0005I_N$h.Y7f\u0003%Aun\u001d;oC6,\u0007%\u0001\u0007CS:$\u0007j\\:u]\u0006lW-A\u0007CS:$\u0007j\\:u]\u0006lW\rI\u0001\r!>\u0014HoU3mK\u000e$xN\u001d\u0015\bE\u0005%\u0012qFA\u001a!\rI\u00141F\u0005\u0004\u0003[Q$A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011G\u00014/\u0006\u0013f*\u0013(Hu\u0001\"\u0006.[:!g\"|W\u000f\u001c3!_:d\u0017\u0010\t2fAU\u001cX\r\u001a\u0011cs\u0002\u0002(o\u001c4fgNLwN\\1mg:\n#!!\u000e\u0002\u0007Ir\u0003'A\u0007Q_J$8+\u001a7fGR|'\u000f\t\u0015\bG\u0005%\u0012qFA\u001a\u0003A\u0011\u0015N\u001c3Q_J$8+\u001a7fGR|'\u000fK\u0004%\u0003S\ty#a\u0010\"\u0005\u0005\u0005\u0013a\u0001\u001a/i\u0005\t\")\u001b8e!>\u0014HoU3mK\u000e$xN\u001d\u0011)\u000f\u0015\nI#a\f\u0002@\u0005Y1k\u001d7TKR$\u0018N\\4t+\t\tY\u0005\u0005\u0003:I\u00065\u0003cA&\u0002P%\u0019\u0011\u0011\u000b\u0018\u0003\u0017M\u001bFjU3ui&twm]\u0001\r'Nd7+\u001a;uS:<7\u000fI\u0001\u001b'\u0016\u0014h/\u001a:T_\u000e\\W\r^,pe.,'\u000fU8pYNK'0Z\u0001\u001c'\u0016\u0014h/\u001a:T_\u000e\\W\r^,pe.,'\u000fU8pYNK'0\u001a\u0011\u00025\rc\u0017.\u001a8u'>\u001c7.\u001a;X_J\\WM\u001d)p_2\u001c\u0016N_3\u00027\rc\u0017.\u001a8u'>\u001c7.\u001a;X_J\\WM\u001d)p_2\u001c\u0016N_3!\u0003)\u0019w.\u001c9vi\u0016<\u0006k\u0015\u000b\u0004U\u0006\u0005\u0004\"\u0002 -\u0001\u0004y\u0004f\u0002\u0001\u0002*\u0005\u0015\u0014\u0011N\u0011\u0003\u0003O\n!f\u00117bgNL7\r\t:f[>$\u0018N\\4!SN\u0004C-\u001a9sK\u000e\fG/\u001a3-AU\u001cX\rI!si\u0016\u0014\u00180\t\u0002\u0002l\u0005)!G\f\u001c/a\u0001")
public class NettyTransportSettings {
    private final Config config;
    private final boolean EnableSsl;
    private final String SSLEngineProviderClassName;
    private final Option<String> UseDispatcherForIo;
    private final FiniteDuration ConnectionTimeout;
    private final Option<Object> WriteBufferHighWaterMark;
    private final Option<Object> WriteBufferLowWaterMark;
    private final Option<Object> SendBufferSize;
    private final Option<Object> ReceiveBufferSize;
    private final int MaxFrameSize;
    private final int Backlog;
    private final boolean TcpNodelay;
    private final boolean TcpKeepalive;
    private final boolean TcpReuseAddr;
    private final String Hostname;
    private final String BindHostname;
    private final int PortSelector;
    private final int BindPortSelector;
    private final Option<SSLSettings> SslSettings;
    private final int ServerSocketWorkerPoolSize;
    private final int ClientSocketWorkerPoolSize;

    public boolean EnableSsl() {
        return this.EnableSsl;
    }

    public String SSLEngineProviderClassName() {
        return this.SSLEngineProviderClassName;
    }

    public Option<String> UseDispatcherForIo() {
        return this.UseDispatcherForIo;
    }

    private Option<Object> optionSize(String s) {
        int n = (int)Predef$.MODULE$.Long2long(this.config.getBytes(s));
        switch (n) {
            case 0: {
                return None$.MODULE$;
            }
        }
        if (n < 0) {
            throw new ConfigurationException(new StringBuilder(52).append("Setting '").append(s).append("' must be 0 or positive (and fit in an Int)").toString());
        }
        return new Some<Object>(BoxesRunTime.boxToInteger(n));
    }

    public FiniteDuration ConnectionTimeout() {
        return this.ConnectionTimeout;
    }

    public Option<Object> WriteBufferHighWaterMark() {
        return this.WriteBufferHighWaterMark;
    }

    public Option<Object> WriteBufferLowWaterMark() {
        return this.WriteBufferLowWaterMark;
    }

    public Option<Object> SendBufferSize() {
        return this.SendBufferSize;
    }

    public Option<Object> ReceiveBufferSize() {
        return this.ReceiveBufferSize;
    }

    public int MaxFrameSize() {
        return this.MaxFrameSize;
    }

    public int Backlog() {
        return this.Backlog;
    }

    public boolean TcpNodelay() {
        return this.TcpNodelay;
    }

    public boolean TcpKeepalive() {
        return this.TcpKeepalive;
    }

    public boolean TcpReuseAddr() {
        return this.TcpReuseAddr;
    }

    public String Hostname() {
        return this.Hostname;
    }

    public String BindHostname() {
        return this.BindHostname;
    }

    public int PortSelector() {
        return this.PortSelector;
    }

    public int BindPortSelector() {
        return this.BindPortSelector;
    }

    public Option<SSLSettings> SslSettings() {
        return this.SslSettings;
    }

    public int ServerSocketWorkerPoolSize() {
        return this.ServerSocketWorkerPoolSize;
    }

    public int ClientSocketWorkerPoolSize() {
        return this.ClientSocketWorkerPoolSize;
    }

    private int computeWPS(Config config) {
        return ThreadPoolConfig$.MODULE$.scaledPoolSize(config.getInt("pool-size-min"), config.getDouble("pool-size-factor"), config.getInt("pool-size-max"));
    }

    private static final Nothing$ throwInvalidNettyVersion$1(String nettyVersion$1) {
        throw new IllegalArgumentException(new StringBuilder(196).append("akka-remote with the Netty transport requires Netty version 3.10.6 or ").append("later. Version [").append(nettyVersion$1).append("] is on the class path. Issue https://github.com/netty/netty/pull/4739 ").append("may cause messages to not be delivered.").toString());
    }

    public NettyTransportSettings(Config config) {
        this.config = config;
        this.EnableSsl = config.getBoolean("enable-ssl");
        this.SSLEngineProviderClassName = this.EnableSsl() ? config.getString("ssl-engine-provider") : "";
        String string = config.getString("use-dispatcher-for-io");
        this.UseDispatcherForIo = ("".equals(string) ? true : string == null) ? None$.MODULE$ : new Some<String>(string);
        this.ConnectionTimeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "connection-timeout");
        this.WriteBufferHighWaterMark = this.optionSize("write-buffer-high-water-mark");
        this.WriteBufferLowWaterMark = this.optionSize("write-buffer-low-water-mark");
        this.SendBufferSize = this.optionSize("send-buffer-size");
        this.ReceiveBufferSize = this.optionSize("receive-buffer-size");
        this.MaxFrameSize = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension1(Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Long2long(config.getBytes("maximum-frame-size")))), (JFunction1$mcZI$sp & scala.Serializable)x$1 -> x$1 >= 32000, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "Setting 'maximum-frame-size' must be at least 32000 bytes"));
        this.Backlog = config.getInt("backlog");
        this.TcpNodelay = config.getBoolean("tcp-nodelay");
        this.TcpKeepalive = config.getBoolean("tcp-keepalive");
        String string2 = config.getString("tcp-reuse-addr");
        this.TcpReuseAddr = "off-for-windows".equals(string2) ? !Helpers$.MODULE$.isWindows() : config.getBoolean("tcp-reuse-addr");
        String string3 = config.getString("hostname");
        this.Hostname = "".equals(string3) ? InetAddress.getLocalHost().getHostAddress() : string3;
        String string4 = config.getString("bind-hostname");
        this.BindHostname = "".equals(string4) ? this.Hostname() : string4;
        this.PortSelector = config.getInt("port");
        String string5 = config.getString("bind-port");
        this.BindPortSelector = "".equals(string5) ? this.PortSelector() : new StringOps(Predef$.MODULE$.augmentString(string5)).toInt();
        this.SslSettings = this.EnableSsl() ? new Some<SSLSettings>(new SSLSettings(config.getConfig("security"))) : None$.MODULE$;
        this.ServerSocketWorkerPoolSize = this.computeWPS(config.getConfig("server-socket-worker-pool"));
        this.ClientSocketWorkerPoolSize = this.computeWPS(config.getConfig("client-socket-worker-pool"));
        String nettyVersion = "3.10.6.Final-5f56a03";
        try {
            String[] segments = nettyVersion.split("[.-]");
            if (segments.length < 3 || new StringOps(Predef$.MODULE$.augmentString(segments[0])).toInt() != 3 || new StringOps(Predef$.MODULE$.augmentString(segments[1])).toInt() != 10 || new StringOps(Predef$.MODULE$.augmentString(segments[2])).toInt() < 6) {
                throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw NettyTransportSettings.throwInvalidNettyVersion$1(nettyVersion);
        }
    }
}

