/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.transport;

import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.AddressFromURIString$;
import akka.actor.InternalActorRef;
import akka.protobufv3.internal.InvalidProtocolBufferException;
import akka.remote.Ack;
import akka.remote.ByteStringUtils$;
import akka.remote.RemoteActorRefProvider;
import akka.remote.SeqNo;
import akka.remote.WireFormats;
import akka.remote.transport.AkkaPduCodec;
import akka.remote.transport.AkkaPduCodec$Heartbeat$;
import akka.remote.transport.AssociationHandle;
import akka.remote.transport.AssociationHandle$Quarantined$;
import akka.remote.transport.AssociationHandle$Shutdown$;
import akka.remote.transport.AssociationHandle$Unknown$;
import akka.remote.transport.HandshakeInfo;
import akka.remote.transport.HandshakeInfo$;
import akka.remote.transport.PduCodecException;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteString$ByteString1C$;
import akka.util.OptionVal$;
import akka.util.OptionVal$Some$;
import akka.util.ccompat.package$JavaConverters$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class AkkaPduProtobufCodec$
implements AkkaPduCodec {
    public static AkkaPduProtobufCodec$ MODULE$;
    private final ByteString DISASSOCIATE;
    private final ByteString DISASSOCIATE_SHUTTING_DOWN;
    private final ByteString DISASSOCIATE_QUARANTINED;
    private final ByteString constructHeartbeat;

    static {
        new AkkaPduProtobufCodec$();
    }

    @Override
    public ByteString encodePdu(AkkaPduCodec.AkkaPdu pdu) {
        return AkkaPduCodec.encodePdu$(this, pdu);
    }

    private WireFormats.AcknowledgementInfo.Builder ackBuilder(Ack ack) {
        WireFormats.AcknowledgementInfo.Builder ackBuilder = WireFormats.AcknowledgementInfo.newBuilder();
        ackBuilder.setCumulativeAck(ack.cumulativeAck().rawValue());
        ack.nacks().foreach((Function1<SeqNo, WireFormats.AcknowledgementInfo.Builder> & Serializable & scala.Serializable)nack -> ackBuilder.addNacks(nack.rawValue()));
        return ackBuilder;
    }

    @Override
    public ByteString constructMessage(Address localAddress, ActorRef recipient, WireFormats.SerializedMessage serializedMessage, ActorRef senderOption, Option<SeqNo> seqOption, Option<Ack> ackOption) {
        WireFormats.AckAndEnvelopeContainer.Builder ackAndEnvelopeBuilder = WireFormats.AckAndEnvelopeContainer.newBuilder();
        WireFormats.RemoteEnvelope.Builder envelopeBuilder = WireFormats.RemoteEnvelope.newBuilder();
        envelopeBuilder.setRecipient(this.serializeActorRef(recipient.path().address(), recipient));
        ActorRef actorRef2 = senderOption;
        ActorRef actorRef3 = OptionVal$Some$.MODULE$.unapply(actorRef2);
        if (!OptionVal$.MODULE$.isEmpty$extension(actorRef3)) {
            ActorRef sender = OptionVal$.MODULE$.get$extension(actorRef3);
            envelopeBuilder.setSender(this.serializeActorRef(localAddress, sender));
        }
        seqOption.foreach((Function1<SeqNo, WireFormats.RemoteEnvelope.Builder> & Serializable & scala.Serializable)seq -> envelopeBuilder.setSeq(seq.rawValue()));
        ackOption.foreach((Function1<Ack, WireFormats.AckAndEnvelopeContainer.Builder> & Serializable & scala.Serializable)ack -> ackAndEnvelopeBuilder.setAck(MODULE$.ackBuilder((Ack)ack)));
        envelopeBuilder.setMessage(serializedMessage);
        ackAndEnvelopeBuilder.setEnvelope(envelopeBuilder);
        return ByteString$.MODULE$.fromArrayUnsafe(ackAndEnvelopeBuilder.build().toByteArray());
    }

    @Override
    public Option<SeqNo> constructMessage$default$5() {
        return None$.MODULE$;
    }

    @Override
    public Option<Ack> constructMessage$default$6() {
        return None$.MODULE$;
    }

    @Override
    public ByteString constructPureAck(Ack ack) {
        return ByteString$.MODULE$.fromArrayUnsafe(WireFormats.AckAndEnvelopeContainer.newBuilder().setAck(this.ackBuilder(ack)).build().toByteArray());
    }

    @Override
    public ByteString constructPayload(ByteString payload) {
        return ByteString$.MODULE$.fromArrayUnsafe(WireFormats.AkkaProtocolMessage.newBuilder().setPayload(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(payload)).build().toByteArray());
    }

    @Override
    public ByteString constructAssociate(HandshakeInfo info) {
        WireFormats.AkkaHandshakeInfo.Builder handshakeInfo = WireFormats.AkkaHandshakeInfo.newBuilder().setOrigin(this.serializeAddress(info.origin())).setUid(info.uid());
        return this.constructControlMessagePdu(WireFormats.CommandType.ASSOCIATE, new Some<WireFormats.AkkaHandshakeInfo.Builder>(handshakeInfo));
    }

    private ByteString DISASSOCIATE() {
        return this.DISASSOCIATE;
    }

    private ByteString DISASSOCIATE_SHUTTING_DOWN() {
        return this.DISASSOCIATE_SHUTTING_DOWN;
    }

    private ByteString DISASSOCIATE_QUARANTINED() {
        return this.DISASSOCIATE_QUARANTINED;
    }

    @Override
    public ByteString constructDisassociate(AssociationHandle.DisassociateInfo info) {
        AssociationHandle.DisassociateInfo disassociateInfo = info;
        if (AssociationHandle$Unknown$.MODULE$.equals(disassociateInfo)) {
            return this.DISASSOCIATE();
        }
        if (AssociationHandle$Shutdown$.MODULE$.equals(disassociateInfo)) {
            return this.DISASSOCIATE_SHUTTING_DOWN();
        }
        if (AssociationHandle$Quarantined$.MODULE$.equals(disassociateInfo)) {
            return this.DISASSOCIATE_QUARANTINED();
        }
        throw new MatchError(disassociateInfo);
    }

    @Override
    public ByteString constructHeartbeat() {
        return this.constructHeartbeat;
    }

    @Override
    public AkkaPduCodec.AkkaPdu decodePdu(ByteString raw) {
        AkkaPduCodec.AkkaPdu akkaPdu;
        block4: {
            try {
                WireFormats.AkkaProtocolMessage pdu = WireFormats.AkkaProtocolMessage.parseFrom(raw.toArrayUnsafe());
                if (pdu.hasPayload()) {
                    akkaPdu = new AkkaPduCodec.Payload(ByteString$.MODULE$.fromByteBuffer(pdu.getPayload().asReadOnlyByteBuffer()));
                    break block4;
                }
                if (pdu.hasInstruction()) {
                    akkaPdu = this.decodeControlPdu(pdu.getInstruction());
                    break block4;
                }
                throw new PduCodecException("Error decoding Akka PDU: Neither message nor control message were contained", null);
            }
            catch (InvalidProtocolBufferException e) {
                throw new PduCodecException("Decoding PDU failed.", e);
            }
        }
        return akkaPdu;
    }

    @Override
    public Tuple2<Option<Ack>, Option<AkkaPduCodec.Message>> decodeMessage(ByteString raw, RemoteActorRefProvider provider, Address localAddress) {
        Option option;
        Option ackOption;
        WireFormats.AckAndEnvelopeContainer ackAndEnvelope = WireFormats.AckAndEnvelopeContainer.parseFrom(raw.toArrayUnsafe());
        Option option2 = ackOption = ackAndEnvelope.hasAck() ? new Some<Ack>(new Ack(new SeqNo(ackAndEnvelope.getAck().getCumulativeAck()), ((TraversableOnce)((TraversableLike)package$JavaConverters$.MODULE$.asScalaBufferConverter(ackAndEnvelope.getAck().getNacksList()).asScala()).map((Function1<Long, SeqNo> & Serializable & scala.Serializable)x$1 -> new SeqNo(Predef$.MODULE$.Long2long((Long)x$1)), Buffer$.MODULE$.canBuildFrom())).toSet())) : None$.MODULE$;
        if (ackAndEnvelope.hasEnvelope()) {
            ActorRef actorRef2;
            WireFormats.RemoteEnvelope msgPdu = ackAndEnvelope.getEnvelope();
            InternalActorRef internalActorRef = provider.resolveActorRefWithLocalAddress(msgPdu.getRecipient().getPath(), localAddress);
            Address address = AddressFromURIString$.MODULE$.apply(msgPdu.getRecipient().getPath());
            WireFormats.SerializedMessage serializedMessage = msgPdu.getMessage();
            if (msgPdu.hasSender()) {
                actorRef2 = OptionVal$.MODULE$.apply(provider.resolveActorRefWithLocalAddress(msgPdu.getSender().getPath(), localAddress));
            } else {
                OptionVal$.MODULE$.None();
                actorRef2 = null;
            }
            option = new Some<AkkaPduCodec.Message>(new AkkaPduCodec.Message(internalActorRef, address, serializedMessage, actorRef2, msgPdu.hasSeq() ? new Some<SeqNo>(new SeqNo(msgPdu.getSeq())) : None$.MODULE$));
        } else {
            option = None$.MODULE$;
        }
        None$ messageOption = option;
        return new Tuple2<Option<Ack>, Option<AkkaPduCodec.Message>>(ackOption, messageOption);
    }

    private AkkaPduCodec.AkkaPdu decodeControlPdu(WireFormats.AkkaControlMessage controlPdu) {
        WireFormats.CommandType commandType = controlPdu.getCommandType();
        if (WireFormats.CommandType.ASSOCIATE.equals(commandType) && controlPdu.hasHandshakeInfo()) {
            WireFormats.AkkaHandshakeInfo handshakeInfo = controlPdu.getHandshakeInfo();
            return new AkkaPduCodec.Associate(HandshakeInfo$.MODULE$.apply(this.decodeAddress(handshakeInfo.getOrigin()), (int)handshakeInfo.getUid()));
        }
        if (WireFormats.CommandType.DISASSOCIATE.equals(commandType)) {
            return new AkkaPduCodec.Disassociate(AssociationHandle$Unknown$.MODULE$);
        }
        if (WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN.equals(commandType)) {
            return new AkkaPduCodec.Disassociate(AssociationHandle$Shutdown$.MODULE$);
        }
        if (WireFormats.CommandType.DISASSOCIATE_QUARANTINED.equals(commandType)) {
            return new AkkaPduCodec.Disassociate(AssociationHandle$Quarantined$.MODULE$);
        }
        if (WireFormats.CommandType.HEARTBEAT.equals(commandType)) {
            return AkkaPduCodec$Heartbeat$.MODULE$;
        }
        throw new PduCodecException(new StringBuilder(62).append("Decoding of control PDU failed, invalid format, unexpected: [").append(commandType).append("]").toString(), null);
    }

    private Address decodeAddress(WireFormats.AddressData encodedAddress) {
        return Address$.MODULE$.apply(encodedAddress.getProtocol(), encodedAddress.getSystem(), encodedAddress.getHostname(), encodedAddress.getPort());
    }

    private ByteString constructControlMessagePdu(WireFormats.CommandType code, Option<WireFormats.AkkaHandshakeInfo.Builder> handshakeInfo) {
        WireFormats.AkkaControlMessage.Builder controlMessageBuilder = WireFormats.AkkaControlMessage.newBuilder();
        controlMessageBuilder.setCommandType(code);
        handshakeInfo.foreach((Function1<WireFormats.AkkaHandshakeInfo.Builder, WireFormats.AkkaControlMessage.Builder> & Serializable & scala.Serializable)builderForValue -> controlMessageBuilder.setHandshakeInfo((WireFormats.AkkaHandshakeInfo.Builder)builderForValue));
        return ByteString$ByteString1C$.MODULE$.apply(WireFormats.AkkaProtocolMessage.newBuilder().setInstruction(controlMessageBuilder.build()).build().toByteArray());
    }

    private WireFormats.ActorRefData serializeActorRef(Address defaultAddress, ActorRef ref) {
        return WireFormats.ActorRefData.newBuilder().setPath(ref.path().address().host().isDefined() ? ref.path().toSerializationFormat() : ref.path().toSerializationFormatWithAddress(defaultAddress)).build();
    }

    private WireFormats.AddressData serializeAddress(Address address) {
        Address address2 = address;
        if (address2 != null) {
            String protocol = address2.protocol();
            String system = address2.system();
            Option<String> option = address2.host();
            Option<Object> option2 = address2.port();
            if (option instanceof Some) {
                Some some = (Some)option;
                String host = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int port = BoxesRunTime.unboxToInt(some2.value());
                    return WireFormats.AddressData.newBuilder().setHostname(host).setPort(port).setSystem(system).setProtocol(protocol).build();
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    private AkkaPduProtobufCodec$() {
        MODULE$ = this;
        AkkaPduCodec.$init$(this);
        this.DISASSOCIATE = this.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE, None$.MODULE$);
        this.DISASSOCIATE_SHUTTING_DOWN = this.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_SHUTTING_DOWN, None$.MODULE$);
        this.DISASSOCIATE_QUARANTINED = this.constructControlMessagePdu(WireFormats.CommandType.DISASSOCIATE_QUARANTINED, None$.MODULE$);
        this.constructHeartbeat = this.constructControlMessagePdu(WireFormats.CommandType.HEARTBEAT, None$.MODULE$);
    }
}

