/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.remote.artery.compress.CompressionTable$;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.util.HashCode$;
import akka.util.ccompat.package$JavaConverters$;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.agrona.collections.Object2IntHashMap;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!B\r\u001b\u0005y\u0011\u0003\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\t\u0011A\u0002!\u0011!Q\u0001\n5B\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001BC\u0002\u0013%\u0001\b\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003:\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u00151\u0006\u0001\"\u0001X\u0011\u0015Y\u0002\u0001\"\u0001g\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0015\u0019\b\u0001\"\u0011u\u0011\u0015)\b\u0001\"\u0011w\u000f\u0019a(\u0004#\u0001\u001f{\u001a1\u0011D\u0007E\u0001=yDQaT\b\u0005\u0002}D\u0011\"!\u0001\u0010\u0005\u0004%)!a\u0001\t\u0011\u0005%q\u0002)A\u0007\u0003\u000bA\u0011\"a\u0003\u0010\u0005\u0004%)!!\u0004\t\u0011\u0005Er\u0002)A\u0007\u0003\u001fAq!a\r\u0010\t\u0003\t)\u0004C\u0004\u0002B=!I!a\u0011\t\u000f\u0005Es\u0002\"\u0001\u0002T!9\u0011QL\b\u0005\u0002\u0005}#\u0001E\"p[B\u0014Xm]:j_:$\u0016M\u00197f\u0015\tYB$\u0001\u0005d_6\u0004(/Z:t\u0015\tib$\u0001\u0004beR,'/\u001f\u0006\u0003?\u0001\naA]3n_R,'\"A\u0011\u0002\t\u0005\\7.Y\u000b\u0003G\u0015\u001b\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003%y'/[4j]VKGm\u0001\u0001\u0016\u00035\u0002\"!\n\u0018\n\u0005=2#\u0001\u0002'p]\u001e\f!b\u001c:jO&tW+\u001b3!\u0003\u001d1XM]:j_:,\u0012a\r\t\u0003KQJ!!\u000e\u0014\u0003\t\tKH/Z\u0001\tm\u0016\u00148/[8oA\u0005Yq\fZ5di&|g.\u0019:z+\u0005I\u0004c\u0001\u001eB\u00076\t1H\u0003\u0002={\u0005Y1m\u001c7mK\u000e$\u0018n\u001c8t\u0015\tqt(\u0001\u0004bOJ|g.\u0019\u0006\u0002\u0001\u0006\u0019qN]4\n\u0005\t[$!E(cU\u0016\u001cGOM%oi\"\u000b7\u000f['baB\u0011A)\u0012\u0007\u0001\t\u00151\u0005A1\u0001H\u0005\u0005!\u0016C\u0001%L!\t)\u0013*\u0003\u0002KM\t9aj\u001c;iS:<\u0007CA\u0013M\u0013\tieEA\u0002B]f\fAb\u00183jGRLwN\\1ss\u0002\na\u0001P5oSRtD\u0003B)T)V\u00032A\u0015\u0001D\u001b\u0005Q\u0002\"\u0002\u0016\b\u0001\u0004i\u0003\"B\u0019\b\u0001\u0004\u0019\u0004\"B\u001c\b\u0001\u0004I\u0014A\u00033jGRLwN\\1ssV\t\u0001\f\u0005\u0003ZA\u000e\u001bgB\u0001._!\tYf%D\u0001]\u0015\ti6&\u0001\u0004=e>|GOP\u0005\u0003?\u001a\na\u0001\u0015:fI\u00164\u0017BA1c\u0005\ri\u0015\r\u001d\u0006\u0003?\u001a\u0002\"!\n3\n\u0005\u00154#aA%oiR\u00111m\u001a\u0005\u0006Q&\u0001\raQ\u0001\u0006m\u0006dW/Z\u0001\u0007S:4XM\u001d;\u0016\u0003-\u00042A\u00157D\u0013\ti'D\u0001\nEK\u000e|W\u000e\u001d:fgNLwN\u001c+bE2,\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003A\u0004\"!W9\n\u0005I\u0014'AB*ue&tw-\u0001\u0005iCND7i\u001c3f)\u0005\u0019\u0017AB3rk\u0006d7\u000f\u0006\u0002xuB\u0011Q\u0005_\u0005\u0003s\u001a\u0012qAQ8pY\u0016\fg\u000eC\u0003|\u001b\u0001\u00071*A\u0002pE*\f\u0001cQ8naJ,7o]5p]R\u000b'\r\\3\u0011\u0005I{1CA\b%)\u0005i\u0018a\u0004(pi\u000e{W\u000e\u001d:fgN,G-\u00133\u0016\u0005\u0005\u0015qBAA\u0004;\u0005y \u0001\u0005(pi\u000e{W\u000e\u001d:fgN,G-\u00133!\u0003E\u0019u.\u001c9be\u0016\u0014\u0015P\r8e-\u0006dW/Z\u000b\u0003\u0003\u001f\u0001b!!\u0005\u0002\u001c\u0005}QBAA\n\u0015\u0011\t)\"a\u0006\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005)\u0019u.\u001c9be\u0006$xN\u001d\t\u0007K\u0005\u0005\u0012QE2\n\u0007\u0005\rbE\u0001\u0004UkBdWM\r\t\u0005\u0003O\ti#\u0004\u0002\u0002*)!\u00111FA\f\u0003\u0011a\u0017M\\4\n\t\u0005=\u0012\u0011\u0006\u0002\u0007\u001f\nTWm\u0019;\u0002%\r{W\u000e]1sK\nK(G\u001c3WC2,X\rI\u0001\u0012G>l\u0007/\u0019:f\u0005f\u0014d\u000e\u001a,bYV,W\u0003BA\u001c\u0003\u007f)\"!!\u000f\u0011\r\u0005E\u00111DA\u001e!\u0019)\u0013\u0011EA\u001fGB\u0019A)a\u0010\u0005\u000b\u0019+\"\u0019A$\u0002)9,wo\u00142kK\u000e$('\u00138u\u0011\u0006\u001c\b.T1q+\u0011\t)%a\u0013\u0015\t\u0005\u001d\u0013Q\n\t\u0005u\u0005\u000bI\u0005E\u0002E\u0003\u0017\"QA\u0012\fC\u0002\u001dCa!a\u0014\u0017\u0001\u0004\u0019\u0017aD5oSRL\u0017\r\\\"ba\u0006\u001c\u0017\u000e^=\u0002\u000b\u0015l\u0007\u000f^=\u0016\t\u0005U\u00131L\u000b\u0003\u0003/\u0002BA\u0015\u0001\u0002ZA\u0019A)a\u0017\u0005\u000b\u0019;\"\u0019A$\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\t\u0005\u0005\u0014q\r\u000b\t\u0003G\nI'a\u001b\u0002nA!!\u000bAA3!\r!\u0015q\r\u0003\u0006\rb\u0011\ra\u0012\u0005\u0006Ua\u0001\r!\f\u0005\u0006ca\u0001\ra\r\u0005\u0007-b\u0001\r!a\u001c\u0011\u000be\u0003\u0017QM2")
public final class CompressionTable<T> {
    private final long originUid;
    private final byte version;
    private final Object2IntHashMap<T> _dictionary;

    public static <T> CompressionTable<T> apply(long l, byte by, Map<T, Object> map) {
        return CompressionTable$.MODULE$.apply(l, by, map);
    }

    public static <T> CompressionTable<T> empty() {
        return CompressionTable$.MODULE$.empty();
    }

    public static <T> Comparator<Tuple2<T, Object>> compareBy2ndValue() {
        return CompressionTable$.MODULE$.compareBy2ndValue();
    }

    public static Comparator<Tuple2<Object, Object>> CompareBy2ndValue() {
        return CompressionTable$.MODULE$.CompareBy2ndValue();
    }

    public static int NotCompressedId() {
        return CompressionTable$.MODULE$.NotCompressedId();
    }

    public long originUid() {
        return this.originUid;
    }

    public byte version() {
        return this.version;
    }

    private Object2IntHashMap<T> _dictionary() {
        return this._dictionary;
    }

    public Map<T, Object> dictionary() {
        return package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().entrySet().iterator()).asScala().map((Function1<Map.Entry, Tuple2> & Serializable & scala.Serializable)entry -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), BoxesRunTime.boxToInteger((Integer)entry.getValue()))).toMap(Predef$.MODULE$.$conforms());
    }

    public int compress(T value) {
        return this._dictionary().getValue(value);
    }

    public DecompressionTable<T> invert() {
        int i;
        if (this._dictionary().isEmpty()) {
            DecompressionTable qual$1 = DecompressionTable$.MODULE$.empty();
            long x$12 = this.originUid();
            byte x$2 = this.version();
            Object x$3 = qual$1.copy$default$3();
            return qual$1.copy(x$12, x$2, x$3);
        }
        Integer expectedGaplessSum = this._dictionary().size() * (this._dictionary().size() + 1) / 2;
        Predef$.MODULE$.require(BoxesRunTime.equals(((TraversableOnce)package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala()).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), BoxesRunTime.boxToInteger(0)), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Compression table should start allocating from 0, yet lowest allocated id was ").append(((TraversableOnce)package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala()).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).toString());
        Predef$.MODULE$.require(BoxesRunTime.equals(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(package$JavaConverters$.MODULE$.asScalaIteratorConverter(this._dictionary().values().iterator()).asScala().map((Function1<Integer, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1)).sum(Numeric$IntIsIntegral$.MODULE$)) + this._dictionary().size()), expectedGaplessSum), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(149).append("Given compression map does not seem to be gap-less and starting from zero, which makes compressing it into an Array difficult, bailing out! Map was: ").append(this._dictionary()).toString());
        Tuple2[] tups = new Tuple2[this._dictionary().size()];
        Object[] ts = new Object[this._dictionary().size()];
        Object2IntHashMap.EntryIterator mit = this._dictionary().entrySet().iterator();
        for (i = 0; i < tups.length; ++i) {
            Object entry = mit.next();
            tups[i] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(entry.getKey()), BoxesRunTime.boxToInteger((Integer)entry.getValue()));
        }
        Arrays.sort((Object[])tups, CompressionTable$.MODULE$.compareBy2ndValue());
        for (i = 0; i < tups.length; ++i) {
            ScalaRunTime$.MODULE$.array_update(ts, i, tups[i]._1());
        }
        return new DecompressionTable(this.originUid(), this.version(), ts);
    }

    public String toString() {
        return new StringBuilder(20).append("CompressionTable(").append(this.originUid()).append(",").append(this.version()).append(",").append(this.dictionary()).append(")").toString();
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.originUid());
        result = HashCode$.MODULE$.hash(result, this.version());
        result = HashCode$.MODULE$.hash(result, this._dictionary());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof CompressionTable)) return false;
        CompressionTable compressionTable = (CompressionTable)object;
        if (this.originUid() != compressionTable.originUid()) return false;
        if (this.version() != compressionTable.version()) return false;
        Object2IntHashMap<T> object2IntHashMap = this._dictionary();
        Object2IntHashMap<T> object2IntHashMap2 = compressionTable._dictionary();
        if (object2IntHashMap != null) {
            if (!((Object)object2IntHashMap).equals(object2IntHashMap2)) return false;
            return true;
        }
        if (object2IntHashMap2 == null) return true;
        return false;
    }

    public CompressionTable(long originUid, byte version, Object2IntHashMap<T> _dictionary) {
        this.originUid = originUid;
        this.version = version;
        this._dictionary = _dictionary;
    }
}

