/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery;

import akka.remote.artery.CacheStatistics;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcII$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015cA\u0002\r\u001a\u0003\u0003ir\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003*\u0011!a\u0003A!A!\u0002\u0013I\u0003\u0002C\u0017\u0001\u0005\u0007\u0005\u000b1\u0002\u0018\t\u0011q\u0002!1!Q\u0001\fuBQ!\u0011\u0001\u0005\u0002\tCaA\u0013\u0001!\u0002\u0013I\u0003BB&\u0001A\u0003&\u0011\u0006\u0003\u0004M\u0001\u0001\u0006I!\u0014\u0005\u0007!\u0002\u0001\u000b\u0011B)\t\rI\u0003\u0001\u0015!\u0003T\u0011\u0019!\u0006\u0001)A\u0005'\")Q\u000b\u0001C\u0003-\")A\f\u0001C\u0003;\")\u0011\r\u0001C\u0003E\")A\r\u0001C\u0005K\")!\u000f\u0001C\u0005g\")!\u000f\u0001C\tm\")1\u0010\u0001C\u0005y\"9\u0011\u0011\u0003\u0001\u0007\u0012\u0005M\u0001bBA\f\u0001\u0019E\u0011\u0011\u0004\u0005\b\u0003;\u0001a\u0011CA\u0010\u0011\u001d\tI\u0003\u0001D\t\u0003WAq!!\r\u0001\t\u0003\n\u0019DA\bMeV\u0014u.\u001e8eK\u0012\u001c\u0015m\u00195f\u0015\tQ2$\u0001\u0004beR,'/\u001f\u0006\u00039u\taA]3n_R,'\"\u0001\u0010\u0002\t\u0005\\7.Y\u000b\u0004AYz4C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u0006A1-\u00199bG&$\u0018p\u0001\u0001\u0011\u0005\tR\u0013BA\u0016$\u0005\rIe\u000e^\u0001\u0012KZL7\r^!hKRC'/Z:i_2$\u0017AC3wS\u0012,gnY3%cA\u0019qF\r\u001b\u000e\u0003AR!!M\u0012\u0002\u000fI,g\r\\3di&\u00111\u0007\r\u0002\t\u00072\f7o\u001d+bOB\u0011QG\u000e\u0007\u0001\t\u00159\u0004A1\u00019\u0005\u0005Y\u0015CA\u001d\"!\t\u0011#(\u0003\u0002<G\t9aj\u001c;iS:<\u0017AC3wS\u0012,gnY3%eA\u0019qF\r \u0011\u0005UzD!\u0002!\u0001\u0005\u0004A$!\u0001,\u0002\rqJg.\u001b;?)\r\u0019\u0005*\u0013\u000b\u0004\t\u001a;\u0005\u0003B#\u0001iyj\u0011!\u0007\u0005\u0006[\u0015\u0001\u001dA\f\u0005\u0006y\u0015\u0001\u001d!\u0010\u0005\u0006O\u0015\u0001\r!\u000b\u0005\u0006Y\u0015\u0001\r!K\u0001\u0005\u001b\u0006\u001c8.A\u0003fa>\u001c\u0007.\u0001\u0003lKf\u001c\bc\u0001\u0012Oi%\u0011qj\t\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0007m\u0006dW/Z:\u0011\u0007\tre(\u0001\u0004iCNDWm\u001d\t\u0004E9K\u0013AB3q_\u000eD7/A\u0002hKR$\"a\u0016.\u0011\u0007\tBf(\u0003\u0002ZG\t1q\n\u001d;j_:DQa\u0017\u0007A\u0002Q\n\u0011a[\u0001\u0006gR\fGo]\u000b\u0002=B\u0011QiX\u0005\u0003Af\u0011qbQ1dQ\u0016\u001cF/\u0019;jgRL7m]\u0001\rO\u0016$xJ]\"p[B,H/\u001a\u000b\u0003}\rDQa\u0017\bA\u0002Q\n\u0001B]3n_Z,\u0017\t\u001e\u000b\u0003M&\u0004\"AI4\n\u0005!\u001c#\u0001B+oSRDQA[\bA\u0002%\n\u0001\u0002]8tSRLwN\u001c\u0015\u0003\u001f1\u0004\"!\u001c9\u000e\u00039T!a\\\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002r]\n9A/Y5me\u0016\u001c\u0017a\u00049s_\n,G)[:uC:\u001cWm\u00144\u0015\u0005%\"\b\"B;\u0011\u0001\u0004I\u0013\u0001B:m_R$2!K<z\u0011\u0015A\u0018\u00031\u0001*\u0003%IG-Z1m'2|G\u000fC\u0003{#\u0001\u0007\u0011&\u0001\u0006bGR,\u0018\r\\*m_R\fA!\\8wKRQa- @\u0000\u0003\u0007\t9!a\u0003\t\u000b)\u0014\u0002\u0019A\u0015\t\u000bm\u0013\u0002\u0019\u0001\u001b\t\r\u0005\u0005!\u00031\u0001*\u0003\u0005A\u0007BBA\u0003%\u0001\u0007a(A\u0003wC2,X\r\u0003\u0004\u0002\nI\u0001\r!K\u0001\nK2,W.\u00129pG\"Da!!\u0004\u0013\u0001\u0004I\u0013!\u00049s_\n,G)[:uC:\u001cW\r\u000b\u0002\u0013Y\u000691m\\7qkR,Gc\u0001 \u0002\u0016!)1l\u0005a\u0001i\u0005!\u0001.Y:i)\rI\u00131\u0004\u0005\u00067R\u0001\r\u0001N\u0001\u000fSN\\U-_\"bG\",\u0017M\u00197f)\u0011\t\t#a\n\u0011\u0007\t\n\u0019#C\u0002\u0002&\r\u0012qAQ8pY\u0016\fg\u000eC\u0003\\+\u0001\u0007A'A\u0006jg\u000e\u000b7\r[3bE2,G\u0003BA\u0011\u0003[Aa!a\f\u0017\u0001\u0004q\u0014!\u0001<\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000e\u0011\t\u0005]\u0012\u0011I\u0007\u0003\u0003sQA!a\u000f\u0002>\u0005!A.\u00198h\u0015\t\ty$\u0001\u0003kCZ\f\u0017\u0002BA\"\u0003s\u0011aa\u0015;sS:<\u0007")
public abstract class LruBoundedCache<K, V> {
    private final int capacity;
    private final int evictAgeThreshold;
    private final int Mask;
    private int epoch;
    private final K[] keys;
    private final V[] values;
    private final int[] hashes;
    private final int[] epochs;

    public final Option<V> get(K k) {
        int h = this.hash(k);
        return this.find$1(h & this.Mask, 0, h, k);
    }

    public final CacheStatistics stats() {
        int sum = 0;
        int count = 0;
        int max = 0;
        for (int i = 0; i < this.hashes.length; ++i) {
            if (this.values[i] == null) continue;
            int dist = this.probeDistanceOf(i);
            sum += dist;
            ++count;
            max = package$.MODULE$.max(dist, max);
        }
        return new CacheStatistics(count, max, (double)sum / (double)count);
    }

    public final V getOrCompute(K k) {
        if (!this.isKeyCacheable(k)) {
            return this.compute(k);
        }
        int h = this.hash(k);
        ++this.epoch;
        return (V)this.findOrCalculate$1(h & this.Mask, 0, k, h);
    }

    private void removeAt(int position) {
        while (true) {
            int next;
            if (this.values[next = position + 1 & this.Mask] == null || this.probeDistanceOf(next) == 0) break;
            this.keys[position] = this.keys[next];
            this.values[position] = this.values[next];
            this.hashes[position] = this.hashes[next];
            this.epochs[position] = this.epochs[next];
            position = next;
        }
        this.values[position] = null;
    }

    private int probeDistanceOf(int slot) {
        return this.probeDistanceOf(this.hashes[slot] & this.Mask, slot);
    }

    public int probeDistanceOf(int idealSlot, int actualSlot) {
        return actualSlot - idealSlot + this.capacity & this.Mask;
    }

    private void move(int position, K k, int h, V value, int elemEpoch, int probeDistance) {
        while (true) {
            if (this.values[position] == null) break;
            int otherEpoch = this.epochs[position];
            if (this.epoch - otherEpoch >= this.evictAgeThreshold) {
                this.removeAt(position);
                int n = h & this.Mask;
                probeDistance = 0;
                position = n;
                continue;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            int otherEpoch2 = this.epochs[position];
            if (probeDistance > otherProbeDistance) {
                K otherKey = this.keys[position];
                V otherValue = this.values[position];
                int otherHash = this.hashes[position];
                this.keys[position] = k;
                this.values[position] = value;
                this.hashes[position] = h;
                this.epochs[position] = elemEpoch;
                probeDistance = otherProbeDistance + 1;
                elemEpoch = otherEpoch2;
                value = otherValue;
                h = otherHash;
                k = otherKey;
                position = position + 1 & this.Mask;
                continue;
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
        this.keys[position] = k;
        this.values[position] = value;
        this.hashes[position] = h;
        this.epochs[position] = elemEpoch;
    }

    public abstract V compute(K var1);

    public abstract int hash(K var1);

    public abstract boolean isKeyCacheable(K var1);

    public abstract boolean isCacheable(V var1);

    public String toString() {
        return new StringBuilder(65).append("LruBoundedCache(").append(" values = ").append(new ArrayOps.ofRef<V>(Predef$.MODULE$.refArrayOps(this.values)).mkString("[", ",", "]")).append(",").append(" hashes = ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.hashes)).map((JFunction1$mcII$sp & Serializable)x$1 -> x$1 & $this.Mask, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).mkString("[", ",", "]")).append(",").append(" epochs = ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.epochs)).mkString("[", ",", "]")).append(",").append(" distances = ").append(((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.hashes)).indices().map((JFunction1$mcII$sp & Serializable)slot -> this.probeDistanceOf(slot), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ",", "]")).append(",").append(" ").append(this.epoch).append(")").toString();
    }

    private final Option find$1(int position, int probeDistance, int h$1, Object k$1) {
        while (true) {
            int otherProbeDistance = this.probeDistanceOf(position);
            if (this.values[position] == null) {
                return None$.MODULE$;
            }
            if (probeDistance > otherProbeDistance) {
                return None$.MODULE$;
            }
            if (this.hashes[position] == h$1 && BoxesRunTime.equals(k$1, this.keys[position])) {
                return new Some<V>(this.values[position]);
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
    }

    private final Object findOrCalculate$1(int position, int probeDistance, Object k$2, int h$2) {
        while (true) {
            if (this.values[position] == null) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.keys[position] = k$2;
                    this.values[position] = value;
                    this.hashes[position] = h$2;
                    this.epochs[position] = this.epoch;
                }
                return value;
            }
            int otherProbeDistance = this.probeDistanceOf(position);
            if (probeDistance > otherProbeDistance) {
                V value = this.compute(k$2);
                if (this.isCacheable(value)) {
                    this.move(position, k$2, h$2, value, this.epoch, probeDistance);
                }
                return value;
            }
            if (this.hashes[position] == h$2 && BoxesRunTime.equals(k$2, this.keys[position])) {
                this.epochs[position] = this.epoch;
                return this.values[position];
            }
            ++probeDistance;
            position = position + 1 & this.Mask;
        }
    }

    public LruBoundedCache(int capacity, int evictAgeThreshold, ClassTag<K> evidence$1, ClassTag<V> evidence$2) {
        this.capacity = capacity;
        this.evictAgeThreshold = evictAgeThreshold;
        Predef$.MODULE$.require(capacity > 0, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Capacity must be larger than zero");
        Predef$.MODULE$.require((capacity & capacity - 1) == 0, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Capacity must be power of two");
        Predef$.MODULE$.require(evictAgeThreshold <= capacity, (Function0<Object>)(Function0<String> & java.io.Serializable & Serializable)() -> "Age threshold must be less than capacity.");
        this.Mask = capacity - 1;
        this.epoch = 0x7FFFFFFE;
        this.keys = (Object[])Array$.MODULE$.ofDim(capacity, evidence$1);
        this.values = (Object[])Array$.MODULE$.ofDim(capacity, evidence$2);
        this.hashes = new int[capacity];
        this.epochs = (int[])Array$.MODULE$.fill(capacity, (JFunction0$mcI$sp & Serializable)() -> $this.epoch - $this.evictAgeThreshold, ClassTag$.MODULE$.Int());
    }
}

