/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.Logging$Warning$;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.remote.RemoteLogMarker$;
import akka.util.Helpers$;
import akka.util.Helpers$ConfigOps$;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001\u0002\u001e<\u0001\u0001C\u0001b\u0013\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003T\u0011!9\u0006A!b\u0001\n\u0003A\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011\t\u0004!Q1A\u0005\u0002aC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tI\u0002\u0011)\u0019!C\u00011\"AQ\r\u0001B\u0001B\u0003%\u0011\f\u0003\u0005g\u0001\t\u0005\t\u0015!\u0003h\u0011!\u0001\bA!A!\u0002\u0017\t\bBB@\u0001\t\u0003\t\t\u0001\u0003\u0004\u0000\u0001\u0011\u0005\u0011Q\u0003\u0005\u0007\u007f\u0002!\t!!\n\t\u0013\u0005\u0005\u0003A1A\u0005\n\u0005\r\u0003\u0002CA&\u0001\u0001\u0006I!!\u0012\t\u0013\u00055\u0003A1A\u0005\n\u0005=\u0003\u0002CA,\u0001\u0001\u0006I!!\u0015\t\u0015\u0005e\u0003\u00011A\u0005\u0002u\nY\u0006\u0003\u0006\u0002n\u0001\u0001\r\u0011\"\u0001>\u0003_B\u0001\"a\u001f\u0001A\u0003&\u0011Q\f\u0004\u0007\u0003{\u0002A)a \t\u0015\u00055uC!f\u0001\n\u0003\t\u0019\u0005\u0003\u0006\u0002\u0010^\u0011\t\u0012)A\u0005\u0003\u000bB!\"!%\u0018\u0005+\u0007I\u0011AAJ\u0011)\t9j\u0006B\tB\u0003%\u0011Q\u0013\u0005\u0007\u007f^!\t!!'\t\u0013\u0005\rv#!A\u0005\u0002\u0005\u0015\u0006\"CAV/E\u0005I\u0011AAW\u0011%\t\u0019mFI\u0001\n\u0003\t)\rC\u0005\u0002J^\t\t\u0011\"\u0011\u0002L\"A\u00111\\\f\u0002\u0002\u0013\u0005!\u000bC\u0005\u0002^^\t\t\u0011\"\u0001\u0002`\"I\u0011\u0011^\f\u0002\u0002\u0013\u0005\u00131\u001e\u0005\n\u0003s<\u0012\u0011!C\u0001\u0003wD\u0011B!\u0002\u0018\u0003\u0003%\tEa\u0002\t\u0013\t%q#!A\u0005B\t-\u0001\"\u0003B\u0007/\u0005\u0005I\u0011\tB\b\u000f%\u0011\u0019\u0002AA\u0001\u0012\u0013\u0011)BB\u0005\u0002~\u0001\t\t\u0011#\u0003\u0003\u0018!1q0\u000bC\u0001\u0005KA\u0011B!\u0003*\u0003\u0003%)Ea\u0003\t\u0013\t\u001d\u0012&!A\u0005\u0002\n%\u0002\"\u0003B\u0018S\u0005\u0005I\u0011\u0011B\u0019\u0011%\u0011y\u0004\u0001b\u0001\n\u0013\u0011\t\u0005\u0003\u0005\u0003V\u0001\u0001\u000b\u0011\u0002B\"\u0011\u001d\u00119\u0006\u0001C!\u00053BqAa\u0016\u0001\t\u0013\u0011Y\u0006C\u0004\u0003`\u0001!\tE!\u0017\t\u000f\t\u0005\u0004\u0001\"\u0012\u0003d!1!q\u000e\u0001\u0005\u00021CqAa\u001c\u0001\t\u0013\u0011\t\b\u0003\u0005\u0003p\u0001!\t!\u0010B;\u0011!\u0011\u0019\t\u0001b\u0001\n\u0013a\u0005b\u0002BC\u0001\u0001\u0006I!\u0014\u0005\b\u0005\u000f\u0003A\u0011\u0002BE\u0005e\u0001\u0006.[!dGJ,\u0018\r\u001c$bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u000b\u0005qj\u0014A\u0002:f[>$XMC\u0001?\u0003\u0011\t7n[1\u0004\u0001M\u0019\u0001!Q$\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\r\u0005s\u0017PU3g!\tA\u0015*D\u0001<\u0013\tQ5HA\bGC&dWO]3EKR,7\r^8s\u0003%!\bN]3tQ>dG-F\u0001N!\t\u0011e*\u0003\u0002P\u0007\n1Ai\\;cY\u0016\f!\u0002\u001e5sKNDw\u000e\u001c3!\u00035i\u0017\r_*b[BdWmU5{KV\t1\u000b\u0005\u0002C)&\u0011Qk\u0011\u0002\u0004\u0013:$\u0018AD7bqN\u000bW\u000e\u001d7f'&TX\rI\u0001\u0010[&t7\u000b\u001e3EKZL\u0017\r^5p]V\t\u0011\f\u0005\u0002[?6\t1L\u0003\u0002];\u0006AA-\u001e:bi&|gN\u0003\u0002_\u0007\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0001\\&A\u0004$j]&$X\rR;sCRLwN\\\u0001\u0011[&t7\u000b\u001e3EKZL\u0017\r^5p]\u0002\n\u0001$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:f\u0003e\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/\u001a\u0011\u0002-\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\fqCZ5sgRDU-\u0019:uE\u0016\fG/R:uS6\fG/\u001a\u0011\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u0004\u0005\"T\u0017BA5D\u0005\u0019y\u0005\u000f^5p]B\u00111N\\\u0007\u0002Y*\u0011Q.P\u0001\u0006KZ,g\u000e^\u0005\u0003_2\u00141\"\u0012<f]R\u001cFO]3b[\u0006)1\r\\8dWB\u0011!\u000f \b\u0003gjt!\u0001^=\u000f\u0005UDX\"\u0001<\u000b\u0005]|\u0014A\u0002\u001fs_>$h(C\u0001?\u0013\taT(\u0003\u0002|w\u0005ya)Y5mkJ,G)\u001a;fGR|'/\u0003\u0002~}\n)1\t\\8dW*\u00111pO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005\r\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014Q!\u0011QAA\u0004!\tA\u0005\u0001C\u0003q\u001b\u0001\u000f\u0011\u000fC\u0003L\u001b\u0001\u0007Q\nC\u0003R\u001b\u0001\u00071\u000bC\u0003X\u001b\u0001\u0007\u0011\fC\u0003c\u001b\u0001\u0007\u0011\fC\u0003e\u001b\u0001\u0007\u0011\fC\u0003g\u001b\u0001\u0007q\r\u0006\u0007\u0002\u0018\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003\u0006\u0003\u0002\u0006\u0005e\u0001\"\u00029\u000f\u0001\b\t\b\"B&\u000f\u0001\u0004i\u0005\"B)\u000f\u0001\u0004\u0019\u0006\"B,\u000f\u0001\u0004I\u0006\"\u00022\u000f\u0001\u0004I\u0006\"\u00023\u000f\u0001\u0004IFCBA\u0003\u0003O\ti\u0004C\u0004\u0002*=\u0001\r!a\u000b\u0002\r\r|gNZ5h!\u0011\ti#!\u000f\u000e\u0005\u0005=\"\u0002BA\u0015\u0003cQA!a\r\u00026\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u00028\u0005\u00191m\\7\n\t\u0005m\u0012q\u0006\u0002\u0007\u0007>tg-[4\t\r\u0005}r\u00021\u0001k\u0003\t)g/\u0001\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0016\u0005\u0005\u0015\u0003c\u0001%\u0002H%\u0019\u0011\u0011J\u001e\u0003!!+\u0017M\u001d;cK\u0006$\b*[:u_JL\u0018a\u00044jeN$\b*Z1si\n,\u0017\r\u001e\u0011\u0002=\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001cXCAA)!\r\u0011\u00151K\u0005\u0004\u0003+\u001a%\u0001\u0002'p]\u001e\fq$Y2dKB$\u0018M\u00197f\u0011\u0016\f'\u000f\u001e2fCR\u0004\u0016-^:f\u001b&dG.[:!\u0003\u001d\tG\r\u001a:fgN,\"!!\u0018\u0011\t\u0005}\u0013q\r\b\u0005\u0003C\n\u0019\u0007\u0005\u0002v\u0007&\u0019\u0011QM\"\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)gQ\u0001\fC\u0012$'/Z:t?\u0012*\u0017\u000f\u0006\u0003\u0002r\u0005]\u0004c\u0001\"\u0002t%\u0019\u0011QO\"\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003s*\u0012\u0011!a\u0001\u0003;\n1\u0001\u001f\u00132\u0003!\tG\r\u001a:fgN\u0004#!B*uCR,7CB\fB\u0003\u0003\u000b9\tE\u0002C\u0003\u0007K1!!\"D\u0005\u001d\u0001&o\u001c3vGR\u00042AQAE\u0013\r\tYi\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bQ&\u001cHo\u001c:z\u0003!A\u0017n\u001d;pef\u0004\u0013!\u0003;j[\u0016\u001cH/Y7q+\t\t)\n\u0005\u0003CQ\u0006E\u0013A\u0003;j[\u0016\u001cH/Y7qAQ1\u00111TAP\u0003C\u00032!!(\u0018\u001b\u0005\u0001\u0001bBAG9\u0001\u0007\u0011Q\t\u0005\b\u0003#c\u0002\u0019AAK\u0003\u0011\u0019w\u000e]=\u0015\r\u0005m\u0015qUAU\u0011%\ti)\bI\u0001\u0002\u0004\t)\u0005C\u0005\u0002\u0012v\u0001\n\u00111\u0001\u0002\u0016\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAXU\u0011\t)%!-,\u0005\u0005M\u0006\u0003BA[\u0003\u007fk!!a.\u000b\t\u0005e\u00161X\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!0D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\f9LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002H*\"\u0011QSAY\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0017\u0001\u00026bm\u0006LA!!\u001b\u0002R\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAq\u0003O\u00042AQAr\u0013\r\t)o\u0011\u0002\u0004\u0003:L\b\u0002CA=E\u0005\u0005\t\u0019A*\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!<\u0011\r\u0005=\u0018Q_Aq\u001b\t\t\tPC\u0002\u0002t\u000e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t90!=\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003{\u0014\u0019\u0001E\u0002C\u0003\u007fL1A!\u0001D\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u001f%\u0003\u0003\u0005\r!!9\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012aU\u0001\ti>\u001cFO]5oOR\u0011\u0011QZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005u(\u0011\u0003\u0005\n\u0003s:\u0013\u0011!a\u0001\u0003C\fQa\u0015;bi\u0016\u00042!!(*'\u0015I#\u0011DAD!)\u0011YB!\t\u0002F\u0005U\u00151T\u0007\u0003\u0005;Q1Aa\bD\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\t\u0003\u001e\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\tU\u0011!B1qa2LHCBAN\u0005W\u0011i\u0003C\u0004\u0002\u000e2\u0002\r!!\u0012\t\u000f\u0005EE\u00061\u0001\u0002\u0016\u00069QO\\1qa2LH\u0003\u0002B\u001a\u0005w\u0001BA\u00115\u00036A9!Ia\u000e\u0002F\u0005U\u0015b\u0001B\u001d\u0007\n1A+\u001e9mKJB\u0011B!\u0010.\u0003\u0003\u0005\r!a'\u0002\u0007a$\u0003'A\u0003ti\u0006$X-\u0006\u0002\u0003DA1!Q\tB)\u00037k!Aa\u0012\u000b\t\t%#1J\u0001\u0007CR|W.[2\u000b\u0007y\u0013iE\u0003\u0003\u0003P\u0005U\u0017\u0001B;uS2LAAa\u0015\u0003H\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW-\u0001\u0004ti\u0006$X\rI\u0001\fSN\fe/Y5mC\ndW-\u0006\u0002\u0002~R!\u0011Q B/\u0011\u001d\t\t*\ra\u0001\u0003#\nA\"[:N_:LGo\u001c:j]\u001e\f\u0011\u0002[3beR\u0014W-\u0019;\u0015\u0005\u0005E\u0004fA\u001a\u0003hA!!\u0011\u000eB6\u001b\t\tY,\u0003\u0003\u0003n\u0005m&a\u0002;bS2\u0014XmY\u0001\u0004a\"LGcA'\u0003t!9\u0011\u0011S\u001bA\u0002\u0005ECcB'\u0003x\tm$q\u0010\u0005\b\u0005s2\u0004\u0019AA)\u0003!!\u0018.\\3ES\u001a4\u0007B\u0002B?m\u0001\u0007Q*\u0001\u0003nK\u0006t\u0007B\u0002BAm\u0001\u0007Q*\u0001\u0007ti\u0012$UM^5bi&|g.A\u000bnS:\u001cF\u000f\u001a#fm&\fG/[8o\u001b&dG.[:\u0002-5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\u0002\nq#\u001a8tkJ,g+\u00197jIN#H\rR3wS\u0006$\u0018n\u001c8\u0015\u00075\u0013Y\t\u0003\u0004\u0003\u0002f\u0002\r!\u0014")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private volatile PhiAccrualFailureDetector$State$ State$module;
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final double minStdDeviationMillis;

    private PhiAccrualFailureDetector$State$ State() {
        if (this.State$module == null) {
            this.State$lzycompute$1();
        }
        return this.State$module;
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        State newState;
        State oldState;
        do {
            HeartbeatHistory heartbeatHistory;
            long timestamp = this.clock.apply$mcJ$sp();
            oldState = this.state().get();
            Option<Object> option = oldState.timestamp();
            if (None$.MODULE$.equals(option)) {
                heartbeatHistory = this.firstHeartbeat();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                long latestTimestamp = BoxesRunTime.unboxToLong(some.value());
                long interval = timestamp - latestTimestamp;
                if (this.isAvailable(timestamp)) {
                    if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                        ((SubchannelClassification)this.eventStream.get()).publish(Logging$Warning$.MODULE$.apply(this.toString(), this.getClass(), new StringBuilder(61).append("heartbeat interval is growing too large for address ").append(this.address()).append(": ").append(interval).append(" millis").toString(), Logging$.MODULE$.emptyMDC(), RemoteLogMarker$.MODULE$.failureDetectorGrowing(this.address())));
                    }
                    heartbeatHistory = oldState.history().$colon$plus(interval);
                } else {
                    heartbeatHistory = oldState.history();
                }
            } else {
                throw new MatchError(option);
            }
            HeartbeatHistory newHistory = heartbeatHistory;
            newState = oldState.copy(newHistory, new Some<Object>(BoxesRunTime.boxToLong(timestamp)));
        } while (!this.state().compareAndSet(oldState, newState));
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            return 0.0;
        }
        long timeDiff = timestamp - BoxesRunTime.unboxToLong(oldTimestamp.get());
        HeartbeatHistory history = oldState.history();
        double mean = history.mean();
        double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
        return this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        if ((double)timeDiff > mean) {
            return -package$.MODULE$.log10(e / (1.0 + e));
        }
        return -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private double minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, this.minStdDeviationMillis());
    }

    private final void State$lzycompute$1() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.State$module == null) {
                this.State$module = new PhiAccrualFailureDetector$State$(this);
            }
        }
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.threshold must be > 0");
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.max-sample-size must be > 0");
        Predef$.MODULE$.require(minStdDeviation.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.min-std-deviation must be > 0");
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.acceptable-heartbeat-pause must be >= 0");
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater(Duration$.MODULE$.Zero()), (Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> "failure-detector.heartbeat-interval must be > 0");
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(new State(this, this.firstHeartbeat(), None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), new Some<EventStream>(ev), FailureDetector$.MODULE$.defaultClock());
    }

    private class State
    implements Product,
    scala.Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        public final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.akka$remote$PhiAccrualFailureDetector$State$$$outer(), history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.history();
                }
                case 1: {
                    return this.timestamp();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            if (((State)object).akka$remote$PhiAccrualFailureDetector$State$$$outer() != this.akka$remote$PhiAccrualFailureDetector$State$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ PhiAccrualFailureDetector akka$remote$PhiAccrualFailureDetector$State$$$outer() {
            return this.$outer;
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$(this);
        }
    }
}

