/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.Address;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.remote.AssociationErrorEvent;
import akka.remote.AssociationEvent;
import akka.remote.DisassociatedEvent;
import akka.remote.EventPublisher;
import akka.remote.RemoteSettings;
import akka.remote.transport.AkkaPduCodec;
import akka.remote.transport.Transport;
import scala.Option;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005aA\u0002\n\u0014\u0003\u0003\u0019r\u0003\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0001*\u0011!i\u0003A!A!\u0002\u0013Q\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0015\t\u0011=\u0002!\u0011!Q\u0001\n)B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\to\u0001\u0011\t\u0011)A\u0005e!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003;\u0011!y\u0004A!b\u0001\n\u0003\u0001\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b\u0015\u0003A\u0011\u0001$\t\u000b5\u0003a\u0011\u0001(\t\u000fI\u0003!\u0019!C\u0001'\"1q\u000b\u0001Q\u0001\nQCQ\u0001\u0017\u0001\u0005\u0002eCQa\u001e\u0001\u0005\u0002aDQ!\u001f\u0001\u0005\ni\u0014Q\"\u00128ea>Lg\u000e^!di>\u0014(B\u0001\u000b\u0016\u0003\u0019\u0011X-\\8uK*\ta#\u0001\u0003bW.\f7\u0003\u0002\u0001\u0019=\u0011\u0002\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0016\u0003\u0015\t7\r^8s\u0013\t\u0019\u0003EA\u0003BGR|'\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r\u0003\u000e$xN\u001d'pO\u001eLgnZ\u0001\rY>\u001c\u0017\r\\!eIJ,7o]\u0002\u0001+\u0005Q\u0003CA\u0010,\u0013\ta\u0003EA\u0004BI\u0012\u0014Xm]:\u0002\u001b1|7-\u00197BI\u0012\u0014Xm]:!\u00035\u0011X-\\8uK\u0006#GM]3tg\u0006q!/Z7pi\u0016\fE\r\u001a:fgN\u0004\u0013!\u0003;sC:\u001c\bo\u001c:u+\u0005\u0011\u0004CA\u001a6\u001b\u0005!$B\u0001\u0019\u0014\u0013\t1DGA\u0005Ue\u0006t7\u000f]8si\u0006QAO]1ogB|'\u000f\u001e\u0011\u0002\u0011M,G\u000f^5oON,\u0012A\u000f\t\u0003wqj\u0011aE\u0005\u0003{M\u0011aBU3n_R,7+\u001a;uS:<7/A\u0005tKR$\u0018N\\4tA\u0005)1m\u001c3fGV\t\u0011\t\u0005\u00024\u0005&\u00111\t\u000e\u0002\r\u0003.\\\u0017\r\u00153v\u0007>$WmY\u0001\u0007G>$Wm\u0019\u0011\u0002\rqJg.\u001b;?)\u00199\u0005*\u0013&L\u0019B\u00111\b\u0001\u0005\u0006O-\u0001\rA\u000b\u0005\u0006]-\u0001\rA\u000b\u0005\u0006a-\u0001\rA\r\u0005\u0006q-\u0001\rA\u000f\u0005\u0006\u007f-\u0001\r!Q\u0001\bS:\u0014w.\u001e8e+\u0005y\u0005CA\rQ\u0013\t\t&DA\u0004C_>dW-\u00198\u0002\u001d\u00154XM\u001c;Qk\nd\u0017n\u001d5feV\tA\u000b\u0005\u0002<+&\u0011ak\u0005\u0002\u000f\u000bZ,g\u000e\u001e)vE2L7\u000f[3s\u0003=)g/\u001a8u!V\u0014G.[:iKJ\u0004\u0013\u0001\u00049vE2L7\u000f[#se>\u0014Hc\u0001.^WB\u0011\u0011dW\u0005\u00039j\u0011A!\u00168ji\")al\u0004a\u0001?\u00061!/Z1t_:\u0004\"\u0001\u00195\u000f\u0005\u00054gB\u00012f\u001b\u0005\u0019'B\u00013)\u0003\u0019a$o\\8u}%\t1$\u0003\u0002h5\u00059\u0001/Y2lC\u001e,\u0017BA5k\u0005%!\u0006N]8xC\ndWM\u0003\u0002h5!)An\u0004a\u0001[\u0006AAn\\4MKZ,G\u000e\u0005\u0002oi:\u0011qN]\u0007\u0002a*\u0011\u0011/F\u0001\u0006KZ,g\u000e^\u0005\u0003gB\fq\u0001T8hO&tw-\u0003\u0002vm\nAAj\\4MKZ,GN\u0003\u0002ta\u0006!\u0002/\u001e2mSNDG)[:bgN|7-[1uK\u0012$\u0012AW\u0001\u000biJL\b+\u001e2mSNDGC\u0001.|\u0011\u0015a\u0018\u00031\u0001~\u0003\t)g\u000f\u0005\u0002<}&\u0011qp\u0005\u0002\u0011\u0003N\u001cxnY5bi&|g.\u0012<f]R\u0004")
public abstract class EndpointActor
implements Actor,
ActorLogging {
    private final Address localAddress;
    private final Address remoteAddress;
    private final Transport transport;
    private final RemoteSettings settings;
    private final AkkaPduCodec codec;
    private final EventPublisher eventPublisher;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Address localAddress() {
        return this.localAddress;
    }

    public Address remoteAddress() {
        return this.remoteAddress;
    }

    public Transport transport() {
        return this.transport;
    }

    public RemoteSettings settings() {
        return this.settings;
    }

    public AkkaPduCodec codec() {
        return this.codec;
    }

    public abstract boolean inbound();

    public EventPublisher eventPublisher() {
        return this.eventPublisher;
    }

    public void publishError(Throwable reason, int logLevel) {
        this.tryPublish(new AssociationErrorEvent(reason, this.localAddress(), this.remoteAddress(), this.inbound(), logLevel));
    }

    public void publishDisassociated() {
        this.tryPublish(new DisassociatedEvent(this.localAddress(), this.remoteAddress(), this.inbound()));
    }

    private void tryPublish(AssociationEvent ev) {
        try {
            this.eventPublisher().notifyListeners(ev);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = option.get();
                this.log().error(e, "Unable to publish error event to EventStream.");
            }
            throw throwable;
        }
    }

    public EndpointActor(Address localAddress, Address remoteAddress, Transport transport, RemoteSettings settings, AkkaPduCodec codec) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.transport = transport;
        this.settings = settings;
        this.codec = codec;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.eventPublisher = new EventPublisher(this.context().system(), this.log(), settings.RemoteLifecycleEventsLogLevel());
    }
}

