/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.SimpleDnsCache;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Ip$;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.pattern.package$;
import akka.util.Helpers$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import akka.util.Timeout;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rUa!B\u001e=\u0005\u0001#\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006}\u0002!\ta \u0005\n\u0003\u0017\u0001!\u0019!C\u0002\u0003\u001bA\u0001\"a\u0007\u0001A\u0003%\u0011q\u0002\u0005\n\u0003;\u0001!\u0019!C\u0002\u0003?A\u0001\"!\f\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003_\u0001!\u0019!C\u0001\u0003cAq!a\r\u0001A\u0003%a\rC\u0005\u00026\u0001\u0011\r\u0011\"\u0001\u00028!A\u00111\u000b\u0001!\u0002\u0013\tI\u0004C\u0005\u0002V\u0001\u0011\r\u0011\"\u0001\u00028!A\u0011q\u000b\u0001!\u0002\u0013\tI\u0004C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0003\u0002\\!I\u00111\r\u0001A\u0002\u0013%\u0011Q\r\u0005\t\u0003c\u0002\u0001\u0015)\u0003\u0002^!9\u00111\u000f\u0001\u0005\n\u0005U\u0004\"CA<\u0001\t\u0007I\u0011BA=\u0011\u001d\tY\b\u0001Q\u0001\niDq!! \u0001\t\u0003\ny\bC\u0004\u0002\n\u0002!I!a#\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAz\u0001\u0011%\u0011Q\u001f\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u000f!\u0011I\u0002\u0010E\u0001\u0005\nmaaB\u001e=\u0011\u0003\u0011%Q\u0004\u0005\u0007}r!\tAa\b\t\u0013\t\u0005BD1A\u0005\n\t\r\u0002\u0002\u0003B\u001a9\u0001\u0006IA!\n\t\u0013\tUBD1A\u0005\n\t\r\u0002\u0002\u0003B\u001c9\u0001\u0006IA!\n\t\u0011\teB\u0004\"\u0001C\u0005wA\u0001B!\u0012\u001d\t\u0003\u0011%q\t\u0005\b\u0005\u0017bB\u0011\u0002B'\u0011%\u0011\t\u0006\bb\u0001\n\u0013\u0011\u0019\u0006\u0003\u0005\u0003Vq\u0001\u000b\u0011BAd\r\u0019\u00119\u0006\b!\u0003Z!Q!QN\u0014\u0003\u0016\u0004%\tAa\u001c\t\u0015\tEtE!E!\u0002\u0013\t)\u000b\u0003\u0004\u007fO\u0011\u0005!1\u000f\u0005\n\u0005w:\u0013\u0011!C\u0001\u0005{B\u0011B!!(#\u0003%\tAa!\t\u0013\t]u%!A\u0005B\te\u0005\"\u0003BSO\u0005\u0005I\u0011\u0001BT\u0011%\u0011ykJA\u0001\n\u0003\u0011\t\fC\u0005\u0003<\u001e\n\t\u0011\"\u0011\u0003>\"I!1Z\u0014\u0002\u0002\u0013\u0005!Q\u001a\u0005\n\u0005#<\u0013\u0011!C!\u0005'D\u0011B!6(\u0003\u0003%\tEa6\b\u0013\tmG$!A\t\u0002\tug!\u0003B,9\u0005\u0005\t\u0012\u0001Bp\u0011\u0019qX\u0007\"\u0001\u0003n\"I!q^\u001b\u0002\u0002\u0013\u0015#\u0011\u001f\u0005\n\u0005g,\u0014\u0011!CA\u0005kD\u0011B!?6\u0003\u0003%\tIa?\t\u0013\r\u001dQ'!A\u0005\n\r%!\u0001E!ts:\u001cGI\\:SKN|GN^3s\u0015\tid(\u0001\u0005j]R,'O\\1m\u0015\ty\u0004)A\u0002e]NT!!\u0011\"\u0002\u0005%|'\"A\"\u0002\t\u0005\\7.Y\n\u0005\u0001\u0015[\u0015\u000b\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\n\u000bQ!Y2u_JL!\u0001U'\u0003\u000b\u0005\u001bGo\u001c:\u0011\u00051\u0013\u0016BA*N\u00051\t5\r^8s\u0019><w-\u001b8h\u0003!\u0019X\r\u001e;j]\u001e\u001c8\u0001\u0001\t\u0003/bk\u0011AP\u0005\u00033z\u00121\u0002\u00128t'\u0016$H/\u001b8hg\u0006)1-Y2iKB\u0011A,X\u0007\u0002\u0001&\u0011a\f\u0011\u0002\u000f'&l\u0007\u000f\\3E]N\u001c\u0015m\u00195f\u00035\u0019G.[3oi\u001a\u000b7\r^8ssB)a)Y2gu&\u0011!m\u0012\u0002\n\rVt7\r^5p]J\u0002\"\u0001\u00143\n\u0005\u0015l%aD!di>\u0014(+\u001a4GC\u000e$xN]=\u0011\u0007\u001d|'O\u0004\u0002i[:\u0011\u0011\u000e\\\u0007\u0002U*\u00111.V\u0001\u0007yI|w\u000e\u001e \n\u0003!K!A\\$\u0002\u000fA\f7m[1hK&\u0011\u0001/\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002o\u000fB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\u0004]\u0016$(\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t!\r9wn\u001f\t\u0003\u0019rL!!`'\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fa\u0001P5oSRtD\u0003CA\u0001\u0003\u000b\t9!!\u0003\u0011\u0007\u0005\r\u0001!D\u0001=\u0011\u0015!F\u00011\u0001W\u0011\u0015QF\u00011\u0001\\\u0011\u0015yF\u00011\u0001a\u0003\t)7-\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u001d\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\tI\"a\u0005\u00031\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'/A\u0002fG\u0002\nq\u0001^5nK>,H/\u0006\u0002\u0002\"A!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\t\u000bA!\u001e;jY&!\u00111FA\u0013\u0005\u001d!\u0016.\\3pkR\f\u0001\u0002^5nK>,H\u000fI\u0001\f]\u0006lWmU3sm\u0016\u00148/F\u0001g\u00031q\u0017-\\3TKJ4XM]:!\u0003M\u0001xn]5uSZ,7)Y2iKB{G.[2z+\t\tI\u0004\u0005\u0003\u0002<\u00055c\u0002BA\u001f\u0003\u0013rA!a\u0010\u0002H9!\u0011\u0011IA#\u001d\rI\u00171I\u0005\u0002\u0007&\u0011\u0011IQ\u0005\u0003\u007f\u0001K1!a\u0013?\u0003-\u0019\u0015m\u00195f!>d\u0017nY=\n\t\u0005=\u0013\u0011\u000b\u0002\f\u0007\u0006\u001c\u0007.\u001a)pY&\u001c\u0017PC\u0002\u0002Ly\nA\u0003]8tSRLg/Z\"bG\",\u0007k\u001c7jGf\u0004\u0013a\u00058fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\u0018\u0001\u00068fO\u0006$\u0018N^3DC\u000eDW\rU8mS\u000eL\b%A\u0005sKF,Xm\u001d;JIV\u0011\u0011Q\f\t\u0004\r\u0006}\u0013bAA1\u000f\n)1\u000b[8si\u0006i!/Z9vKN$\u0018\nZ0%KF$B!a\u001a\u0002nA\u0019a)!\u001b\n\u0007\u0005-tI\u0001\u0003V]&$\b\"CA8!\u0005\u0005\t\u0019AA/\u0003\rAH%M\u0001\u000be\u0016\fX/Z:u\u0013\u0012\u0004\u0013A\u00028fqRLE\r\u0006\u0002\u0002^\u0005I!/Z:pYZ,'o]\u000b\u0002u\u0006Q!/Z:pYZ,'o\u001d\u0011\u0002\u000fI,7-Z5wKV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000b))D\u0001\u0001\u0013\r\t9i\u0014\u0002\b%\u0016\u001cW-\u001b<f\u0003Q\u0011Xm]8mm\u0016<\u0016\u000e\u001e5SKN|GN^3sgRA\u0011QRAQ\u0003k\u000b\t\r\u0005\u0004\u0002\u0012\u0005=\u00151S\u0005\u0005\u0003#\u000b\u0019B\u0001\u0004GkR,(/\u001a\t\u0005\u0003+\u000bYJD\u0002X\u0003/K1!!'?\u0003-!en\u001d)s_R|7m\u001c7\n\t\u0005u\u0015q\u0014\u0002\t%\u0016\u001cx\u000e\u001c<fI*\u0019\u0011\u0011\u0014 \t\u000f\u0005\rf\u00031\u0001\u0002&\u0006!a.Y7f!\u0011\t9+a,\u000f\t\u0005%\u00161\u0016\t\u0003S\u001eK1!!,H\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011WAZ\u0005\u0019\u0019FO]5oO*\u0019\u0011QV$\t\u000f\u0005]f\u00031\u0001\u0002:\u0006Y!/Z9vKN$H+\u001f9f!\u0011\tY,!0\u000f\t\u0005u\u0012qS\u0005\u0005\u0003\u007f\u000byJA\u0006SKF,Xm\u001d;UsB,\u0007BBA<-\u0001\u0007!0\u0001\u0007tK:$\u0017+^3ti&|g\u000e\u0006\u0004\u0002H\u0006m\u0017q\u001c\t\u0007\u0003#\ty)!3\u0011\t\u0005-\u0017Q\u001b\b\u0005\u0003\u001b\f\tN\u0004\u0003\u0002>\u0005=\u0017BA\u001f?\u0013\r\t\u0019\u000eP\u0001\n\t:\u001c8\t\\5f]RLA!a6\u0002Z\n1\u0011I\\:xKJT1!a5=\u0011\u0019\tin\u0006a\u0001w\u0006A!/Z:pYZ,'\u000fC\u0004\u0002b^\u0001\r!a9\u0002\u000f5,7o]1hKB!\u00111ZAs\u0013\u0011\t9/!7\u0003\u0017\u0011s7/U;fgRLwN\\\u0001\u0012e\u0016\u001cx\u000e\u001c<f/&$\bnU3be\u000eDG\u0003CAG\u0003[\fy/!=\t\u000f\u0005\r\u0006\u00041\u0001\u0002&\"9\u0011q\u0017\rA\u0002\u0005e\u0006BBAo1\u0001\u000710\u0001\u0007sKN|GN^3GSJ\u001cH\u000f\u0006\u0005\u0002\u000e\u0006]\u0018Q`A\u0000\u0011\u001d\tI0\u0007a\u0001\u0003w\f1b]3be\u000eDg*Y7fgB!qm\\AS\u0011\u001d\t9,\u0007a\u0001\u0003sCa!!8\u001a\u0001\u0004Y\u0018a\u0002:fg>dg/\u001a\u000b\t\u0003\u001b\u0013)Aa\u0002\u0003\n!9\u00111\u0015\u000eA\u0002\u0005\u0015\u0006bBA\\5\u0001\u0007\u0011\u0011\u0018\u0005\u0007\u0003;T\u0002\u0019A>)\u0007\u0001\u0011i\u0001\u0005\u0003\u0003\u0010\tUQB\u0001B\t\u0015\r\u0011\u0019BQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\f\u0005#\u00111\"\u00138uKJt\u0017\r\\!qS\u0006\u0001\u0012i]=oG\u0012s7OU3t_24XM\u001d\t\u0004\u0003\u0007a2C\u0001\u000fF)\t\u0011Y\"A\u0006jaZ$\u0014\t\u001a3sKN\u001cXC\u0001B\u0013!\u0011\u00119Ca\f\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t\u0001\"\\1uG\"Lgn\u001a\u0006\u0004\u0003O9\u0015\u0002\u0002B\u0019\u0005S\u0011QAU3hKb\fA\"\u001b9wi\u0005#GM]3tg\u0002\n1\"\u001b9wm\u0005#GM]3tg\u0006a\u0011\u000e\u001d<7\u0003\u0012$'/Z:tA\u0005i\u0011n]%qmR\nE\r\u001a:fgN$BA!\u0010\u0003DA\u0019aIa\u0010\n\u0007\t\u0005sIA\u0004C_>dW-\u00198\t\u000f\u0005\r&\u00051\u0001\u0002&\u0006i\u0011n]%qmZ\nE\r\u001a:fgN$BA!\u0010\u0003J!9\u00111U\u0012A\u0002\u0005\u0015\u0016!D5t\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0006\u0003\u0003>\t=\u0003bBARI\u0001\u0007\u0011QU\u0001\u0006\u000b6\u0004H/_\u000b\u0003\u0003\u000f\fa!R7qif\u0004#A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0014\u000f\u001d\u0012YF!\u0019\u0003hA\u0019qM!\u0018\n\u0007\t}\u0013OA\u0005Fq\u000e,\u0007\u000f^5p]B\u0019aIa\u0019\n\u0007\t\u0015tIA\u0004Qe>$Wo\u0019;\u0011\u0007\u0019\u0013I'C\u0002\u0003l\u001d\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1!\\:h+\t\t)+\u0001\u0003ng\u001e\u0004C\u0003\u0002B;\u0005s\u00022Aa\u001e(\u001b\u0005a\u0002b\u0002B7U\u0001\u0007\u0011QU\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003v\t}\u0004\"\u0003B7WA\u0005\t\u0019AAS\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!\"+\t\u0005\u0015&qQ\u0016\u0003\u0005\u0013\u0003BAa#\u0003\u00146\u0011!Q\u0012\u0006\u0005\u0005\u001f\u0013\t*A\u0005v]\u000eDWmY6fI*\u0019!1C$\n\t\tU%Q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u001cB!!Q\u0014BR\u001b\t\u0011yJC\u0002\u0003\"Z\fA\u0001\\1oO&!\u0011\u0011\u0017BP\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011I\u000bE\u0002G\u0005WK1A!,H\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019L!/\u0011\u0007\u0019\u0013),C\u0002\u00038\u001e\u00131!\u00118z\u0011%\tygLA\u0001\u0002\u0004\u0011I+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\f\u0005\u0004\u0003B\n\u001d'1W\u0007\u0003\u0005\u0007T1A!2H\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0013\u0014\u0019M\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001f\u0005\u001fD\u0011\"a\u001c2\u0003\u0003\u0005\rAa-\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!+\u0002\r\u0015\fX/\u00197t)\u0011\u0011iD!7\t\u0013\u0005=4'!AA\u0002\tM\u0016A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\t]TgE\u00036\u0005C\u00149\u0007\u0005\u0005\u0003d\n%\u0018Q\u0015B;\u001b\t\u0011)OC\u0002\u0003h\u001e\u000bqA];oi&lW-\u0003\u0003\u0003l\n\u0015(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!Q\\\u0001\ti>\u001cFO]5oOR\u0011!1T\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005k\u00129\u0010C\u0004\u0003na\u0002\r!!*\u0002\u000fUt\u0017\r\u001d9msR!!Q`B\u0002!\u00151%q`AS\u0013\r\u0019\ta\u0012\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\r\u0015\u0011(!AA\u0002\tU\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0001\u0005\u0003\u0003\u001e\u000e5\u0011\u0002BB\b\u0005?\u0013aa\u00142kK\u000e$\bf\u0001\u000f\u0003\u000e!\u001a1D!\u0004")
@InternalApi
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final SimpleDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get(new Tuple2<String, DnsProtocol.RequestType>(name, mode = resolve.requestType()));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        this.$outer.sender().$bang(resolved2, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1<DnsProtocol.Resolved, DnsProtocol.Resolved> & Serializable & scala.Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((TraversableOnce)((SeqLike)resolved.records().map((Function1<ResourceRecord, CachePolicy.Ttl> & Serializable & scala.Serializable)x$5 -> x$5.ttl(), Seq$.MODULE$.canBuildFrom())).$plus$colon(cachePolicy, Seq$.MODULE$.canBuildFrom())).min(package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put(new Tuple2<String, DnsProtocol.RequestType>(name, mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, this.$outer.ec()), this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return object instanceof DnsProtocol.Resolve;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String akka.io.dns.DnsProtocol$RequestType akka.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0<DnsProtocol.Resolved> & Serializable & scala.Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(20).append("Unexpected address: ").append(inetAddress).toString());
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, Nil$.MODULE$.$colon$colon(aRecord));
            }));
        }
        List<ActorRef> list = resolvers;
        if (((Object)Nil$.MODULE$).equals(list)) {
            return Future$.MODULE$.failed(new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
        }
        if (list instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            ActorRef head = (ActorRef)$colon$colon.head();
            List tail = $colon$colon.tl$access$1();
            return this.resolveWithSearch(name, requestType, head).recoverWith(new scala.Serializable(this, name, requestType, tail){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AsyncDnsResolver $outer;
                private final String name$2;
                private final DnsProtocol.RequestType requestType$1;
                private final List tail$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(A1);
                    if (!option.isEmpty()) {
                        Throwable t = option.get();
                        Throwable throwable = t;
                        if (throwable instanceof AskTimeoutException) {
                            this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$2, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration(this.$outer.timeout().duration())));
                        } else {
                            this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$2, t.getMessage());
                        }
                        return (B1)this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, this.tail$1);
                    }
                    return function1.apply(x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
                    return !option.isEmpty();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.name$2 = name$2;
                    this.requestType$1 = requestType$1;
                    this.tail$1 = tail$1;
                }
            }, this.ec());
        }
        throw new MatchError(list);
    }

    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        Future<DnsClient.Answer> result = AskableActorRef$.MODULE$.$qmark$extension1(package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.failed().foreach((Function1<Throwable, Object> & Serializable & scala.Serializable)x$8 -> {
            resolver.$bang(new DnsClient.DropRequest(message.id()), this.self());
            return BoxedUnit.UNIT;
        }, this.ec());
        return result;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        if (this.settings.SearchDomains().nonEmpty()) {
            List<String> list;
            List<?> nameWithSearch = this.settings.SearchDomains().map((Function1<String, String> & Serializable & scala.Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString(), List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1<Object, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar(x$9)))) >= this.settings.NDots()) {
                String string = name;
                list = nameWithSearch.$colon$colon(string);
            } else {
                list = nameWithSearch.$colon$plus(name, List$.MODULE$.canBuildFrom());
            }
            List<String> toResolve = list;
            return this.resolveFirst(toResolve, requestType, resolver);
        }
        return this.resolve(name, requestType, resolver);
    }

    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        $colon$colon $colon$colon = null;
        List<String> list = searchNames;
        if (list instanceof $colon$colon) {
            bl = true;
            $colon$colon = ($colon$colon)list;
            String searchName = (String)$colon$colon.head();
            List list2 = $colon$colon.tl$access$1();
            if (((Object)Nil$.MODULE$).equals(list2)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)$colon$colon.head();
            List remaining = $colon$colon.tl$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1<DnsProtocol.Resolved, Future> & Serializable & scala.Serializable)resolved -> {
                if (resolved.records().isEmpty()) {
                    return this.resolveFirst(remaining, requestType, resolver);
                }
                return Future$.MODULE$.successful(resolved);
            }, this.ec());
        }
        if (((Object)Nil$.MODULE$).equals(list)) {
            return Future$.MODULE$.failed(new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
        }
        throw new MatchError(list);
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            return ipv4Recs.flatMap((Function1<DnsClient.Answer, Future> & Serializable & scala.Serializable)ipv4 -> ipv6Recs.map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)ipv6 -> new DnsProtocol.Resolved(name, ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom()), ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom())), this.ec()), this.ec());
        }
        if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            return this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1<DnsClient.Answer, DnsProtocol.Resolved> & Serializable & scala.Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), this.ec());
        }
        throw new MatchError(requestType2);
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$9) {
        return x$9 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        Tuple2<Inet4Address, InetAddress> tuple2;
        InetAddress loopback;
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        InetAddress inetAddress = loopback = InetAddress.getLoopbackAddress();
        if (inetAddress instanceof Inet6Address) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            tuple2 = new Tuple2<Inet4Address, InetAddress>((Inet4Address)InetAddress.getByName("127.0.0.1"), inet6Address);
        } else if (inetAddress instanceof Inet4Address) {
            Inet4Address inet4Address = (Inet4Address)inetAddress;
            tuple2 = new Tuple2<Inet4Address, InetAddress>(inet4Address, InetAddress.getByName("::1"));
        } else {
            throw new IllegalArgumentException(new StringBuilder(23).append("Loopback address was [").append(inetAddress).append("]").toString());
        }
        Tuple2<Inet4Address, InetAddress> tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        InetAddress ipv4Address = tuple22._1();
        InetAddress ipv6Address = tuple22._2();
        Tuple2<InetAddress, InetAddress> tuple23 = new Tuple2<InetAddress, InetAddress>(ipv4Address, ipv6Address);
        InetAddress ipv4Address2 = tuple23._1();
        InetAddress ipv6Address2 = tuple23._2();
        ARecord aRecord = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), loopback);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(DnsProtocol$Ip$.MODULE$.apply$default$1(), DnsProtocol$Ip$.MODULE$.apply$default$2())), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$1 = false;
        boolean x$2 = true;
        ARecord aRecord2 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv4Address2);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(x$2, x$1)), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord2)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        boolean x$3 = true;
        boolean x$4 = false;
        ARecord aRecord3 = new ARecord("localhost", CachePolicy$Ttl$.MODULE$.effectivelyForever(), ipv6Address2);
        cache.put(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("localhost"), new DnsProtocol.Ip(x$4, x$3)), DnsProtocol$Resolved$.MODULE$.apply("localhost", Nil$.MODULE$.$colon$colon(aRecord3)), CachePolicy$Ttl$.MODULE$.effectivelyForever());
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger(settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = clientFactory.apply(this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        @Override
        public String productPrefix() {
            return "ResolveFailedException";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.msg();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$(this);
        }
    }
}

