/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.util.ccompat.package$JavaConverters$;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.directory.InitialDirContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class DnsSettings$ {
    public static DnsSettings$ MODULE$;
    private final Regex inetSocketAddress;

    static {
        new DnsSettings$();
    }

    private final int DnsFallbackPort() {
        return 53;
    }

    private Regex inetSocketAddress() {
        return this.inetSocketAddress;
    }

    @InternalApi
    public InetSocketAddress parseNameserverAddress(String str) {
        String string = str;
        Option<List<String>> option = this.inetSocketAddress().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String host = (String)((LinearSeqOptimized)option.get()).apply(0);
            String port = (String)((LinearSeqOptimized)option.get()).apply(1);
            return new InetSocketAddress(host, BoxesRunTime.unboxToInt(Option$.MODULE$.apply(port).fold((JFunction0$mcI$sp & scala.Serializable)() -> 53, (Function1<String, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(DnsSettings$.$anonfun$parseNameserverAddress$2(x$5)))));
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Unparseable address string: ").append(string).toString());
    }

    public Try<List<InetSocketAddress>> getDefaultNameServers(ExtendedActorSystem system) {
        return DnsSettings$.getNameserversUsingJNDI$1().orElse((Function0<Try> & Serializable & scala.Serializable)() -> DnsSettings$.getNameserversUsingReflection$1(system));
    }

    public static final /* synthetic */ int $anonfun$parseNameserverAddress$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toInt();
    }

    private static final Try asInetSocketAddress$1(String server) {
        return Try$.MODULE$.apply((Function0<InetSocketAddress> & Serializable & scala.Serializable)() -> {
            int n;
            URI uri = new URI(server);
            String host = uri.getHost();
            int n2 = uri.getPort();
            switch (n2) {
                case -1: {
                    n = 53;
                    break;
                }
                default: {
                    n = n2;
                    break;
                }
            }
            int port = n;
            return new InetSocketAddress(host, port);
        });
    }

    private static final Try getNameserversUsingJNDI$1() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        env.put("java.naming.provider.url", "dns://");
        return Try$.MODULE$.apply((Function0<List> & Serializable & scala.Serializable)() -> {
            InitialDirContext ctx = new InitialDirContext(env);
            String dnsUrls = (String)ctx.getEnvironment().get("java.naming.provider.url");
            if (dnsUrls != null && !dnsUrls.isEmpty()) {
                String[] servers = dnsUrls.split(" ");
                return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])servers)).flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)server -> Option$.MODULE$.option2Iterable(DnsSettings$.asInetSocketAddress$1(server).toOption()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class))))).toList();
            }
            return Nil$.MODULE$;
        });
    }

    private static final Try getNameserversUsingReflection$1(ExtendedActorSystem system$1) {
        return system$1.dynamicAccess().getClassFor("sun.net.dns.ResolverConfiguration", ClassTag$.MODULE$.Any()).flatMap((Function1<Class, Try> & Serializable & scala.Serializable)c -> Try$.MODULE$.apply((Function0<List> & Serializable & scala.Serializable)() -> {
            Object instance;
            Method open = c.getMethod("open", new Class[0]);
            Method nameservers = c.getMethod("nameservers", new Class[0]);
            java.util.List ns = (java.util.List)nameservers.invoke(instance = open.invoke(null, new Object[0]), new Object[0]);
            if (ns.isEmpty()) {
                throw new IllegalStateException("Empty nameservers list discovered using reflection. Consider configuring default nameservers manually!");
            }
            List<?> res = ((TraversableOnce)package$JavaConverters$.MODULE$.asScalaBufferConverter(ns).asScala()).toList();
            return res.flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(DnsSettings$.asInetSocketAddress$1(s).toOption()), List$.MODULE$.canBuildFrom());
        }));
    }

    private DnsSettings$() {
        MODULE$ = this;
        this.inetSocketAddress = new StringOps(Predef$.MODULE$.augmentString("(.*?)(?::(\\d+))?")).r();
    }
}

