/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.stream.ChunkedInput;
import org.apache.flink.util.Preconditions;

@Internal
public class ChunkedByteBuf
implements ChunkedInput<ByteBuf> {
    private final ByteBuf buf;
    private final int chunkSize;
    private boolean isClosed;
    private boolean isEndOfInput;

    public ChunkedByteBuf(ByteBuf buf, int chunkSize) {
        this.buf = (ByteBuf)Preconditions.checkNotNull((Object)buf, (String)"Buffer");
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"Non-positive chunk size");
        this.chunkSize = chunkSize;
    }

    public boolean isEndOfInput() throws Exception {
        return this.isClosed || this.isEndOfInput;
    }

    public void close() throws Exception {
        if (!this.isClosed) {
            if (!this.isEndOfInput) {
                this.buf.release();
            }
            this.isClosed = true;
        }
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk();
    }

    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        return this.readChunk();
    }

    private ByteBuf readChunk() {
        if (this.isClosed) {
            return null;
        }
        if (this.buf.readableBytes() <= this.chunkSize) {
            this.isEndOfInput = true;
            return this.buf.slice();
        }
        return this.buf.readSlice(this.chunkSize).retain();
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return this.buf.readerIndex();
    }

    public String toString() {
        return "ChunkedByteBuf{buf=" + this.buf + ", chunkSize=" + this.chunkSize + ", isClosed=" + this.isClosed + ", isEndOfInput=" + this.isEndOfInput + "}";
    }
}

