/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtobufInternalUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class PbFormatUtils {
    public static String getFullJavaName(Descriptors.Descriptor descriptor, String outerProtoName) {
        if (null != descriptor.getContainingType()) {
            String parentJavaFullName = PbFormatUtils.getFullJavaName(descriptor.getContainingType(), outerProtoName);
            return parentJavaFullName + "." + descriptor.getName();
        }
        return outerProtoName + descriptor.getName();
    }

    public static String getFullJavaName(Descriptors.EnumDescriptor enumDescriptor, String outerProtoName) {
        if (null != enumDescriptor.getContainingType()) {
            return PbFormatUtils.getFullJavaName(enumDescriptor.getContainingType(), outerProtoName) + "." + enumDescriptor.getName();
        }
        return outerProtoName + enumDescriptor.getName();
    }

    public static boolean isSimpleType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: 
            case BINARY: 
            case VARBINARY: {
                return true;
            }
        }
        return false;
    }

    public static String getStrongCamelCaseJsonName(String name) {
        return ProtobufInternalUtils.underScoreToCamelCase(name, true);
    }

    public static String getOuterProtoPrefix(String name) {
        int index = (name = name.replace('$', '.')).lastIndexOf(46);
        if (index != -1) {
            return name.substring(0, index + 1);
        }
        return "";
    }

    public static Descriptors.Descriptor getDescriptor(String className) {
        try {
            Class<?> pbClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (Descriptors.Descriptor)pbClass.getMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("get %s descriptors error!", className), e);
        }
    }

    public static boolean isRepeatedType(LogicalType type) {
        return type instanceof MapType || type instanceof ArrayType;
    }

    public static boolean isArrayType(LogicalType type) {
        return type instanceof ArrayType;
    }
}

