/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.protobuf.PbFormatConfig;
import org.apache.flink.formats.protobuf.deserialize.ProtoToRowConverter;
import org.apache.flink.formats.protobuf.util.PbFormatUtils;
import org.apache.flink.formats.protobuf.util.PbSchemaValidationUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class PbRowDataDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final TypeInformation<RowData> resultTypeInfo;
    private final PbFormatConfig formatConfig;
    private transient ProtoToRowConverter protoToRowConverter;

    public PbRowDataDeserializationSchema(RowType rowType, TypeInformation<RowData> resultTypeInfo, PbFormatConfig formatConfig) {
        Preconditions.checkNotNull((Object)rowType, (String)"rowType cannot be null");
        this.rowType = rowType;
        this.resultTypeInfo = resultTypeInfo;
        this.formatConfig = formatConfig;
        PbSchemaValidationUtils.validate(PbFormatUtils.getDescriptor(formatConfig.getMessageClassName()), rowType);
    }

    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.protoToRowConverter = new ProtoToRowConverter(this.rowType, this.formatConfig);
    }

    public RowData deserialize(byte[] message) throws IOException {
        try {
            return this.protoToRowConverter.convertProtoBinaryToRow(message);
        }
        catch (Throwable t) {
            if (this.formatConfig.isIgnoreParseErrors()) {
                return null;
            }
            throw new IOException("Failed to deserialize PB object.", t);
        }
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.resultTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PbRowDataDeserializationSchema that = (PbRowDataDeserializationSchema)o;
        return Objects.equals(this.rowType, that.rowType) && Objects.equals(this.resultTypeInfo, that.resultTypeInfo) && Objects.equals(this.formatConfig, that.formatConfig);
    }

    public int hashCode() {
        return Objects.hash(this.rowType, this.resultTypeInfo, this.formatConfig);
    }
}

