/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.deserialize;

import com.google.protobuf.Descriptors;
import org.apache.flink.formats.protobuf.PbCodegenException;
import org.apache.flink.formats.protobuf.deserialize.PbCodegenDeserializer;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

public class PbCodegenSimpleDeserializer
implements PbCodegenDeserializer {
    private final Descriptors.FieldDescriptor fd;
    private final LogicalType logicalType;

    public PbCodegenSimpleDeserializer(Descriptors.FieldDescriptor fd, LogicalType logicalType) {
        this.fd = fd;
        this.logicalType = logicalType;
    }

    @Override
    public String codegen(String resultVar, String pbObjectCode, int indent) throws PbCodegenException {
        PbCodegenAppender appender = new PbCodegenAppender(indent);
        switch (this.fd.getJavaType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                appender.appendLine(resultVar + " = " + pbObjectCode);
                break;
            }
            case BYTE_STRING: {
                appender.appendLine(resultVar + " = " + pbObjectCode + ".toByteArray()");
                break;
            }
            case STRING: {
                appender.appendLine(resultVar + " = BinaryStringData.fromString(" + pbObjectCode + ".toString())");
                break;
            }
            case ENUM: {
                if (this.logicalType.getTypeRoot() == LogicalTypeRoot.CHAR || this.logicalType.getTypeRoot() == LogicalTypeRoot.VARCHAR) {
                    appender.appendLine(resultVar + " = BinaryStringData.fromString(" + pbObjectCode + ".toString())");
                    break;
                }
                if (this.logicalType.getTypeRoot() == LogicalTypeRoot.TINYINT || this.logicalType.getTypeRoot() == LogicalTypeRoot.SMALLINT || this.logicalType.getTypeRoot() == LogicalTypeRoot.INTEGER || this.logicalType.getTypeRoot() == LogicalTypeRoot.BIGINT) {
                    appender.appendLine(resultVar + " = " + pbObjectCode + ".getNumber()");
                    break;
                }
                throw new PbCodegenException("Illegal type for protobuf enum, only char/vachar/int/bigint is supported");
            }
            default: {
                throw new PbCodegenException("Unsupported protobuf simple type: " + this.fd.getJavaType());
            }
        }
        return appender.code();
    }
}

