/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions;

import java.io.UnsupportedEncodingException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.AcsError;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Credential;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.LegacyCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Signer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.FormatType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.reader.Reader;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.reader.ReaderFactory;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.DescribeEndpointRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.DescribeEndpointResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.DescribeEndpointService;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.LocationConfig;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.ProductDomain;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.transform.UnmarshallerContext;

public class DescribeEndpointServiceImpl
implements DescribeEndpointService {
    private static final String DEFAULT_ENDPOINT_TYPE = "openAPI";

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    @Override
    public DescribeEndpointResponse describeEndpoint(String regionId, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) {
        if (this.isEmpty(serviceCode)) {
            return null;
        }
        DescribeEndpointRequest request = new DescribeEndpointRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setId(regionId);
        request.setRegionId(locationConfig.getRegionId());
        request.setLocationProduct(serviceCode);
        request.setSecurityToken(credential.getSecurityToken());
        if (this.isEmpty(endpointType)) {
            endpointType = DEFAULT_ENDPOINT_TYPE;
        }
        request.setEndpointType(endpointType);
        Signer signer = Signer.getSigner(new LegacyCredentials(credential));
        ProductDomain domain = new ProductDomain(locationConfig.getProduct(), locationConfig.getEndpoint());
        try {
            HttpRequest httpRequest = request.signRequest(signer, credential, FormatType.JSON, domain);
            HttpResponse httpResponse = HttpResponse.getResponse(httpRequest);
            if (httpResponse.isSuccess()) {
                String data = new String(httpResponse.getHttpContent(), "utf-8");
                DescribeEndpointResponse response = this.getEndpointResponse(data, endpointType);
                if (response == null || this.isEmpty(response.getEndpoint())) {
                    return null;
                }
                return response;
            }
            AcsError error = this.readError(httpResponse, FormatType.JSON);
            if (500 <= httpResponse.getStatus()) {
                System.out.println("Invoke_Error, requestId:" + error.getRequestId() + "; code:" + error.getErrorCode() + "; Msg" + error.getErrorMessage());
                return null;
            }
            System.out.println("Invoke_Error, requestId:" + error.getRequestId() + "; code:" + error.getErrorCode() + "; Msg" + error.getErrorMessage());
            return null;
        }
        catch (Throwable e) {
            System.out.println("Invoke Remote Error,Msg" + e.getMessage());
            return null;
        }
    }

    private DescribeEndpointResponse getEndpointResponse(String data, String endpointType) throws ClientException {
        Reader reader = ReaderFactory.createInstance(FormatType.JSON);
        UnmarshallerContext context = new UnmarshallerContext();
        context.setResponseMap(reader.read(data, "DescribeEndpointsResponse"));
        int endpointsLength = context.lengthValue("DescribeEndpointsResponse.Endpoints.Length");
        for (int i = 0; i < endpointsLength; ++i) {
            if (!endpointType.equalsIgnoreCase(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Type"))) continue;
            DescribeEndpointResponse response = new DescribeEndpointResponse();
            response.setRequestId(context.stringValue("DescribeEndpointsResponse.RequestId"));
            response.setProduct(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].SerivceCode"));
            response.setEndpoint(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Endpoint"));
            response.setRegionId(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Id"));
            return response;
        }
        return null;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = this.getResponseContent(httpResponse);
        context.setResponseMap(reader.read(stringContent, responseEndpoint));
        error = error.getInstance(context);
        if (httpResponse.getStatus() > 0) {
            error.setStatusCode(httpResponse.getStatus());
        }
        return error;
    }

    private String getResponseContent(HttpResponse httpResponse) throws ClientException {
        String stringContent = null;
        try {
            stringContent = null == httpResponse.getEncoding() ? new String(httpResponse.getHttpContent()) : new String(httpResponse.getHttpContent(), httpResponse.getEncoding());
        }
        catch (UnsupportedEncodingException exp) {
            throw new ClientException("SDK.UnsupportedEncoding", "Can not parse response due to un supported encoding.");
        }
        return stringContent;
    }
}

