/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.HttpMethod;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.OSSException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ServiceClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.RequestMarshallers;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.CRC64;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.CodingUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.IOUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressEventType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressListener;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressPublisher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSOperation;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSRequestMessageBuilder;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.ResponseParsers;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CreateUdfApplicationRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CreateUdfRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GetUdfApplicationLogRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ResizeUdfApplicationRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfApplicationInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfApplicationLog;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfGenericRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfImageInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UpgradeUdfApplicationRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UploadUdfImageRequest;

public class OSSUdfOperation
extends OSSOperation {
    public OSSUdfOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public void createUdf(CreateUdfRequest createUdfRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createUdfRequest, "createUdfRequest");
        CodingUtils.assertParameterNotNull(createUdfRequest.getName(), "createUdfRequest.name");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udf", null);
        byte[] rawContent = RequestMarshallers.createUdfRequestMarshaller.marshall(createUdfRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(createUdfRequest).build();
        this.doOperation(request, emptyResponseParser, null, null);
    }

    public UdfInfo getUdfInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udf", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getUdfInfoResponseParser, null, null, true);
    }

    public List<UdfInfo> listUdfs() throws OSSException, ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udf", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listUdfResponseParser, null, null, true);
    }

    public void deleteUdf(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udf", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, null, null);
    }

    public void uploadUdfImage(UploadUdfImageRequest uploadUdfImageRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(uploadUdfImageRequest, "uploadUdfImageRequest");
        CodingUtils.assertParameterNotNull(uploadUdfImageRequest.getUdfImage(), "udfImage");
        CodingUtils.assertParameterNotNull(uploadUdfImageRequest.getName(), "udfImage");
        OSSUtils.ensureBucketNameValid(uploadUdfImageRequest.getName());
        InputStream repeatableInputStream = null;
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(uploadUdfImageRequest.getUdfImage());
        }
        catch (IOException ex) {
            LogUtils.logException("Cannot wrap to repeatable input stream: ", ex);
            throw new ClientException("Cannot wrap to repeatable input stream: ", ex);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("udfImage", null);
        params.put("udfName", uploadUdfImageRequest.getName());
        if (uploadUdfImageRequest.getUdfImageDesc() != null) {
            params.put("udfImageDesc", uploadUdfImageRequest.getUdfImageDesc());
        }
        RequestMessage httpRequest = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setHeaders(headers).setParameters(params).setInputStream(repeatableInputStream).setInputSize(OSSUtils.determineInputStreamLength(repeatableInputStream, 0L)).setOriginalRequest(uploadUdfImageRequest).build();
        ProgressListener listener = uploadUdfImageRequest.getProgressListener();
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            this.doOperation(httpRequest, emptyResponseParser, null, null, true);
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
    }

    public List<UdfImageInfo> getUdfImageInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfImage", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getUdfImageInfoResponseParser, null, null, true);
    }

    public void deleteUdfImage(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfImage", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, null, null, true);
    }

    public void createUdfApplication(CreateUdfApplicationRequest createUdfApplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createUdfApplicationRequest, "createUdfApplicationRequest");
        String udfName = createUdfApplicationRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        params.put("udfName", udfName);
        params.put("comp", "create");
        byte[] rawContent = RequestMarshallers.createUdfApplicationRequestMarshaller.marshall(createUdfApplicationRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(createUdfApplicationRequest).build();
        this.doOperation(request, emptyResponseParser, null, null);
    }

    public UdfApplicationInfo getUdfApplicationInfo(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getUdfApplicationInfoResponseParser, null, null, true);
    }

    public List<UdfApplicationInfo> listUdfApplication() throws OSSException, ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listUdfApplicationInfoResponseParser, null, null, true);
    }

    public void deleteUdfApplication(UdfGenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String udfName = genericRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        params.put("udfName", udfName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setParameters(params).setOriginalRequest(genericRequest).build();
        this.doOperation(request, emptyResponseParser, null, null, true);
    }

    public void upgradeUdfApplication(UpgradeUdfApplicationRequest upgradeUdfApplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(upgradeUdfApplicationRequest, "upgradeUdfApplicationRequest");
        String udfName = upgradeUdfApplicationRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        params.put("udfName", udfName);
        params.put("comp", "upgrade");
        byte[] rawContent = RequestMarshallers.upgradeUdfApplicationRequestMarshaller.marshall(upgradeUdfApplicationRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(upgradeUdfApplicationRequest).build();
        this.doOperation(request, emptyResponseParser, null, null);
    }

    public void resizeUdfApplication(ResizeUdfApplicationRequest resizeUdfApplicationRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(resizeUdfApplicationRequest, "resizeUdfApplicationRequest");
        String udfName = resizeUdfApplicationRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("udfApplication", null);
        params.put("udfName", udfName);
        params.put("comp", "resize");
        byte[] rawContent = RequestMarshallers.resizeUdfApplicationRequestMarshaller.marshall(resizeUdfApplicationRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(resizeUdfApplicationRequest).build();
        this.doOperation(request, emptyResponseParser, null, null);
    }

    public UdfApplicationLog getUdfApplicationLog(GetUdfApplicationLogRequest getUdfApplicationLogRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getUdfApplicationLogRequest, "resizeUdfApplicationRequest");
        String udfName = getUdfApplicationLogRequest.getName();
        CodingUtils.assertParameterNotNull(udfName, "udfName");
        OSSUtils.ensureBucketNameValid(udfName);
        HashMap<String, String> params = new HashMap<String, String>();
        OSSUdfOperation.populateGetUdfApplicationLogParameters(params, getUdfApplicationLogRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).setOriginalRequest(getUdfApplicationLogRequest).build();
        ProgressListener listener = getUdfApplicationLogRequest.getProgressListener();
        UdfApplicationLog udfApplicationLog = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            udfApplicationLog = this.doOperation(request, new ResponseParsers.GetUdfApplicationLogResponseParser(udfName), null, null, true);
            InputStream instream = udfApplicationLog.getLogContent();
            ProgressInputStream progressInputStream = new ProgressInputStream(instream, listener){

                @Override
                protected void onEOF() {
                    ProgressPublisher.publishProgress(this.getListener(), ProgressEventType.TRANSFER_COMPLETED_EVENT);
                }
            };
            CRC64 crc = new CRC64();
            CheckedInputStream checkedInputstream = new CheckedInputStream(progressInputStream, crc);
            udfApplicationLog.setLogContent(checkedInputstream);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        return udfApplicationLog;
    }

    private static void populateGetUdfApplicationLogParameters(Map<String, String> params, GetUdfApplicationLogRequest getUdfApplicationLogRequest) {
        Long endLines;
        params.put("udfApplicationLog", null);
        params.put("udfName", getUdfApplicationLogRequest.getName());
        Date startTime = getUdfApplicationLogRequest.getStartTime();
        if (startTime != null) {
            params.put("since", Long.toString(startTime.getTime() / 1000L));
        }
        if ((endLines = getUdfApplicationLogRequest.getEndLines()) != null) {
            params.put("tail", endLines.toString());
        }
    }
}

