/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import java.net.URI;
import java.util.List;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.HttpMethod;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.OSSException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ServiceException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.RequestSigner;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ExecutionContext;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.NoRetryStrategy;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestChecksumHanlder;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestProgressHanlder;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseChecksumHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseProgressHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RetryStrategy;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ServiceClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.SignVersion;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParseException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParser;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.ExceptionFactory;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSErrorResponseHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSRequestSigner;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.ResponseParsers;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.WebServiceRequest;

public abstract class OSSOperation {
    protected volatile URI endpoint;
    protected CredentialsProvider credsProvider;
    protected ServiceClient client;
    protected static OSSErrorResponseHandler errorResponseHandler = new OSSErrorResponseHandler();
    protected static ResponseParsers.EmptyResponseParser emptyResponseParser = new ResponseParsers.EmptyResponseParser();
    protected static RetryStrategy noRetryStrategy = new NoRetryStrategy();

    protected OSSOperation(ServiceClient client, CredentialsProvider credsProvider) {
        this.client = client;
        this.credsProvider = credsProvider;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = URI.create(endpoint.toString());
    }

    protected ServiceClient getInnerClient() {
        return this.client;
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context) throws OSSException, ClientException {
        return this.send(request, context, false);
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws OSSException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        catch (ServiceException e) {
            assert (e instanceof OSSException);
            throw (OSSException)e;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, false);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, keepResponseOpen, null, null);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen, List<RequestHandler> requestHandlers, List<ResponseHandler> reponseHandlers) throws OSSException, ClientException {
        List<RequestSigner> signerHandlers;
        WebServiceRequest originalRequest = request.getOriginalRequest();
        request.getHeaders().putAll(this.client.getClientConfiguration().getDefaultHeaders());
        request.getHeaders().putAll(originalRequest.getHeaders());
        request.getParameters().putAll(originalRequest.getParameters());
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        if (context.getCredentials().useSecurityToken() && !request.isUseUrlSignature()) {
            request.addHeader("x-oss-security-token", context.getCredentials().getSecurityToken());
        }
        context.addRequestHandler(new RequestProgressHanlder());
        if (requestHandlers != null) {
            for (RequestHandler requestHandler : requestHandlers) {
                context.addRequestHandler(requestHandler);
            }
        }
        if (this.client.getClientConfiguration().isCrcCheckEnabled()) {
            context.addRequestHandler(new RequestChecksumHanlder());
        }
        context.addResponseHandler(new ResponseProgressHandler(originalRequest));
        if (reponseHandlers != null) {
            for (ResponseHandler responseHandler : reponseHandlers) {
                context.addResponseHandler(responseHandler);
            }
        }
        if (this.client.getClientConfiguration().isCrcCheckEnabled()) {
            context.addResponseHandler(new ResponseChecksumHandler());
        }
        if ((signerHandlers = this.client.getClientConfiguration().getSignerHandlers()) != null) {
            for (RequestSigner signer : signerHandlers) {
                context.addSignerHandler(signer);
            }
        }
        ResponseMessage responseMessage = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(responseMessage);
        }
        catch (ResponseParseException rpe) {
            OSSException oe = ExceptionFactory.createInvalidResponseException(responseMessage.getRequestId(), rpe.getMessage(), rpe);
            LogUtils.logException("Unable to parse response error: ", rpe);
            throw oe;
        }
    }

    private static RequestSigner createSigner(HttpMethod method, String bucketName, String key, Credentials creds, SignVersion signatureVersion) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        return new OSSRequestSigner(method.toString(), resourcePath, creds, signatureVersion);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName, String key) {
        ExecutionContext context = new ExecutionContext();
        context.setCharset("utf-8");
        context.setSigner(OSSOperation.createSigner(method, bucketName, key, this.credsProvider.getCredentials(), this.client.getClientConfiguration().getSignatureVersion()));
        context.addResponseHandler(errorResponseHandler);
        if (method == HttpMethod.POST) {
            context.setRetryStrategy(noRetryStrategy);
        }
        context.setCredentials(this.credsProvider.getCredentials());
        return context;
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName) {
        return this.createDefaultContext(method, bucketName, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method) {
        return this.createDefaultContext(method, null, null);
    }
}

