/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm;

import java.io.InputStream;
import java.util.Map;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.OSSException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressListener;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressPublisher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.WebServiceRequest;

public class ResponseProgressHandler
implements ResponseHandler {
    private final WebServiceRequest originalRequest;

    public ResponseProgressHandler(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    @Override
    public void handle(ResponseMessage response) throws OSSException, ClientException {
        InputStream content;
        ProgressListener listener = this.originalRequest.getProgressListener();
        Map<String, String> headers = response.getHeaders();
        String s2 = headers.get("Content-Length");
        if (s2 != null) {
            try {
                long contentLength = Long.parseLong(s2);
                ProgressPublisher.publishResponseContentLength(listener, contentLength);
            }
            catch (NumberFormatException e) {
                LogUtils.logException("Cannot parse the Content-Length header of the response: ", e);
            }
        }
        if ((content = response.getContent()) != null && listener != ProgressListener.NOOP) {
            InputStream progressInputStream = ProgressInputStream.inputStreamForResponse(content, this.originalRequest);
            response.setContent(progressInputStream);
        }
    }
}

