/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.BasicCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.DefaultAcsClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.StaticCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.AssumeRoleRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.AssumeRoleResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.profile.IClientProfile;

public class STSAssumeRoleSessionCredentialsProvider
implements CredentialsProvider {
    private DefaultAcsClient ramClient;
    private String roleArn;
    private String roleSessionName;
    private BasicCredentials credentials;
    private long expiredDurationSeconds = 3600L;
    private double expiredFactor = 0.8;

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentials longLivedCredentials, String roleArn, IClientProfile clientProfile) {
        this(new StaticCredentialsProvider(longLivedCredentials), roleArn, clientProfile);
    }

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentialsProvider longLivedCredentialsProvider, String roleArn, IClientProfile clientProfile) {
        if (roleArn == null) {
            throw new NullPointerException("You must specify a value for roleArn.");
        }
        this.roleArn = roleArn;
        this.roleSessionName = STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName();
        this.ramClient = new DefaultAcsClient(clientProfile, longLivedCredentialsProvider);
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withExpiredDuration(long expiredDurationSeconds) {
        if (expiredDurationSeconds < 900L || expiredDurationSeconds > 3600L) {
            throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - 1hour");
        }
        this.expiredDurationSeconds = expiredDurationSeconds;
        return this;
    }

    public static String getNewRoleSessionName() {
        return "aliyun-java-sdk-" + System.currentTimeMillis();
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public Credentials getCredentials() {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            this.credentials = this.getNewSessionCredentials();
        }
        return this.credentials;
    }

    private BasicCredentials getNewSessionCredentials() {
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest();
        assumeRoleRequest.setRoleArn(this.roleArn);
        assumeRoleRequest.setRoleSessionName(this.roleSessionName);
        assumeRoleRequest.setDurationSeconds(this.expiredDurationSeconds);
        AssumeRoleResponse response = null;
        try {
            response = this.ramClient.getAcsResponse(assumeRoleRequest);
        }
        catch (ClientException e) {
            LogUtils.logException("RamClient.getAcsResponse Exception:", e);
            return null;
        }
        return new BasicCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken(), this.expiredDurationSeconds).withExpiredFactor(this.expiredFactor);
    }
}

