/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.BasicCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.CustomSessionCredentialsFetcher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;

public class CustomSessionCredentialsProvider
implements CredentialsProvider {
    private BasicCredentials credentials;
    private CustomSessionCredentialsFetcher fetcher;
    private int maxRetryTimes = 3;

    public CustomSessionCredentialsProvider(String ossAuthServerHost) {
        this.fetcher = new CustomSessionCredentialsFetcher(ossAuthServerHost);
    }

    public CustomSessionCredentialsProvider withCredentialsFetcher(CustomSessionCredentialsFetcher fetcher) {
        this.fetcher = fetcher;
        return this;
    }

    @Override
    public void setCredentials(Credentials creds) {
    }

    @Override
    public Credentials getCredentials() {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            try {
                this.credentials = (BasicCredentials)this.fetcher.fetch(this.maxRetryTimes);
            }
            catch (ClientException e) {
                LogUtils.logException("OssAuthCredentialsProvider.fetch Exception:", e);
                return null;
            }
        }
        return this.credentials;
    }
}

