/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.osshadoop.common.HadoopFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSFileSystemFactory
implements FileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OSSFileSystemFactory.class);
    private Configuration flinkConfig;
    private org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration hadoopConfig;
    private static final Set<String> CONFIG_KEYS_TO_SHADE = Collections.singleton("fs.oss.credentials.provider");
    private static final String FLINK_SHADING_PREFIX = "org.apache.flink.fs.osshadoop.shaded.";
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"fs.oss."};

    public String getScheme() {
        return "oss";
    }

    public void configure(Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfig = null;
    }

    public FileSystem create(URI fsUri) throws IOException {
        URI defaultUri;
        this.hadoopConfig = this.getHadoopConfiguration();
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        if (scheme == null && authority == null) {
            fsUri = org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem.getDefaultUri(this.hadoopConfig);
        } else if (scheme != null && authority == null && scheme.equals((defaultUri = org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem.getDefaultUri(this.hadoopConfig)).getScheme()) && defaultUri.getAuthority() != null) {
            fsUri = defaultUri;
        }
        AliyunOSSFileSystem fs = new AliyunOSSFileSystem();
        fs.initialize(fsUri, this.hadoopConfig);
        return new HadoopFileSystem(fs);
    }

    @VisibleForTesting
    org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration conf = new org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration();
        if (this.flinkConfig == null) {
            return conf;
        }
        for (String key : this.flinkConfig.keySet()) {
            for (String prefix : FLINK_CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String value = this.flinkConfig.getString(key, null);
                conf.set(key, value);
                if (CONFIG_KEYS_TO_SHADE.contains(key)) {
                    conf.set(key, FLINK_SHADING_PREFIX + value);
                }
                LOG.debug("Adding Flink config entry for {} as {} to Hadoop config", (Object)key, (Object)conf.get(key));
            }
        }
        return conf;
    }
}

