/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.InterestingProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorDual;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.DualInputPlanNode;
import org.apache.flink.optimizer.plan.NamedChannel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

public abstract class TwoInputNode
extends OptimizerNode {
    protected final FieldList keys1;
    protected final FieldList keys2;
    protected DagConnection input1;
    protected DagConnection input2;
    private List<OperatorDescriptorDual> cachedDescriptors;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TwoInputNode(DualInputOperator<?, ?, ?, ?> operator) {
        super((Operator<?>)operator);
        int[] k1 = operator.getKeyColumns(0);
        int[] k2 = operator.getKeyColumns(1);
        this.keys1 = k1 == null || k1.length == 0 ? null : new FieldList(k1);
        FieldList fieldList = this.keys2 = k2 == null || k2.length == 0 ? null : new FieldList(k2);
        if (this.keys1 != null) {
            if (this.keys2 == null) throw new CompilerException("Keys are set on first input, but not on second.");
            if (this.keys1.size() == this.keys2.size()) return;
            throw new CompilerException("Unequal number of key fields on the two inputs.");
        }
        if (this.keys2 == null) return;
        throw new CompilerException("Keys are set on second input, but not on first.");
    }

    public DualInputOperator<?, ?, ?, ?> getOperator() {
        return (DualInputOperator)super.getOperator();
    }

    public DagConnection getFirstIncomingConnection() {
        return this.input1;
    }

    public DagConnection getSecondIncomingConnection() {
        return this.input2;
    }

    public OptimizerNode getFirstPredecessorNode() {
        if (this.input1 != null) {
            return this.input1.getSource();
        }
        return null;
    }

    public OptimizerNode getSecondPredecessorNode() {
        if (this.input2 != null) {
            return this.input2.getSource();
        }
        return null;
    }

    @Override
    public List<DagConnection> getIncomingConnections() {
        ArrayList<DagConnection> inputs = new ArrayList<DagConnection>(2);
        inputs.add(this.input1);
        inputs.add(this.input2);
        return inputs;
    }

    @Override
    public void setInput(Map<Operator<?>, OptimizerNode> contractToNode, ExecutionMode defaultExecutionMode) {
        Configuration conf = this.getOperator().getParameters();
        ShipStrategyType preSet1 = null;
        ShipStrategyType preSet2 = null;
        String shipStrategy = conf.getString("INPUT_SHIP_STRATEGY", null);
        if (shipStrategy != null) {
            if ("SHIP_FORWARD".equals(shipStrategy)) {
                preSet1 = preSet2 = ShipStrategyType.FORWARD;
            } else if ("SHIP_BROADCAST".equals(shipStrategy)) {
                preSet1 = preSet2 = ShipStrategyType.BROADCAST;
            } else if ("SHIP_REPARTITION_HASH".equals(shipStrategy)) {
                preSet1 = preSet2 = ShipStrategyType.PARTITION_HASH;
            } else if ("SHIP_REPARTITION_RANGE".equals(shipStrategy)) {
                preSet1 = preSet2 = ShipStrategyType.PARTITION_RANGE;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION")) {
                preSet1 = preSet2 = ShipStrategyType.PARTITION_RANDOM;
            } else {
                throw new CompilerException("Unknown hint for shipping strategy: " + shipStrategy);
            }
        }
        if ((shipStrategy = conf.getString("INPUT_LEFT_SHIP_STRATEGY", null)) != null) {
            if ("SHIP_FORWARD".equals(shipStrategy)) {
                preSet1 = ShipStrategyType.FORWARD;
            } else if ("SHIP_BROADCAST".equals(shipStrategy)) {
                preSet1 = ShipStrategyType.BROADCAST;
            } else if ("SHIP_REPARTITION_HASH".equals(shipStrategy)) {
                preSet1 = ShipStrategyType.PARTITION_HASH;
            } else if ("SHIP_REPARTITION_RANGE".equals(shipStrategy)) {
                preSet1 = ShipStrategyType.PARTITION_RANGE;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION")) {
                preSet1 = ShipStrategyType.PARTITION_RANDOM;
            } else {
                throw new CompilerException("Unknown hint for shipping strategy of input one: " + shipStrategy);
            }
        }
        if ((shipStrategy = conf.getString("INPUT_RIGHT_SHIP_STRATEGY", null)) != null) {
            if ("SHIP_FORWARD".equals(shipStrategy)) {
                preSet2 = ShipStrategyType.FORWARD;
            } else if ("SHIP_BROADCAST".equals(shipStrategy)) {
                preSet2 = ShipStrategyType.BROADCAST;
            } else if ("SHIP_REPARTITION_HASH".equals(shipStrategy)) {
                preSet2 = ShipStrategyType.PARTITION_HASH;
            } else if ("SHIP_REPARTITION_RANGE".equals(shipStrategy)) {
                preSet2 = ShipStrategyType.PARTITION_RANGE;
            } else if (shipStrategy.equalsIgnoreCase("SHIP_REPARTITION")) {
                preSet2 = ShipStrategyType.PARTITION_RANDOM;
            } else {
                throw new CompilerException("Unknown hint for shipping strategy of input two: " + shipStrategy);
            }
        }
        DualInputOperator<?, ?, ?, ?> contr = this.getOperator();
        Operator leftPred = contr.getFirstInput();
        Operator rightPred = contr.getSecondInput();
        if (leftPred == null) {
            throw new CompilerException("Error: Node for '" + this.getOperator().getName() + "' has no input set for first input.");
        }
        OptimizerNode pred1 = contractToNode.get(leftPred);
        DagConnection conn1 = new DagConnection(pred1, this, defaultExecutionMode);
        if (preSet1 != null) {
            conn1.setShipStrategy(preSet1);
        }
        this.input1 = conn1;
        pred1.addOutgoingConnection(conn1);
        if (rightPred == null) {
            throw new CompilerException("Error: Node for '" + this.getOperator().getName() + "' has no input set for second input.");
        }
        OptimizerNode pred2 = contractToNode.get(rightPred);
        DagConnection conn2 = new DagConnection(pred2, this, defaultExecutionMode);
        if (preSet2 != null) {
            conn2.setShipStrategy(preSet2);
        }
        this.input2 = conn2;
        pred2.addOutgoingConnection(conn2);
    }

    protected abstract List<OperatorDescriptorDual> getPossibleProperties();

    private List<OperatorDescriptorDual> getProperties() {
        if (this.cachedDescriptors == null) {
            this.cachedDescriptors = this.getPossibleProperties();
        }
        return this.cachedDescriptors;
    }

    @Override
    public void computeInterestingPropertiesForInputs(CostEstimator estimator) {
        InterestingProperties props1 = this.getInterestingProperties().filterByCodeAnnotations(this, 0);
        InterestingProperties props2 = this.getInterestingProperties().filterByCodeAnnotations(this, 1);
        for (OperatorDescriptorDual dpd : this.getProperties()) {
            for (OperatorDescriptorDual.GlobalPropertiesPair gp : dpd.getPossibleGlobalProperties()) {
                props1.addGlobalProperties(gp.getProperties1());
                props2.addGlobalProperties(gp.getProperties2());
            }
            for (OperatorDescriptorDual.LocalPropertiesPair lp : dpd.getPossibleLocalProperties()) {
                props1.addLocalProperties(lp.getProperties1());
                props2.addLocalProperties(lp.getProperties2());
            }
        }
        this.input1.setInterestingProperties(props1);
        this.input2.setInterestingProperties(props2);
        for (DagConnection conn : this.getBroadcastConnections()) {
            conn.setInterestingProperties(new InterestingProperties());
        }
    }

    @Override
    public List<PlanNode> getAlternativePlans(CostEstimator estimator) {
        if (this.cachedPlans != null) {
            return this.cachedPlans;
        }
        boolean childrenSkippedDueToReplicatedInput = false;
        List<PlanNode> subPlans1 = this.getFirstPredecessorNode().getAlternativePlans(estimator);
        List<PlanNode> subPlans2 = this.getSecondPredecessorNode().getAlternativePlans(estimator);
        Set<RequestedGlobalProperties> intGlobal1 = this.input1.getInterestingProperties().getGlobalProperties();
        Set<RequestedGlobalProperties> intGlobal2 = this.input2.getInterestingProperties().getGlobalProperties();
        ArrayList<Set<? extends NamedChannel>> broadcastPlanChannels = new ArrayList<Set<? extends NamedChannel>>();
        List<DagConnection> broadcastConnections = this.getBroadcastConnections();
        List<String> broadcastConnectionNames = this.getBroadcastConnectionNames();
        for (int i = 0; i < broadcastConnections.size(); ++i) {
            DagConnection broadcastConnection = broadcastConnections.get(i);
            String broadcastConnectionName = broadcastConnectionNames.get(i);
            List<PlanNode> broadcastPlanCandidates = broadcastConnection.getSource().getAlternativePlans(estimator);
            HashSet broadcastChannels = new HashSet(broadcastPlanCandidates.size());
            for (PlanNode plan : broadcastPlanCandidates) {
                NamedChannel c = new NamedChannel(broadcastConnectionName, plan);
                DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)broadcastConnection.getDataExchangeMode(), (ShipStrategyType)ShipStrategyType.BROADCAST, (boolean)broadcastConnection.isBreakingPipeline());
                c.setShipStrategy(ShipStrategyType.BROADCAST, exMode);
                broadcastChannels.add(c);
            }
            broadcastPlanChannels.add(broadcastChannels);
        }
        HashSet<OperatorDescriptorDual.GlobalPropertiesPair> pairsGlob = new HashSet<OperatorDescriptorDual.GlobalPropertiesPair>();
        HashSet<OperatorDescriptorDual.LocalPropertiesPair> pairsLoc = new HashSet<OperatorDescriptorDual.LocalPropertiesPair>();
        for (OperatorDescriptorDual ods : this.getProperties()) {
            pairsGlob.addAll(ods.getPossibleGlobalProperties());
            pairsLoc.addAll(ods.getPossibleLocalProperties());
        }
        OperatorDescriptorDual.GlobalPropertiesPair[] allGlobalPairs = pairsGlob.toArray(new OperatorDescriptorDual.GlobalPropertiesPair[pairsGlob.size()]);
        OperatorDescriptorDual.LocalPropertiesPair[] allLocalPairs = pairsLoc.toArray(new OperatorDescriptorDual.LocalPropertiesPair[pairsLoc.size()]);
        ArrayList<PlanNode> outputPlans = new ArrayList<PlanNode>();
        ExecutionMode input1Mode = this.input1.getDataExchangeMode();
        ExecutionMode input2Mode = this.input2.getDataExchangeMode();
        int parallelism = this.getParallelism();
        int inParallelism1 = this.getFirstPredecessorNode().getParallelism();
        int inParallelism2 = this.getSecondPredecessorNode().getParallelism();
        boolean dopChange1 = parallelism != inParallelism1;
        boolean dopChange2 = parallelism != inParallelism2;
        boolean input1breaksPipeline = this.input1.isBreakingPipeline();
        boolean input2breaksPipeline = this.input2.isBreakingPipeline();
        for (PlanNode child1 : subPlans1) {
            if (child1.getGlobalProperties().isFullyReplicated()) {
                if (dopChange1) {
                    childrenSkippedDueToReplicatedInput = true;
                    continue;
                }
                this.input1.setShipStrategy(ShipStrategyType.FORWARD);
            }
            block4: for (PlanNode child2 : subPlans2) {
                if (child2.getGlobalProperties().isFullyReplicated()) {
                    if (dopChange2) {
                        childrenSkippedDueToReplicatedInput = true;
                        continue;
                    }
                    this.input2.setShipStrategy(ShipStrategyType.FORWARD);
                }
                if (!this.areBranchCompatible(child1, child2)) continue;
                for (RequestedGlobalProperties igps1 : intGlobal1) {
                    Channel c1 = new Channel(child1, this.input1.getMaterializationMode());
                    if (this.input1.getShipStrategy() == null) {
                        igps1.parameterizeChannel(c1, dopChange1, input1Mode, input1breaksPipeline);
                        if (dopChange1 && !c1.getShipStrategy().isNetworkStrategy()) {
                            c1.getGlobalProperties().reset();
                        }
                    } else {
                        ShipStrategyType shipType = this.input1.getShipStrategy();
                        DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)input1Mode, (ShipStrategyType)shipType, (boolean)input1breaksPipeline);
                        if (this.keys1 != null) {
                            c1.setShipStrategy(shipType, this.keys1.toFieldList(), exMode);
                        } else {
                            c1.setShipStrategy(shipType, exMode);
                        }
                        if (dopChange1) {
                            c1.adjustGlobalPropertiesForFullParallelismChange();
                        }
                    }
                    for (RequestedGlobalProperties igps2 : intGlobal2) {
                        Channel c2 = new Channel(child2, this.input2.getMaterializationMode());
                        if (this.input2.getShipStrategy() == null) {
                            igps2.parameterizeChannel(c2, dopChange2, input2Mode, input2breaksPipeline);
                            if (dopChange2 && !c2.getShipStrategy().isNetworkStrategy()) {
                                c2.getGlobalProperties().reset();
                            }
                        } else {
                            ShipStrategyType shipType = this.input2.getShipStrategy();
                            DataExchangeMode exMode = DataExchangeMode.select((ExecutionMode)input2Mode, (ShipStrategyType)shipType, (boolean)input2breaksPipeline);
                            if (this.keys2 != null) {
                                c2.setShipStrategy(shipType, this.keys2.toFieldList(), exMode);
                            } else {
                                c2.setShipStrategy(shipType, exMode);
                            }
                            if (dopChange2) {
                                c2.adjustGlobalPropertiesForFullParallelismChange();
                            }
                        }
                        block7: for (OperatorDescriptorDual.GlobalPropertiesPair gpp : allGlobalPairs) {
                            if (!gpp.getProperties1().isMetBy(c1.getGlobalProperties()) || !gpp.getProperties2().isMetBy(c2.getGlobalProperties())) continue;
                            for (OperatorDescriptorDual desc : this.getProperties()) {
                                if (!desc.areCompatible(gpp.getProperties1(), gpp.getProperties2(), c1.getGlobalProperties(), c2.getGlobalProperties())) continue;
                                Channel c1Clone = c1.clone();
                                c1Clone.setRequiredGlobalProps(gpp.getProperties1());
                                c2.setRequiredGlobalProps(gpp.getProperties2());
                                this.addLocalCandidates(c1Clone, c2, broadcastPlanChannels, igps1, igps2, outputPlans, allLocalPairs, estimator);
                                break block7;
                            }
                        }
                        if (this.input2.getShipStrategy() == null) continue;
                        break;
                    }
                    if (this.input1.getShipStrategy() == null) continue;
                    continue block4;
                }
            }
        }
        if (outputPlans.isEmpty()) {
            if (childrenSkippedDueToReplicatedInput) {
                throw new CompilerException("No plan meeting the requirements could be created @ " + this + ". Most likely reason: Invalid use of replicated input.");
            }
            throw new CompilerException("No plan meeting the requirements could be created @ " + this + ". Most likely reason: Too restrictive plan hints.");
        }
        for (PlanNode node : outputPlans) {
            estimator.costOperator(node);
        }
        this.prunePlanAlternatives(outputPlans);
        outputPlans.trimToSize();
        this.cachedPlans = outputPlans;
        return outputPlans;
    }

    protected void addLocalCandidates(Channel template1, Channel template2, List<Set<? extends NamedChannel>> broadcastPlanChannels, RequestedGlobalProperties rgps1, RequestedGlobalProperties rgps2, List<PlanNode> target, OperatorDescriptorDual.LocalPropertiesPair[] validLocalCombinations, CostEstimator estimator) {
        for (RequestedLocalProperties ilp1 : this.input1.getInterestingProperties().getLocalProperties()) {
            Channel in1 = template1.clone();
            ilp1.parameterizeChannel(in1);
            for (RequestedLocalProperties ilp2 : this.input2.getInterestingProperties().getLocalProperties()) {
                Channel in2 = template2.clone();
                ilp2.parameterizeChannel(in2);
                block2: for (OperatorDescriptorDual dps : this.getProperties()) {
                    for (OperatorDescriptorDual.LocalPropertiesPair lpp : dps.getPossibleLocalProperties()) {
                        if (!lpp.getProperties1().isMetBy(in1.getLocalProperties()) || !lpp.getProperties2().isMetBy(in2.getLocalProperties()) || !dps.areCoFulfilled(lpp.getProperties1(), lpp.getProperties2(), in1.getLocalProperties(), in2.getLocalProperties())) continue;
                        Channel in1Copy = in1.clone();
                        in1Copy.setRequiredLocalProps(lpp.getProperties1());
                        Channel in2Copy = in2.clone();
                        in2Copy.setRequiredLocalProps(lpp.getProperties2());
                        this.instantiate(dps, in1Copy, in2Copy, broadcastPlanChannels, target, estimator, rgps1, rgps2, ilp1, ilp2);
                        continue block2;
                    }
                }
            }
        }
    }

    protected void instantiate(OperatorDescriptorDual operator, Channel in1, Channel in2, List<Set<? extends NamedChannel>> broadcastPlanChannels, List<PlanNode> target, CostEstimator estimator, RequestedGlobalProperties globPropsReq1, RequestedGlobalProperties globPropsReq2, RequestedLocalProperties locPropsReq1, RequestedLocalProperties locPropsReq2) {
        PlanNode inputSource1 = in1.getSource();
        PlanNode inputSource2 = in2.getSource();
        for (List broadcastChannelsCombination : Sets.cartesianProduct(broadcastPlanChannels)) {
            boolean validCombination = true;
            block1: for (int i = 0; i < broadcastChannelsCombination.size(); ++i) {
                NamedChannel nc = (NamedChannel)broadcastChannelsCombination.get(i);
                PlanNode bcSource = nc.getSource();
                if (!this.areBranchCompatible(bcSource, inputSource1) && !this.areBranchCompatible(bcSource, inputSource2)) {
                    validCombination = false;
                    break;
                }
                for (int k = 0; k < i; ++k) {
                    PlanNode otherBcSource = ((NamedChannel)broadcastChannelsCombination.get(k)).getSource();
                    if (this.areBranchCompatible(bcSource, otherBcSource)) continue;
                    validCombination = false;
                    continue block1;
                }
            }
            if (!validCombination) continue;
            this.placePipelineBreakersIfNecessary(operator.getStrategy(), in1, in2);
            DualInputPlanNode node = operator.instantiate(in1, in2, this);
            node.setBroadcastInputs(broadcastChannelsCombination);
            SemanticProperties semPropsGlobalPropFiltering = this.getSemanticPropertiesForGlobalPropertyFiltering();
            GlobalProperties gp1 = in1.getGlobalProperties().clone().filterBySemanticProperties(semPropsGlobalPropFiltering, 0);
            GlobalProperties gp2 = in2.getGlobalProperties().clone().filterBySemanticProperties(semPropsGlobalPropFiltering, 1);
            GlobalProperties combined = operator.computeGlobalProperties(gp1, gp2);
            SemanticProperties semPropsLocalPropFiltering = this.getSemanticPropertiesForLocalPropertyFiltering();
            LocalProperties lp1 = in1.getLocalProperties().clone().filterBySemanticProperties(semPropsLocalPropFiltering, 0);
            LocalProperties lp2 = in2.getLocalProperties().clone().filterBySemanticProperties(semPropsLocalPropFiltering, 1);
            LocalProperties locals = operator.computeLocalProperties(lp1, lp2);
            node.initProperties(combined, locals);
            node.updatePropertiesWithUniqueSets(this.getUniqueFields());
            target.add(node);
        }
    }

    protected void placePipelineBreakersIfNecessary(DriverStrategy strategy, Channel in1, Channel in2) {
        if (in1.isOnDynamicPath() && in2.isOnDynamicPath() && this.hereJoinedBranches != null && this.hereJoinedBranches.size() > 0) {
            PlanNode.SourceAndDamReport res;
            PlanNode candAtBrancher;
            boolean someDamOnLeftPaths = false;
            boolean damOnAllLeftPaths = true;
            boolean someDamOnRightPaths = false;
            boolean damOnAllRightPaths = true;
            if (strategy.firstDam() == DamBehavior.FULL_DAM || in1.getLocalStrategy().dams() || in1.getTempMode().breaksPipeline()) {
                someDamOnLeftPaths = true;
            } else {
                for (OptimizerNode brancher : this.hereJoinedBranches) {
                    candAtBrancher = in1.getSource().getCandidateAtBranchPoint(brancher);
                    if (candAtBrancher == null) continue;
                    res = in1.getSource().hasDamOnPathDownTo(candAtBrancher);
                    if (res == PlanNode.SourceAndDamReport.NOT_FOUND) {
                        throw new CompilerException("Bug: Tracing dams for deadlock detection is broken.");
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
                        damOnAllLeftPaths = false;
                        continue;
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
                        someDamOnLeftPaths = true;
                        continue;
                    }
                    throw new CompilerException();
                }
            }
            if (strategy.secondDam() == DamBehavior.FULL_DAM || in2.getLocalStrategy().dams() || in2.getTempMode().breaksPipeline()) {
                someDamOnRightPaths = true;
            } else {
                for (OptimizerNode brancher : this.hereJoinedBranches) {
                    candAtBrancher = in2.getSource().getCandidateAtBranchPoint(brancher);
                    if (candAtBrancher == null) continue;
                    res = in2.getSource().hasDamOnPathDownTo(candAtBrancher);
                    if (res == PlanNode.SourceAndDamReport.NOT_FOUND) {
                        throw new CompilerException("Bug: Tracing dams for deadlock detection is broken.");
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE) {
                        damOnAllRightPaths = false;
                        continue;
                    }
                    if (res == PlanNode.SourceAndDamReport.FOUND_SOURCE_AND_DAM) {
                        someDamOnRightPaths = true;
                        continue;
                    }
                    throw new CompilerException();
                }
            }
            if (!(damOnAllLeftPaths && damOnAllRightPaths || !someDamOnLeftPaths && !someDamOnRightPaths)) {
                if (someDamOnLeftPaths && !damOnAllRightPaths) {
                    in2.setTempMode(in2.getTempMode().makePipelineBreaker());
                }
                if (someDamOnRightPaths && !damOnAllLeftPaths) {
                    in1.setTempMode(in1.getTempMode().makePipelineBreaker());
                }
            }
        }
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        this.addClosedBranches(this.getFirstPredecessorNode().closedBranchingNodes);
        this.addClosedBranches(this.getSecondPredecessorNode().closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> result1 = this.getFirstPredecessorNode().getBranchesForParent(this.getFirstIncomingConnection());
        List<OptimizerNode.UnclosedBranchDescriptor> result2 = this.getSecondPredecessorNode().getBranchesForParent(this.getSecondIncomingConnection());
        ArrayList<OptimizerNode.UnclosedBranchDescriptor> inputsMerged = new ArrayList<OptimizerNode.UnclosedBranchDescriptor>();
        this.mergeLists(result1, result2, inputsMerged, true);
        List<OptimizerNode.UnclosedBranchDescriptor> result = this.computeUnclosedBranchStackForBroadcastInputs(inputsMerged);
        this.openBranches = result == null || result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public SemanticProperties getSemanticProperties() {
        return this.getOperator().getSemanticProperties();
    }

    protected SemanticProperties getSemanticPropertiesForLocalPropertyFiltering() {
        return this.getSemanticProperties();
    }

    protected SemanticProperties getSemanticPropertiesForGlobalPropertyFiltering() {
        return this.getSemanticProperties();
    }

    @Override
    public void accept(Visitor<OptimizerNode> visitor) {
        if (visitor.preVisit((Visitable)this)) {
            if (this.input1 == null || this.input2 == null) {
                throw new CompilerException();
            }
            this.getFirstPredecessorNode().accept(visitor);
            this.getSecondPredecessorNode().accept(visitor);
            for (DagConnection connection : this.getBroadcastConnections()) {
                connection.getSource().accept(visitor);
            }
            visitor.postVisit((Visitable)this);
        }
    }
}

