/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.recommendation.swing;

import org.apache.flink.ml.common.param.HasOutputCol;
import org.apache.flink.ml.common.param.HasSeed;
import org.apache.flink.ml.param.DoubleParam;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringParam;
import org.apache.flink.ml.param.WithParams;

public interface SwingParams<T>
extends WithParams<T>,
HasOutputCol<T>,
HasSeed<T> {
    public static final Param<String> USER_COL = new StringParam("userCol", "User column name.", "user", ParamValidators.notNull());
    public static final Param<String> ITEM_COL = new StringParam("itemCol", "Item column name.", "item", ParamValidators.notNull());
    public static final Param<Integer> MAX_USER_NUM_PER_ITEM = new IntParam("maxUserNumPerItem", "The max number of users(purchasers) for each item. If the number of users is greater than this value, then only maxUserNumPerItem users will be sampled and used in the computation of similarity between two items.", Integer.valueOf(1000), ParamValidators.gt((double)0.0));
    public static final Param<Integer> K = new IntParam("k", "The max number of similar items to output for each item.", Integer.valueOf(100), ParamValidators.gt((double)0.0));
    public static final Param<Integer> MIN_USER_BEHAVIOR = new IntParam("minUserBehavior", "The min number of items that a user purchases. If the items purchased by a user is smaller than this value, then this user is filtered out and will not be used in the computation.", Integer.valueOf(10), ParamValidators.gt((double)0.0));
    public static final Param<Integer> MAX_USER_BEHAVIOR = new IntParam("maxUserBehavior", "The max number of items for a user purchases. If the items purchased by a user is greater than this value, then this user is filtered out and will not be used in the computation.", Integer.valueOf(1000), ParamValidators.gt((double)0.0));
    public static final Param<Integer> ALPHA1 = new IntParam("alpha1", "Smooth factor for number of users that have purchased one item. The higher alpha1 is, the less purchasing behavior contributes to the similarity score.", Integer.valueOf(15), ParamValidators.gtEq((double)0.0));
    public static final Param<Integer> ALPHA2 = new IntParam("alpha2", "Smooth factor for number of users that have purchased the two target items. The higher alpha2 is, the less purchasing behavior contributes to the similarity score.", Integer.valueOf(0), ParamValidators.gtEq((double)0.0));
    public static final Param<Double> BETA = new DoubleParam("beta", "Decay factor for number of users that have purchased one item. The higher beta is, the less purchasing behavior contributes to the similarity score.", Double.valueOf(0.3), ParamValidators.gtEq((double)0.0));

    default public String getUserCol() {
        return (String)this.get(USER_COL);
    }

    default public T setUserCol(String value) {
        return (T)this.set(USER_COL, value);
    }

    default public String getItemCol() {
        return (String)this.get(ITEM_COL);
    }

    default public T setItemCol(String value) {
        return (T)this.set(ITEM_COL, value);
    }

    default public int getK() {
        return (Integer)this.get(K);
    }

    default public T setK(Integer value) {
        return (T)this.set(K, value);
    }

    default public int getMaxUserNumPerItem() {
        return (Integer)this.get(MAX_USER_NUM_PER_ITEM);
    }

    default public T setMaxUserNumPerItem(Integer value) {
        return (T)this.set(MAX_USER_NUM_PER_ITEM, value);
    }

    default public int getMinUserBehavior() {
        return (Integer)this.get(MIN_USER_BEHAVIOR);
    }

    default public T setMinUserBehavior(Integer value) {
        return (T)this.set(MIN_USER_BEHAVIOR, value);
    }

    default public int getMaxUserBehavior() {
        return (Integer)this.get(MAX_USER_BEHAVIOR);
    }

    default public T setMaxUserBehavior(Integer value) {
        return (T)this.set(MAX_USER_BEHAVIOR, value);
    }

    default public int getAlpha1() {
        return (Integer)this.get(ALPHA1);
    }

    default public T setAlpha1(Integer value) {
        return (T)this.set(ALPHA1, value);
    }

    default public int getAlpha2() {
        return (Integer)this.get(ALPHA2);
    }

    default public T setAlpha2(Integer value) {
        return (T)this.set(ALPHA2, value);
    }

    default public double getBeta() {
        return (Double)this.get(BETA);
    }

    default public T setBeta(Double value) {
        return (T)this.set(BETA, value);
    }
}

