/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.vectorslicer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.ml.common.param.HasInputCol;
import org.apache.flink.ml.common.param.HasOutputCol;
import org.apache.flink.ml.param.IntArrayParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;

public interface VectorSlicerParams<T>
extends HasInputCol<T>,
HasOutputCol<T> {
    public static final Param<Integer[]> INDICES = new IntArrayParam("indices", "An array of indices to select features from a vector column.", null, VectorSlicerParams.indicesValidator());

    default public Integer[] getIndices() {
        return (Integer[])this.get(INDICES);
    }

    default public T setIndices(Integer ... value) {
        return (T)this.set(INDICES, value);
    }

    public static ParamValidator<Integer[]> indicesValidator() {
        return (ParamValidator & Serializable)indices -> {
            if (indices == null) {
                return false;
            }
            for (Integer ele : indices) {
                if (!(((Number)ele).doubleValue() < 0.0)) continue;
                return false;
            }
            HashSet<Integer> set = new HashSet<Integer>(Arrays.asList(indices));
            if (set.size() != ((Integer[])indices).length) {
                return false;
            }
            return set.size() != 0;
        };
    }
}

