/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.univariatefeatureselector;

import org.apache.flink.ml.common.param.HasLabelCol;
import org.apache.flink.ml.feature.univariatefeatureselector.UnivariateFeatureSelectorModelParams;
import org.apache.flink.ml.param.DoubleParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringParam;

public interface UnivariateFeatureSelectorParams<T>
extends HasLabelCol<T>,
UnivariateFeatureSelectorModelParams<T> {
    public static final String CATEGORICAL = "categorical";
    public static final String CONTINUOUS = "continuous";
    public static final String NUM_TOP_FEATURES = "numTopFeatures";
    public static final String PERCENTILE = "percentile";
    public static final String FPR = "fpr";
    public static final String FDR = "fdr";
    public static final String FWE = "fwe";
    public static final Param<String> FEATURE_TYPE = new StringParam("featureType", "The feature type.", null, ParamValidators.inArray((Object[])new String[]{"categorical", "continuous"}));
    public static final Param<String> LABEL_TYPE = new StringParam("labelType", "The label type.", null, ParamValidators.inArray((Object[])new String[]{"categorical", "continuous"}));
    public static final Param<String> SELECTION_MODE = new StringParam("selectionMode", "The feature selection mode.", "numTopFeatures", ParamValidators.inArray((Object[])new String[]{"numTopFeatures", "percentile", "fpr", "fdr", "fwe"}));
    public static final Param<Double> SELECTION_THRESHOLD = new DoubleParam("selectionThreshold", "The upper bound of the features that selector will select. If not set, it will be replaced with a meaningful value according to different selection modes at runtime. When the mode is numTopFeatures, it will be replaced with 50; when the mode is percentile, it will be replaced with 0.1; otherwise, it will be replaced with 0.05.", null);

    default public String getFeatureType() {
        return (String)this.get(FEATURE_TYPE);
    }

    default public T setFeatureType(String value) {
        return (T)this.set(FEATURE_TYPE, value);
    }

    default public String getLabelType() {
        return (String)this.get(LABEL_TYPE);
    }

    default public T setLabelType(String value) {
        return (T)this.set(LABEL_TYPE, value);
    }

    default public String getSelectionMode() {
        return (String)this.get(SELECTION_MODE);
    }

    default public T setSelectionMode(String value) {
        return (T)this.set(SELECTION_MODE, value);
    }

    default public Double getSelectionThreshold() {
        return (Double)this.get(SELECTION_THRESHOLD);
    }

    default public T setSelectionThreshold(double value) {
        return (T)this.set(SELECTION_THRESHOLD, value);
    }
}

