/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stringindexer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.stringindexer.IndexToStringModelParams;
import org.apache.flink.ml.feature.stringindexer.StringIndexerModelData;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class IndexToStringModel
implements Model<IndexToStringModel>,
IndexToStringModelParams<IndexToStringModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public IndexToStringModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(StringIndexerModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new StringIndexerModelData.ModelDataEncoder());
    }

    public static IndexToStringModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        IndexToStringModel model = (IndexToStringModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new StringIndexerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public IndexToStringModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String[] inputCols = this.getInputCols();
        Object[] outputCols = this.getOutputCols();
        Preconditions.checkArgument((inputCols.length == outputCols.length ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)this.modelDataTable).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        Object[] outputTypes = new TypeInformation[outputCols.length];
        Arrays.fill(outputTypes, BasicTypeInfo.STRING_TYPE_INFO);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])outputTypes), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])outputCols));
        String broadcastModelKey = "broadcastModelKey";
        DataStream<StringIndexerModelData> modelDataStream = StringIndexerModelData.getModelDataStream(this.modelDataTable);
        DataStream result = BroadcastUtils.withBroadcastStream(Collections.singletonList(tEnv.toDataStream(inputs[0])), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.flatMap((FlatMapFunction)new Index2String("broadcastModelKey", inputCols), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(result)};
    }

    private static class Index2String
    extends RichFlatMapFunction<Row, Row> {
        private String[][] stringArrays;
        private final String broadcastModelKey;
        private final String[] inputCols;

        public Index2String(String broadcastModelKey, String[] inputCols) {
            this.broadcastModelKey = broadcastModelKey;
            this.inputCols = inputCols;
        }

        public void flatMap(Row input, Collector<Row> out) {
            if (this.stringArrays == null) {
                StringIndexerModelData modelData = (StringIndexerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.stringArrays = modelData.stringArrays;
            }
            Row outputStrings = new Row(this.inputCols.length);
            for (int i = 0; i < this.inputCols.length; ++i) {
                int stringId = (Integer)input.getField(this.inputCols[i]);
                if (stringId >= this.stringArrays[i].length || stringId < 0) {
                    throw new RuntimeException("The input contains unseen index: " + stringId + ".");
                }
                outputStrings.setField(i, (Object)this.stringArrays[i][stringId]);
            }
            out.collect((Object)Row.join((Row)input, (Row[])new Row[]{outputStrings}));
        }
    }
}

