/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stopwordsremover;

import org.apache.flink.ml.common.param.HasInputCols;
import org.apache.flink.ml.common.param.HasOutputCols;
import org.apache.flink.ml.feature.stopwordsremover.StopWordsRemoverUtils;
import org.apache.flink.ml.param.BooleanParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringArrayParam;
import org.apache.flink.ml.param.StringParam;

public interface StopWordsRemoverParams<T>
extends HasInputCols<T>,
HasOutputCols<T> {
    public static final Param<String[]> STOP_WORDS = new StringArrayParam("stopWords", "The words to be filtered out.", StopWordsRemoverUtils.loadDefaultStopWords("english"), ParamValidators.nonEmptyArray());
    public static final Param<Boolean> CASE_SENSITIVE = new BooleanParam("caseSensitive", "Whether to do a case-sensitive comparison over the stop words.", Boolean.valueOf(false));
    public static final Param<String> LOCALE = new StringParam("locale", "Locale of the input for case insensitive matching. Ignored when caseSensitive is true.", StopWordsRemoverUtils.getDefaultOrUS(), ParamValidators.inArray((Object[])StopWordsRemoverUtils.getAvailableLocales().toArray(new String[0])));

    default public String[] getStopWords() {
        return (String[])this.get(STOP_WORDS);
    }

    default public T setStopWords(String[] value) {
        return (T)this.set(STOP_WORDS, value);
    }

    default public boolean getCaseSensitive() {
        return (Boolean)this.get(CASE_SENSITIVE);
    }

    default public T setCaseSensitive(boolean value) {
        return (T)this.set(CASE_SENSITIVE, value);
    }

    default public String getLocale() {
        return (String)this.get(LOCALE);
    }

    default public T setLocale(String value) {
        return (T)this.set(LOCALE, value);
    }
}

