/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.stopwordsremover;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.feature.stopwordsremover.StopWordsRemoverParams;
import org.apache.flink.ml.feature.stopwordsremover.StopWordsRemoverUtils;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.util.Preconditions;

public class StopWordsRemover
implements Transformer<StopWordsRemover>,
StopWordsRemoverParams<StopWordsRemover> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public StopWordsRemover() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getInputCols().length == this.getOutputCols().length ? 1 : 0) != 0);
        String[] inputCols = this.getInputCols();
        String[] outputCols = this.getOutputCols();
        RemoveStopWordsFunction function = new RemoveStopWordsFunction(new HashSet<String>(Arrays.asList(this.getStopWords())), new Locale(this.getLocale()), this.getCaseSensitive());
        Expression[] expressions = new Expression[inputCols.length + 1];
        expressions[0] = Expressions.$((String)"*");
        for (int i = 0; i < inputCols.length; ++i) {
            expressions[i + 1] = (Expression)Expressions.call((UserDefinedFunction)function, (Object[])new Object[]{Expressions.$((String)inputCols[i])}).as(outputCols[i], new String[0]);
        }
        Table output = inputs[0].select(expressions);
        return new Table[]{output};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static StopWordsRemover load(StreamTableEnvironment env, String path) throws IOException {
        return (StopWordsRemover)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public static String[] loadDefaultStopWords(String language) {
        return StopWordsRemoverUtils.loadDefaultStopWords(language);
    }

    public static String getDefaultOrUS() {
        return StopWordsRemoverUtils.getDefaultOrUS();
    }

    public static Set<String> getAvailableLocales() {
        return StopWordsRemoverUtils.getAvailableLocales();
    }

    public static class RemoveStopWordsFunction
    extends ScalarFunction {
        private final Set<String> stopWords;
        private final Locale locale;
        private final boolean caseSensitive;
        private transient Predicate<String> predicate;

        public RemoveStopWordsFunction(Set<String> stopWords, Locale locale, boolean caseSensitive) {
            this.locale = locale;
            this.caseSensitive = caseSensitive;
            this.stopWords = caseSensitive ? stopWords : stopWords.stream().map(x -> x == null ? null : x.toLowerCase(locale)).collect(Collectors.toSet());
        }

        public void open(FunctionContext context) throws Exception {
            super.open(context);
            this.predicate = this.caseSensitive ? x -> !this.stopWords.contains(x) : x -> {
                if (x != null) {
                    x = x.toLowerCase(this.locale);
                }
                return !this.stopWords.contains(x);
            };
        }

        public String[] eval(String[] input) {
            return (String[])Arrays.stream(input).filter(this.predicate).toArray(String[]::new);
        }
    }
}

