/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.polynomialexpansion;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.polynomialexpansion.PolynomialExpansionParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class PolynomialExpansion
implements Transformer<PolynomialExpansion>,
PolynomialExpansionParams<PolynomialExpansion> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public PolynomialExpansion() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new PolynomialExpansionFunction(this.getDegree(), this.getInputCol()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static PolynomialExpansion load(StreamTableEnvironment env, String path) throws IOException {
        return (PolynomialExpansion)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class PolynomialExpansionFunction
    implements MapFunction<Row, Row> {
        private final int degree;
        private final String inputCol;

        public PolynomialExpansionFunction(int degree, String inputCol) {
            this.degree = degree;
            this.inputCol = inputCol;
        }

        public Row map(Row row) throws Exception {
            DenseVector outputVec;
            Vector vec = (Vector)row.getFieldAs(this.inputCol);
            if (vec == null) {
                throw new IllegalArgumentException("The vector must not be null.");
            }
            if (vec instanceof DenseVector) {
                int size = vec.size();
                double[] retVals = new double[PolynomialExpansionFunction.getResultVectorSize(size, this.degree) - 1];
                PolynomialExpansionFunction.expandDenseVector(((DenseVector)vec).values, size - 1, this.degree, 1.0, retVals, -1);
                outputVec = new DenseVector(retVals);
            } else if (vec instanceof SparseVector) {
                SparseVector sparseVec = (SparseVector)vec;
                int[] indices = sparseVec.indices;
                double[] values = sparseVec.values;
                int size = sparseVec.size();
                int nnz = sparseVec.values.length;
                int nnzPolySize = PolynomialExpansionFunction.getResultVectorSize(nnz, this.degree);
                Tuple2 polyIndices = Tuple2.of((Object)0, (Object)new int[nnzPolySize - 1]);
                Tuple2 polyValues = Tuple2.of((Object)0, (Object)new double[nnzPolySize - 1]);
                PolynomialExpansionFunction.expandSparseVector(indices, values, nnz - 1, size - 1, this.degree, 1.0, (Tuple2<Integer, int[]>)polyIndices, (Tuple2<Integer, double[]>)polyValues, -1);
                outputVec = new SparseVector(PolynomialExpansionFunction.getResultVectorSize(size, this.degree) - 1, (int[])polyIndices.f1, (double[])polyValues.f1);
            } else {
                throw new UnsupportedOperationException("Only supports DenseVector or SparseVector.");
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }

        private static int getResultVectorSize(int num, int degree) {
            if (num == 0) {
                return 1;
            }
            if (num == 1 || degree == 1) {
                return num + degree;
            }
            if (degree > num) {
                return PolynomialExpansionFunction.getResultVectorSize(degree, num);
            }
            long res = 1L;
            int i = num + 1;
            if (num + degree < 61) {
                for (int j = 1; j <= degree; ++j) {
                    res = res * (long)i / (long)j;
                    ++i;
                }
            } else {
                for (int j = 1; j <= degree; ++j) {
                    int depth = ArithmeticUtils.gcd((int)i, (int)j);
                    res = ArithmeticUtils.mulAndCheck((long)(res / (long)(j / depth)), (long)(i / depth));
                    ++i;
                }
            }
            if (res > Integer.MAX_VALUE) {
                throw new RuntimeException("The expended polynomial size is too large.");
            }
            return (int)res;
        }

        private static int expandDenseVector(double[] values, int lastIdx, int degree, double factor, double[] retValues, int curPolyIdx) {
            if (!Double.valueOf(factor).equals(0.0)) {
                if (degree == 0 || lastIdx < 0) {
                    if (curPolyIdx >= 0) {
                        retValues[curPolyIdx] = factor;
                    }
                } else {
                    double v = values[lastIdx];
                    int newLastIdx = lastIdx - 1;
                    double alpha = factor;
                    int i = 0;
                    int curStart = curPolyIdx;
                    while (i <= degree && Math.abs(alpha) > 0.0) {
                        curStart = PolynomialExpansionFunction.expandDenseVector(values, newLastIdx, degree - i, alpha, retValues, curStart);
                        ++i;
                        alpha *= v;
                    }
                }
            }
            return curPolyIdx + PolynomialExpansionFunction.getResultVectorSize(lastIdx + 1, degree);
        }

        private static int expandSparseVector(int[] indices, double[] values, int lastIdx, int lastFeatureIdx, int degree, double factor, Tuple2<Integer, int[]> polyIndices, Tuple2<Integer, double[]> polyValues, int curPolyIdx) {
            if (!Double.valueOf(factor).equals(0.0)) {
                if (degree == 0 || lastIdx < 0) {
                    if (curPolyIdx >= 0) {
                        ((int[])polyIndices.f1)[((Integer)polyIndices.f0).intValue()] = curPolyIdx;
                        ((double[])polyValues.f1)[((Integer)polyValues.f0).intValue()] = factor;
                        Tuple2<Integer, int[]> tuple2 = polyIndices;
                        Integer n = (Integer)tuple2.f0;
                        tuple2.f0 = (Integer)tuple2.f0 + 1;
                        Integer n2 = tuple2.f0;
                        tuple2 = polyValues;
                        n = (Integer)tuple2.f0;
                        tuple2.f0 = (Integer)tuple2.f0 + 1;
                        n2 = tuple2.f0;
                    }
                } else {
                    double v = values[lastIdx];
                    int lastIdx1 = lastIdx - 1;
                    int lastFeatureIdx1 = indices[lastIdx] - 1;
                    double alpha = factor;
                    int curStart = curPolyIdx;
                    int i = 0;
                    while (i <= degree && Math.abs(alpha) > 0.0) {
                        curStart = PolynomialExpansionFunction.expandSparseVector(indices, values, lastIdx1, lastFeatureIdx1, degree - i, alpha, polyIndices, polyValues, curStart);
                        ++i;
                        alpha *= v;
                    }
                }
            }
            return curPolyIdx + PolynomialExpansionFunction.getResultVectorSize(lastFeatureIdx + 1, degree);
        }
    }
}

