/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.normalizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.normalizer.NormalizerParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class Normalizer
implements Transformer<Normalizer>,
NormalizerParams<Normalizer> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Normalizer() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new NormalizationFunction(this.getP(), this.getInputCol()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static Normalizer load(StreamTableEnvironment env, String path) throws IOException {
        return (Normalizer)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class NormalizationFunction
    implements MapFunction<Row, Row> {
        private final double p;
        private final String inputCol;

        public NormalizationFunction(double p, String inputCol) {
            this.p = p;
            this.inputCol = inputCol;
        }

        public Row map(Row row) throws Exception {
            Vector inputVec = (Vector)row.getFieldAs(this.inputCol);
            Vector outputVec = inputVec.clone();
            double norm = BLAS.norm((Vector)inputVec, (double)this.p);
            BLAS.scal((double)(1.0 / norm), (Vector)outputVec);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

