/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.minmaxscaler;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.datastream.DataStreamUtils;
import org.apache.flink.ml.feature.minmaxscaler.MinMaxScalerModel;
import org.apache.flink.ml.feature.minmaxscaler.MinMaxScalerModelData;
import org.apache.flink.ml.feature.minmaxscaler.MinMaxScalerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class MinMaxScaler
implements Estimator<MinMaxScaler, MinMaxScalerModel>,
MinMaxScalerParams<MinMaxScaler> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public MinMaxScaler() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public MinMaxScalerModel fit(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String inputCol = this.getInputCol();
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        SingleOutputStreamOperator inputData = tEnv.toDataStream(inputs[0]).map((MapFunction & Serializable)value -> ((Vector)value.getField(inputCol)).toDense());
        SingleOutputStreamOperator minMaxValues = inputData.transform("reduceInEachPartition", inputData.getType(), (OneInputStreamOperator)new MinMaxReduceFunctionOperator()).transform("reduceInFinalPartition", inputData.getType(), (OneInputStreamOperator)new MinMaxReduceFunctionOperator()).setParallelism(1);
        DataStream modelData = DataStreamUtils.mapPartition((DataStream)minMaxValues, (MapPartitionFunction)new RichMapPartitionFunction<DenseVector, MinMaxScalerModelData>(){

            public void mapPartition(Iterable<DenseVector> values, Collector<MinMaxScalerModelData> out) {
                Iterator<DenseVector> iter = values.iterator();
                DenseVector minVector = iter.next();
                DenseVector maxVector = iter.next();
                out.collect((Object)new MinMaxScalerModelData(minVector, maxVector));
            }
        });
        MinMaxScalerModel model = new MinMaxScalerModel().setModelData(tEnv.fromDataStream(modelData));
        ParamUtils.updateExistingParams((WithParams)model, this.getParamMap());
        return model;
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static MinMaxScaler load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (MinMaxScaler)ReadWriteUtils.loadStageParam((String)path);
    }

    public static class MinMaxReduceFunctionOperator
    extends AbstractStreamOperator<DenseVector>
    implements OneInputStreamOperator<DenseVector, DenseVector>,
    BoundedOneInput {
        private ListState<DenseVector> minState;
        private ListState<DenseVector> maxState;
        private DenseVector minVector;
        private DenseVector maxVector;

        public void endInput() {
            if (this.minVector != null) {
                this.output.collect((Object)new StreamRecord((Object)this.minVector));
                this.output.collect((Object)new StreamRecord((Object)this.maxVector));
            }
        }

        public void processElement(StreamRecord<DenseVector> streamRecord) {
            DenseVector currentValue = (DenseVector)streamRecord.getValue();
            if (this.minVector == null) {
                int vecSize = currentValue.size();
                this.minVector = new DenseVector(vecSize);
                this.maxVector = new DenseVector(vecSize);
                System.arraycopy(currentValue.values, 0, this.minVector.values, 0, vecSize);
                System.arraycopy(currentValue.values, 0, this.maxVector.values, 0, vecSize);
            } else {
                Preconditions.checkArgument((currentValue.size() == this.maxVector.size() ? 1 : 0) != 0, (Object)"CurrentValue should has same size with maxVector.");
                for (int i = 0; i < currentValue.size(); ++i) {
                    this.minVector.values[i] = Math.min(this.minVector.values[i], currentValue.values[i]);
                    this.maxVector.values[i] = Math.max(this.maxVector.values[i], currentValue.values[i]);
                }
            }
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.minState = context.getOperatorStateStore().getListState(new ListStateDescriptor("minState", TypeInformation.of(DenseVector.class)));
            this.maxState = context.getOperatorStateStore().getListState(new ListStateDescriptor("maxState", TypeInformation.of(DenseVector.class)));
            OperatorStateUtils.getUniqueElement(this.minState, (String)"minState").ifPresent(x -> {
                this.minVector = x;
            });
            OperatorStateUtils.getUniqueElement(this.maxState, (String)"maxState").ifPresent(x -> {
                this.maxVector = x;
            });
        }

        public void snapshotState(StateSnapshotContext context) throws Exception {
            super.snapshotState(context);
            this.minState.clear();
            this.maxState.clear();
            if (this.minVector != null) {
                this.minState.add((Object)this.minVector);
                this.maxState.add((Object)this.maxVector);
            }
        }
    }
}

