/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.maxabsscaler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.maxabsscaler.MaxAbsScalerModelData;
import org.apache.flink.ml.feature.maxabsscaler.MaxAbsScalerParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class MaxAbsScalerModel
implements Model<MaxAbsScalerModel>,
MaxAbsScalerParams<MaxAbsScalerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public MaxAbsScalerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public MaxAbsScalerModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream data = tEnv.toDataStream(inputs[0]);
        DataStream<MaxAbsScalerModelData> maxAbsScalerModel = MaxAbsScalerModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(data), Collections.singletonMap("broadcastModelKey", maxAbsScalerModel), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new PredictOutputFunction("broadcastModelKey", this.getInputCol()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(MaxAbsScalerModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new MaxAbsScalerModelData.ModelDataEncoder());
    }

    public static MaxAbsScalerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        MaxAbsScalerModel model = (MaxAbsScalerModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new MaxAbsScalerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private DenseVector scaleVector;

        public PredictOutputFunction(String broadcastKey, String inputCol) {
            this.broadcastKey = broadcastKey;
            this.inputCol = inputCol;
        }

        public Row map(Row row) {
            if (this.scaleVector == null) {
                MaxAbsScalerModelData maxAbsScalerModelData = (MaxAbsScalerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.scaleVector = maxAbsScalerModelData.maxVector;
                for (int i = 0; i < this.scaleVector.size(); ++i) {
                    this.scaleVector.values[i] = this.scaleVector.values[i] != 0.0 ? 1.0 / this.scaleVector.values[i] : 1.0;
                }
            }
            Vector inputVec = (Vector)row.getFieldAs(this.inputCol);
            Vector outputVec = inputVec.clone();
            BLAS.hDot((Vector)this.scaleVector, (Vector)outputVec);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

