/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.lsh;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.datastream.DataStreamUtils;
import org.apache.flink.ml.feature.lsh.LSHModel;
import org.apache.flink.ml.feature.lsh.LSHParams;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

abstract class LSH<E extends Estimator<E, M>, M extends LSHModel<M>>
implements Estimator<E, M>,
LSHParams<E> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public LSH() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public M fit(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream<Integer> inputDim = LSH.getVectorSize((DataStream<Row>)tEnv.toDataStream(inputs[0]), this.getInputCol());
        return this.createModel(inputDim, tEnv);
    }

    protected abstract M createModel(DataStream<Integer> var1, StreamTableEnvironment var2);

    private static DataStream<Integer> getVectorSize(DataStream<Row> input, String vectorCol) {
        SingleOutputStreamOperator vectorSizes = input.map((MapFunction & Serializable)d -> {
            Vector vec = (Vector)d.getFieldAs(vectorCol);
            return vec.size();
        });
        return DataStreamUtils.reduce((DataStream)vectorSizes, (ReduceFunction & Serializable)(s0, s1) -> {
            Preconditions.checkState((boolean)s0.equals(s1), (String)"Vector sizes are not the same: %d %d.", (Object[])new Object[]{s0, s1});
            return s0;
        });
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }
}

