/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.kbinsdiscretizer;

import org.apache.flink.ml.feature.kbinsdiscretizer.KBinsDiscretizerModelParams;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringParam;

public interface KBinsDiscretizerParams<T>
extends KBinsDiscretizerModelParams<T> {
    public static final String UNIFORM = "uniform";
    public static final String QUANTILE = "quantile";
    public static final String KMEANS = "kmeans";
    public static final Param<String> STRATEGY = new StringParam("strategy", "Strategy used to define the width of the bin.", "quantile", ParamValidators.inArray((Object[])new String[]{"uniform", "quantile", "kmeans"}));
    public static final Param<Integer> NUM_BINS = new IntParam("numBins", "Number of bins to produce.", Integer.valueOf(5), ParamValidators.gtEq((double)2.0));
    public static final Param<Integer> SUB_SAMPLES = new IntParam("subSamples", "Maximum number of samples used to fit the model.", Integer.valueOf(200000), ParamValidators.gtEq((double)2.0));

    default public String getStrategy() {
        return (String)this.get(STRATEGY);
    }

    default public T setStrategy(String value) {
        return (T)this.set(STRATEGY, value);
    }

    default public int getNumBins() {
        return (Integer)this.get(NUM_BINS);
    }

    default public T setNumBins(int value) {
        return (T)this.set(NUM_BINS, value);
    }

    default public int getSubSamples() {
        return (Integer)this.get(SUB_SAMPLES);
    }

    default public T setSubSamples(Integer value) {
        return (T)this.set(SUB_SAMPLES, value);
    }
}

