/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.kbinsdiscretizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.kbinsdiscretizer.KBinsDiscretizerModelData;
import org.apache.flink.ml.feature.kbinsdiscretizer.KBinsDiscretizerModelParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class KBinsDiscretizerModel
implements Model<KBinsDiscretizerModel>,
KBinsDiscretizerModelParams<KBinsDiscretizerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public KBinsDiscretizerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputData = tEnv.toDataStream(inputs[0]);
        DataStream<KBinsDiscretizerModelData> modelData = KBinsDiscretizerModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{TypeInformation.of(DenseVector.class)}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputData), Collections.singletonMap("broadcastModelKey", modelData), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new FindBinFunction(this.getInputCol(), "broadcastModelKey"), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    public KBinsDiscretizerModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(KBinsDiscretizerModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new KBinsDiscretizerModelData.ModelDataEncoder());
    }

    public static KBinsDiscretizerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        KBinsDiscretizerModel model = (KBinsDiscretizerModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new KBinsDiscretizerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    private static class FindBinFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private double[][] binEdges;

        public FindBinFunction(String inputCol, String broadcastKey) {
            this.inputCol = inputCol;
            this.broadcastKey = broadcastKey;
        }

        public Row map(Row row) {
            if (this.binEdges == null) {
                KBinsDiscretizerModelData modelData = (KBinsDiscretizerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.binEdges = modelData.binEdges;
            }
            DenseVector inputVec = ((Vector)row.getField(this.inputCol)).toDense();
            DenseVector outputVec = inputVec.clone();
            for (int i = 0; i < inputVec.size(); ++i) {
                double targetFeature = inputVec.get(i);
                int index = Arrays.binarySearch(this.binEdges[i], targetFeature);
                if (index < 0) {
                    index = -index - 1;
                    --index;
                }
                index = Math.min(index, this.binEdges[i].length - 2);
                index = Math.max(index, 0);
                outputVec.set(i, (double)index);
            }
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

