/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.idf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.idf.IDFModelData;
import org.apache.flink.ml.feature.idf.IDFModelParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class IDFModel
implements Model<IDFModel>,
IDFModelParams<IDFModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public IDFModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream data = tEnv.toDataStream(inputs[0]);
        DataStream<IDFModelData> idfModelData = IDFModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        ResolvedSchema schema = inputs[0].getResolvedSchema();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)schema);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{TableUtils.getTypeInfoByName((ResolvedSchema)schema, (String)this.getInputCol())}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(data), Collections.singletonMap("broadcastModelKey", idfModelData), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new ComputeTfIdfFunction("broadcastModelKey", this.getInputCol()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    public IDFModel setModelData(Table ... inputs) {
        this.modelDataTable = inputs[0];
        return this;
    }

    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
        ReadWriteUtils.saveModelData(IDFModelData.getModelDataStream(this.modelDataTable), (String)path, (Encoder)new IDFModelData.ModelDataEncoder());
    }

    public static IDFModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        IDFModel model = (IDFModel)ReadWriteUtils.loadStageParam((String)path);
        Table modelDataTable = ReadWriteUtils.loadModelData((StreamTableEnvironment)tEnv, (String)path, (SimpleStreamFormat)new IDFModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    private static class ComputeTfIdfFunction
    extends RichMapFunction<Row, Row> {
        private final String inputCol;
        private final String broadcastKey;
        private DenseVector idf;

        public ComputeTfIdfFunction(String broadcastKey, String inputCol) {
            this.broadcastKey = broadcastKey;
            this.inputCol = inputCol;
        }

        public Row map(Row row) {
            if (this.idf == null) {
                IDFModelData idfModelDataData = (IDFModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.idf = idfModelDataData.idf;
            }
            Vector outputVec = ((Vector)Objects.requireNonNull(row.getField(this.inputCol))).clone();
            BLAS.hDot((Vector)this.idf, (Vector)outputVec);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

