/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.elementwiseproduct;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.elementwiseproduct.ElementwiseProductParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class ElementwiseProduct
implements Transformer<ElementwiseProduct>,
ElementwiseProductParams<ElementwiseProduct> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public ElementwiseProduct() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new ElementwiseProductFunction(this.getInputCol(), this.getScalingVec()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static ElementwiseProduct load(StreamTableEnvironment env, String path) throws IOException {
        return (ElementwiseProduct)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class ElementwiseProductFunction
    implements MapFunction<Row, Row> {
        private final String inputCol;
        private final Vector scalingVec;

        public ElementwiseProductFunction(String inputCol, Vector scalingVec) {
            this.inputCol = inputCol;
            this.scalingVec = scalingVec;
        }

        public Row map(Row value) {
            Vector inputVec = (Vector)value.getFieldAs(this.inputCol);
            if (inputVec != null) {
                if (this.scalingVec.size() != inputVec.size()) {
                    throw new IllegalArgumentException("The scaling vector size is " + this.scalingVec.size() + ", which is not equal input vector size(" + inputVec.size() + ").");
                }
                Vector retVec = inputVec.clone();
                BLAS.hDot((Vector)this.scalingVec, (Vector)retVec);
                return Row.join((Row)value, (Row[])new Row[]{Row.of((Object[])new Object[]{retVec})});
            }
            return Row.join((Row)value, (Row[])new Row[]{Row.of((Object[])new Object[]{null})});
        }
    }
}

