/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.dct;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.dct.DCTParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.jtransforms.dct.DoubleDCT_1D;

public class DCT
implements Transformer<DCT>,
DCTParams<DCT> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public DCT() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo((ResolvedSchema)inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{DenseVectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator stream = tEnv.toDataStream(inputs[0]).map((MapFunction)new DCTFunction(this.getInputCol(), this.getInverse()), (TypeInformation)outputTypeInfo);
        return new Table[]{tEnv.fromDataStream((DataStream)stream)};
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static DCT load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (DCT)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class DCTFunction
    implements MapFunction<Row, Row> {
        private final String inputCol;
        private final boolean isInverse;
        private BiConsumer<double[], Boolean> dctTransformer;
        private long previousVectorSize;

        private DCTFunction(String inputCol, boolean isInverse) {
            this.inputCol = inputCol;
            this.isInverse = isInverse;
            this.dctTransformer = null;
            this.previousVectorSize = -1L;
        }

        public Row map(Row row) throws Exception {
            Vector vector = (Vector)row.getFieldAs(this.inputCol);
            if (this.previousVectorSize != (long)vector.size()) {
                this.dctTransformer = this.isInverse ? new DoubleDCT_1D(vector.size())::inverse : new DoubleDCT_1D(vector.size())::forward;
                this.previousVectorSize = vector.size();
            }
            double[] array = vector.toArray();
            if (vector instanceof DenseVector) {
                array = (double[])array.clone();
            }
            this.dctTransformer.accept(array, true);
            return Row.join((Row)row, (Row[])new Row[]{Row.of((Object[])new Object[]{Vectors.dense((double[])array)})});
        }
    }
}

