/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.countvectorizer;

import org.apache.flink.ml.feature.countvectorizer.CountVectorizerModelParams;
import org.apache.flink.ml.param.DoubleParam;
import org.apache.flink.ml.param.IntParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;

public interface CountVectorizerParams<T>
extends CountVectorizerModelParams<T> {
    public static final Param<Integer> VOCABULARY_SIZE = new IntParam("vocabularySize", "Max size of the vocabulary. CountVectorizer will build a vocabularythat only considers the top vocabulary size terms ordered by term frequency across the corpus.", Integer.valueOf(262144), ParamValidators.gt((double)0.0));
    public static final Param<Double> MIN_DF = new DoubleParam("minDF", "Specifies the minimum number of different documents a term mustappear in to be included in the vocabulary. If this is an integer >= 1,this specifies the number of documents the term must appear in;if this is a double in [0,1), then this specifies the fraction of documents.", Double.valueOf(1.0), ParamValidators.gtEq((double)0.0));
    public static final Param<Double> MAX_DF = new DoubleParam("maxDF", "Specifies the maximum number of different documents a term could appear in to be included in the vocabulary. A term that appears more than the threshold will be ignored. If this is an integer >= 1, this specifies the maximum number of documents the term could appear in; if this is a double in [0,1), then this specifies the maximum fraction of documents the term could appear in.", Double.valueOf(9.223372036854776E18), ParamValidators.gtEq((double)0.0));

    default public int getVocabularySize() {
        return (Integer)this.get(VOCABULARY_SIZE);
    }

    default public T setVocabularySize(int value) {
        return (T)this.set(VOCABULARY_SIZE, value);
    }

    default public double getMinDF() {
        return (Double)this.get(MIN_DF);
    }

    default public T setMinDF(double value) {
        return (T)this.set(MIN_DF, value);
    }

    default public double getMaxDF() {
        return (Double)this.get(MAX_DF);
    }

    default public T setMaxDF(double value) {
        return (T)this.set(MAX_DF, value);
    }
}

