/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.bucketizer;

import org.apache.flink.ml.common.param.HasHandleInvalid;
import org.apache.flink.ml.common.param.HasInputCols;
import org.apache.flink.ml.common.param.HasOutputCols;
import org.apache.flink.ml.param.DoubleArrayArrayParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;

public interface BucketizerParams<T>
extends HasInputCols<T>,
HasOutputCols<T>,
HasHandleInvalid<T> {
    public static final DoubleArrayArrayParam SPLITS_ARRAY = new DoubleArrayArrayParam("splitsArray", "Array of split points for mapping continuous features into buckets.", null, (ParamValidator)new SplitsArrayValidator());

    default public Double[][] getSplitsArray() {
        return (Double[][])this.get((Param)SPLITS_ARRAY);
    }

    default public T setSplitsArray(Double[][] value) {
        this.set((Param)SPLITS_ARRAY, value);
        return (T)this;
    }

    public static class SplitsArrayValidator
    implements ParamValidator<Double[][]> {
        public boolean validate(Double[][] splitsArray) {
            if (null == splitsArray || splitsArray.length == 0) {
                return false;
            }
            for (Double[] splits : splitsArray) {
                if (splits.length < 3) {
                    return false;
                }
                for (int j = 1; j < splits.length; ++j) {
                    if (!(splits[j] <= splits[j - 1])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

