/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.evaluation.binaryclassification;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.ml.api.AlgoOperator;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.DataStreamUtils;
import org.apache.flink.ml.evaluation.binaryclassification.BinaryClassificationEvaluatorParams;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.WithParams;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryClassificationEvaluator
implements AlgoOperator<BinaryClassificationEvaluator>,
BinaryClassificationEvaluatorParams<BinaryClassificationEvaluator> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private static final int NUM_SAMPLE_FOR_RANGE_PARTITION = 100;
    private static final Logger LOG = LoggerFactory.getLogger(BinaryClassificationEvaluator.class);

    public BinaryClassificationEvaluator() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, (WithParams)this);
    }

    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        SingleOutputStreamOperator evalData = tEnv.toDataStream(inputs[0]).map((MapFunction)new ParseSample(this.getLabelCol(), this.getRawPredictionCol(), this.getWeightCol()));
        String boundaryRangeKey = "boundaryRange";
        String partitionSummariesKey = "partitionSummaries";
        DataStream evalDataWithTaskId = BroadcastUtils.withBroadcastStream(Collections.singletonList(evalData), Collections.singletonMap("boundaryRange", BinaryClassificationEvaluator.getBoundaryRange((DataStream<Tuple3<Double, Boolean, Double>>)evalData)), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new AppendTaskId("boundaryRange"));
        });
        evalDataWithTaskId = evalDataWithTaskId.partitionCustom((Partitioner & Serializable)(chunkId, numPartitions) -> chunkId, (KeySelector & Serializable)x -> (Integer)x.f3);
        DataStream sortEvalData = DataStreamUtils.mapPartition((DataStream)evalDataWithTaskId, (MapPartitionFunction)new MapPartitionFunction<Tuple4<Double, Boolean, Double, Integer>, Tuple3<Double, Boolean, Double>>(){

            public void mapPartition(Iterable<Tuple4<Double, Boolean, Double, Integer>> values, Collector<Tuple3<Double, Boolean, Double>> out) {
                LinkedList<Tuple3> bufferedData = new LinkedList<Tuple3>();
                for (Tuple4<Double, Boolean, Double, Integer> t4 : values) {
                    bufferedData.add(Tuple3.of((Object)((Double)t4.f0), (Object)((Boolean)t4.f1), (Object)((Double)t4.f2)));
                }
                bufferedData.sort(Comparator.comparingDouble(o -> -((Double)o.f0).doubleValue()));
                for (Tuple3 dataPoint : bufferedData) {
                    out.collect((Object)dataPoint);
                }
            }
        });
        SingleOutputStreamOperator partitionSummaries = sortEvalData.transform("reduceInEachPartition", TypeInformation.of(BinarySummary.class), (OneInputStreamOperator)new PartitionSummaryOperator());
        DataStream dataWithOrders = BroadcastUtils.withBroadcastStream(Collections.singletonList(sortEvalData), Collections.singletonMap("partitionSummaries", partitionSummaries), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.flatMap((FlatMapFunction)new CalcSampleOrders("partitionSummaries"));
        });
        SingleOutputStreamOperator localAreaUnderROCVariable = dataWithOrders.transform("AccumulateMultiScore", TypeInformation.of(double[].class), (OneInputStreamOperator)new AccumulateMultiScoreOperator());
        DataStream middleAreaUnderROC = DataStreamUtils.reduce((DataStream)localAreaUnderROCVariable, (ReduceFunction & Serializable)(t1, t2) -> {
            t2[0] = t2[0] + t1[0];
            t2[1] = t2[1] + t1[1];
            t2[2] = t2[2] + t1[2];
            return t2;
        });
        SingleOutputStreamOperator areaUnderROC = middleAreaUnderROC.map((MapFunction & Serializable)value -> {
            if (value[1] > 0.0 && value[2] > 0.0) {
                return (value[0] - 1.0 * value[1] * (value[1] + 1.0) / 2.0) / (value[1] * value[2]);
            }
            return Double.NaN;
        });
        HashMap<String, SingleOutputStreamOperator> broadcastMap = new HashMap<String, SingleOutputStreamOperator>();
        broadcastMap.put("partitionSummaries", partitionSummaries);
        broadcastMap.put("areaUnderROC", areaUnderROC);
        DataStream localMetrics = BroadcastUtils.withBroadcastStream(Collections.singletonList(sortEvalData), broadcastMap, inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return DataStreamUtils.mapPartition((DataStream)input, (MapPartitionFunction)new CalcBinaryMetrics("partitionSummaries"));
        });
        DataStream metrics = DataStreamUtils.mapPartition((DataStream)localMetrics, (MapPartitionFunction)new MergeMetrics(), (TypeInformation)Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.DOUBLE));
        metrics.getTransformation().setParallelism(1);
        String[] metricsNames = this.getMetricsNames();
        Object[] metricTypes = new TypeInformation[metricsNames.length];
        Arrays.fill(metricTypes, Types.DOUBLE);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])metricTypes, metricsNames);
        SingleOutputStreamOperator evalResult = metrics.map((MapFunction & Serializable)value -> {
            Row ret = new Row(metricsNames.length);
            for (int i = 0; i < metricsNames.length; ++i) {
                ret.setField(i, value.get(metricsNames[i]));
            }
            return ret;
        }, (TypeInformation)outputTypeInfo);
        return new Table[]{tEnv.fromDataStream((DataStream)evalResult)};
    }

    private static void updateBinaryMetrics(Tuple3<Double, Boolean, Double> cur, BinaryMetrics binaryMetrics, long[] countValues, double[] recordValues) {
        if (binaryMetrics.count == 0L) {
            recordValues[0] = countValues[2] == 0L ? 1.0 : 1.0 * (double)countValues[0] / (double)countValues[2];
            recordValues[1] = countValues[3] == 0L ? 1.0 : 1.0 * (double)countValues[1] / (double)countValues[3];
            recordValues[2] = countValues[0] + countValues[1] == 0L ? 1.0 : 1.0 * (double)countValues[0] / (double)(countValues[0] + countValues[1]);
            recordValues[3] = 1.0 * (double)(countValues[0] + countValues[1]) / (double)(countValues[2] + countValues[3]);
        }
        ++binaryMetrics.count;
        if (((Boolean)cur.f1).booleanValue()) {
            countValues[0] = countValues[0] + 1L;
        } else {
            countValues[1] = countValues[1] + 1L;
        }
        double tpr = countValues[2] == 0L ? 1.0 : 1.0 * (double)countValues[0] / (double)countValues[2];
        double fpr = countValues[3] == 0L ? 1.0 : 1.0 * (double)countValues[1] / (double)countValues[3];
        double precision = countValues[0] + countValues[1] == 0L ? 1.0 : 1.0 * (double)countValues[0] / (double)(countValues[0] + countValues[1]);
        double positiveRate = 1.0 * (double)(countValues[0] + countValues[1]) / (double)(countValues[2] + countValues[3]);
        binaryMetrics.areaUnderLorenz += (positiveRate - recordValues[3]) * (tpr + recordValues[0]) / 2.0;
        binaryMetrics.areaUnderPR += (tpr - recordValues[0]) * (precision + recordValues[2]) / 2.0;
        binaryMetrics.ks = Math.max(Math.abs(fpr - tpr), binaryMetrics.ks);
        recordValues[0] = tpr;
        recordValues[1] = fpr;
        recordValues[2] = precision;
        recordValues[3] = positiveRate;
    }

    private static long[] reduceBinarySummary(List<BinarySummary> values, int taskId) {
        ArrayList<BinarySummary> list = new ArrayList<BinarySummary>(values);
        list.sort(Comparator.comparingDouble(t -> -t.maxScore));
        long curTrue = 0L;
        long curFalse = 0L;
        long totalTrue = 0L;
        long totalFalse = 0L;
        for (BinarySummary statistics : list) {
            if (statistics.taskId == taskId) {
                curFalse = totalFalse;
                curTrue = totalTrue;
            }
            totalTrue += statistics.curPositive;
            totalFalse += statistics.curNegative;
        }
        return new long[]{curTrue, curFalse, totalTrue, totalFalse};
    }

    private static void updateBinarySummary(BinarySummary statistics, Tuple3<Double, Boolean, Double> evalElement) {
        if (((Boolean)evalElement.f1).booleanValue()) {
            ++statistics.curPositive;
        } else {
            ++statistics.curNegative;
        }
        if (Double.compare(statistics.maxScore, (Double)evalElement.f0) < 0) {
            statistics.maxScore = (Double)evalElement.f0;
        }
    }

    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata((Stage)this, (String)path);
    }

    public static BinaryClassificationEvaluator load(StreamTableEnvironment env, String path) throws IOException {
        return (BinaryClassificationEvaluator)ReadWriteUtils.loadStageParam((String)path);
    }

    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static DataStream<double[]> getBoundaryRange(DataStream<Tuple3<Double, Boolean, Double>> evalData) {
        DataStream sampleScoreStream = DataStreamUtils.mapPartition(evalData, (MapPartitionFunction)new MapPartitionFunction<Tuple3<Double, Boolean, Double>, double[]>(){

            public void mapPartition(Iterable<Tuple3<Double, Boolean, Double>> dataPoints, Collector<double[]> out) {
                ArrayList<Double> bufferedDataPoints = new ArrayList<Double>();
                for (Tuple3<Double, Boolean, Double> dataPoint : dataPoints) {
                    bufferedDataPoints.add((Double)dataPoint.f0);
                }
                double[] sampleScores = new double[100];
                Arrays.fill(sampleScores, Double.MAX_VALUE);
                Random rand = new Random();
                int sampleNum = bufferedDataPoints.size();
                if (sampleNum > 0) {
                    for (int i = 0; i < 100; ++i) {
                        sampleScores[i] = (Double)bufferedDataPoints.get(rand.nextInt(sampleNum));
                    }
                }
                out.collect((Object)sampleScores);
            }
        });
        final int parallel = sampleScoreStream.getParallelism();
        DataStream boundaryRange = DataStreamUtils.mapPartition((DataStream)sampleScoreStream, (MapPartitionFunction)new MapPartitionFunction<double[], double[]>(){

            public void mapPartition(Iterable<double[]> dataPoints, Collector<double[]> out) {
                double[] allSampleScore = new double[parallel * 100];
                int cnt = 0;
                for (double[] dataPoint : dataPoints) {
                    System.arraycopy(dataPoint, 0, allSampleScore, cnt * 100, 100);
                    ++cnt;
                }
                Arrays.sort(allSampleScore);
                double[] boundaryRange = new double[parallel];
                for (int i = 0; i < parallel; ++i) {
                    boundaryRange[i] = allSampleScore[i * 100];
                }
                out.collect((Object)boundaryRange);
            }
        });
        boundaryRange.getTransformation().setParallelism(1);
        return boundaryRange;
    }

    public static class BinaryMetrics {
        public long count;
        public double areaUnderROC;
        public double areaUnderLorenz;
        public double areaUnderPR;
        public double ks;

        public BinaryMetrics() {
        }

        public BinaryMetrics(long count, double areaUnderROC) {
            this.count = count;
            this.areaUnderROC = areaUnderROC;
        }

        public BinaryMetrics merge(BinaryMetrics binaryClassMetrics) {
            if (null == binaryClassMetrics) {
                return this;
            }
            Preconditions.checkState((Double.compare(this.areaUnderROC, binaryClassMetrics.areaUnderROC) == 0 ? 1 : 0) != 0, (Object)"AreaUnderROC not equal!");
            this.count += binaryClassMetrics.count;
            this.ks = Math.max(this.ks, binaryClassMetrics.ks);
            this.areaUnderPR += binaryClassMetrics.areaUnderPR;
            this.areaUnderLorenz += binaryClassMetrics.areaUnderLorenz;
            return this;
        }
    }

    public static class BinarySummary
    implements Serializable {
        public Integer taskId;
        public double maxScore;
        public long curPositive;
        public long curNegative;

        public BinarySummary() {
        }

        public BinarySummary(Integer taskId, double maxScore, long curPositive, long curNegative) {
            this.taskId = taskId;
            this.maxScore = maxScore;
            this.curPositive = curPositive;
            this.curNegative = curNegative;
        }
    }

    private static class ParseSample
    implements MapFunction<Row, Tuple3<Double, Boolean, Double>> {
        private final String labelCol;
        private final String rawPredictionCol;
        private final String weightCol;

        public ParseSample(String labelCol, String rawPredictionCol, String weightCol) {
            this.labelCol = labelCol;
            this.rawPredictionCol = rawPredictionCol;
            this.weightCol = weightCol;
        }

        public Tuple3<Double, Boolean, Double> map(Row value) throws Exception {
            double label = ((Number)value.getFieldAs(this.labelCol)).doubleValue();
            Object probOrigin = value.getField(this.rawPredictionCol);
            double prob = probOrigin instanceof Vector ? ((Vector)probOrigin).get(1) : ((Number)probOrigin).doubleValue();
            double weight = this.weightCol == null ? 1.0 : ((Number)value.getField(this.weightCol)).doubleValue();
            return Tuple3.of((Object)prob, (Object)(label == 1.0 ? 1 : 0), (Object)weight);
        }
    }

    private static class AppendTaskId
    extends RichMapFunction<Tuple3<Double, Boolean, Double>, Tuple4<Double, Boolean, Double, Integer>> {
        private double[] boundaryRange;
        private final String boundaryRangeKey;

        public AppendTaskId(String boundaryRangeKey) {
            this.boundaryRangeKey = boundaryRangeKey;
        }

        public Tuple4<Double, Boolean, Double, Integer> map(Tuple3<Double, Boolean, Double> value) throws Exception {
            if (this.boundaryRange == null) {
                this.boundaryRange = (double[])this.getRuntimeContext().getBroadcastVariable(this.boundaryRangeKey).get(0);
            }
            for (int i = this.boundaryRange.length - 1; i > 0; --i) {
                if (!((Double)value.f0 > this.boundaryRange[i])) continue;
                return Tuple4.of((Object)((Double)value.f0), (Object)((Boolean)value.f1), (Object)((Double)value.f2), (Object)i);
            }
            return Tuple4.of((Object)((Double)value.f0), (Object)((Boolean)value.f1), (Object)((Double)value.f2), (Object)0);
        }
    }

    private static class CalcSampleOrders
    extends RichFlatMapFunction<Tuple3<Double, Boolean, Double>, Tuple4<Double, Long, Boolean, Double>> {
        private long startIndex;
        private long total = -1L;
        private final String partitionSummariesKey;

        public CalcSampleOrders(String partitionSummariesKey) {
            this.partitionSummariesKey = partitionSummariesKey;
        }

        public void flatMap(Tuple3<Double, Boolean, Double> value, Collector<Tuple4<Double, Long, Boolean, Double>> out) throws Exception {
            if (this.total == -1L) {
                List statistics = this.getRuntimeContext().getBroadcastVariable(this.partitionSummariesKey);
                long[] countValues = BinaryClassificationEvaluator.reduceBinarySummary(statistics, this.getRuntimeContext().getIndexOfThisSubtask());
                this.startIndex = countValues[1] + countValues[0] + 1L;
                this.total = countValues[2] + countValues[3];
            }
            out.collect((Object)Tuple4.of((Object)((Double)value.f0), (Object)(this.total - this.startIndex + 1L), (Object)((Boolean)value.f1), (Object)((Double)value.f2)));
            ++this.startIndex;
        }
    }

    private static class CalcBinaryMetrics
    extends RichMapPartitionFunction<Tuple3<Double, Boolean, Double>, BinaryMetrics> {
        private final String partitionSummariesKey;

        public CalcBinaryMetrics(String partitionSummariesKey) {
            this.partitionSummariesKey = partitionSummariesKey;
        }

        public void mapPartition(Iterable<Tuple3<Double, Boolean, Double>> iterable, Collector<BinaryMetrics> collector) {
            List statistics = this.getRuntimeContext().getBroadcastVariable(this.partitionSummariesKey);
            long[] countValues = BinaryClassificationEvaluator.reduceBinarySummary(statistics, this.getRuntimeContext().getIndexOfThisSubtask());
            double areaUnderROC = (Double)this.getRuntimeContext().getBroadcastVariable("areaUnderROC").get(0);
            long totalTrue = countValues[2];
            long totalFalse = countValues[3];
            if (totalTrue == 0L) {
                LOG.warn("There is no positive sample in data!");
            }
            if (totalFalse == 0L) {
                LOG.warn("There is no negative sample in data!");
            }
            BinaryMetrics metrics = new BinaryMetrics(0L, areaUnderROC);
            double[] tprFprPrecision = new double[4];
            for (Tuple3<Double, Boolean, Double> t3 : iterable) {
                BinaryClassificationEvaluator.updateBinaryMetrics((Tuple3<Double, Boolean, Double>)t3, metrics, countValues, tprFprPrecision);
            }
            collector.collect((Object)metrics);
        }
    }

    private static class MergeMetrics
    implements MapPartitionFunction<BinaryMetrics, Map<String, Double>> {
        private MergeMetrics() {
        }

        public void mapPartition(Iterable<BinaryMetrics> values, Collector<Map<String, Double>> out) {
            Iterator<BinaryMetrics> iter = values.iterator();
            BinaryMetrics reduceMetrics = iter.next();
            while (iter.hasNext()) {
                reduceMetrics = reduceMetrics.merge(iter.next());
            }
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("areaUnderROC", reduceMetrics.areaUnderROC);
            map.put("areaUnderPR", reduceMetrics.areaUnderPR);
            map.put("areaUnderLorenz", reduceMetrics.areaUnderLorenz);
            map.put("ks", reduceMetrics.ks);
            out.collect(map);
        }
    }

    private static class PartitionSummaryOperator
    extends AbstractStreamOperator<BinarySummary>
    implements OneInputStreamOperator<Tuple3<Double, Boolean, Double>, BinarySummary>,
    BoundedOneInput {
        private ListState<BinarySummary> summaryState;
        private BinarySummary summary;

        private PartitionSummaryOperator() {
        }

        public void endInput() {
            if (this.summary != null) {
                this.output.collect((Object)new StreamRecord((Object)this.summary));
            }
        }

        public void processElement(StreamRecord<Tuple3<Double, Boolean, Double>> streamRecord) {
            BinaryClassificationEvaluator.updateBinarySummary(this.summary, (Tuple3<Double, Boolean, Double>)((Tuple3)streamRecord.getValue()));
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.summaryState = context.getOperatorStateStore().getListState(new ListStateDescriptor("summaryState", TypeInformation.of(BinarySummary.class)));
            this.summary = OperatorStateUtils.getUniqueElement(this.summaryState, (String)"summaryState").orElse(new BinarySummary(this.getRuntimeContext().getIndexOfThisSubtask(), -1.7976931348623157E308, 0L, 0L));
        }

        public void snapshotState(StateSnapshotContext context) throws Exception {
            super.snapshotState(context);
            this.summaryState.clear();
            if (this.summary != null) {
                this.summaryState.add((Object)this.summary);
            }
        }
    }

    private static class AccumulateMultiScoreOperator
    extends AbstractStreamOperator<double[]>
    implements OneInputStreamOperator<Tuple4<Double, Long, Boolean, Double>, double[]>,
    BoundedOneInput {
        private ListState<double[]> accValueState;
        private ListState<Double> scoreState;
        double[] accValue;
        double score;

        private AccumulateMultiScoreOperator() {
        }

        public void endInput() {
            if (this.accValue != null) {
                this.output.collect((Object)new StreamRecord((Object)new double[]{this.accValue[0] / this.accValue[1] * this.accValue[2], this.accValue[2], this.accValue[3]}));
            }
        }

        public void processElement(StreamRecord<Tuple4<Double, Long, Boolean, Double>> streamRecord) {
            Tuple4 t = (Tuple4)streamRecord.getValue();
            if (this.accValue == null) {
                this.accValue = new double[4];
                this.score = (Double)t.f0;
            } else if (this.score != (Double)t.f0) {
                this.output.collect((Object)new StreamRecord((Object)new double[]{this.accValue[0] / this.accValue[1] * this.accValue[2], this.accValue[2], this.accValue[3]}));
                Arrays.fill(this.accValue, 0.0);
            }
            this.accValue[0] = this.accValue[0] + (double)((Long)t.f1).longValue();
            this.accValue[1] = this.accValue[1] + 1.0;
            if (((Boolean)t.f2).booleanValue()) {
                this.accValue[2] = this.accValue[2] + (Double)t.f3;
            } else {
                this.accValue[3] = this.accValue[3] + (Double)t.f3;
            }
        }

        public void initializeState(StateInitializationContext context) throws Exception {
            super.initializeState(context);
            this.accValueState = context.getOperatorStateStore().getListState(new ListStateDescriptor("accValueState", TypeInformation.of(double[].class)));
            this.accValue = OperatorStateUtils.getUniqueElement(this.accValueState, (String)"accValueState").orElse(null);
            this.scoreState = context.getOperatorStateStore().getListState(new ListStateDescriptor("scoreState", TypeInformation.of(Double.class)));
            this.score = OperatorStateUtils.getUniqueElement(this.scoreState, (String)"scoreState").orElse(0.0);
        }

        public void snapshotState(StateSnapshotContext context) throws Exception {
            super.snapshotState(context);
            this.accValueState.clear();
            this.scoreState.clear();
            if (this.accValue != null) {
                this.accValueState.add((Object)this.accValue);
                this.scoreState.add((Object)this.score);
            }
        }
    }
}

